/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveCacheStatisticsImpl
implements LiveCacheStatistics,
LiveCacheStatisticsData {
    private static final Logger LOG = LoggerFactory.getLogger((String)LiveCacheStatisticsImpl.class.getName());
    private static final int MIN_MAX_DEFAULT_VALUE = -1;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int HIT_RATIO_MULTIPLIER = 100;
    private final AtomicBoolean statisticsEnabled = new AtomicBoolean(true);
    private final AtomicLong cacheHitInMemoryCount = new AtomicLong();
    private final AtomicLong cacheHitOffHeapCount = new AtomicLong();
    private final AtomicLong cacheHitOnDiskCount = new AtomicLong();
    private final AtomicLong cacheMissNotFound = new AtomicLong();
    private final AtomicLong cacheMissInMemoryCount = new AtomicLong();
    private final AtomicLong cacheMissOffHeapCount = new AtomicLong();
    private final AtomicLong cacheMissOnDiskCount = new AtomicLong();
    private final AtomicLong cacheMissExpired = new AtomicLong();
    private final AtomicLong cacheElementEvictedCount = new AtomicLong();
    private final AtomicLong totalGetTimeTakenNanos = new AtomicLong();
    private final AtomicLong cacheElementRemoved = new AtomicLong();
    private final AtomicLong cacheElementExpired = new AtomicLong();
    private final AtomicLong cacheElementPut = new AtomicLong();
    private final AtomicLong cacheElementUpdated = new AtomicLong();
    private final AtomicInteger statisticsAccuracy = new AtomicInteger();
    private final AtomicLong minGetTimeNanos = new AtomicLong(-1L);
    private final AtomicLong maxGetTimeNanos = new AtomicLong(-1L);
    private final AtomicLong xaCommitCount = new AtomicLong();
    private final AtomicLong xaRollbackCount = new AtomicLong();
    private final AtomicLong xaRecoveredCount = new AtomicLong();
    private final List<CacheUsageListener> listeners = new CopyOnWriteArrayList<CacheUsageListener>();
    private final Ehcache cache;

    public LiveCacheStatisticsImpl(Ehcache cache) {
        this.cache = cache;
    }

    public void clearStatistics() {
        this.cacheHitInMemoryCount.set(0L);
        this.cacheHitOffHeapCount.set(0L);
        this.cacheHitOnDiskCount.set(0L);
        this.cacheMissExpired.set(0L);
        this.cacheMissNotFound.set(0L);
        this.cacheMissInMemoryCount.set(0L);
        this.cacheMissOffHeapCount.set(0L);
        this.cacheMissOnDiskCount.set(0L);
        this.cacheElementEvictedCount.set(0L);
        this.totalGetTimeTakenNanos.set(0L);
        this.cacheElementRemoved.set(0L);
        this.cacheElementExpired.set(0L);
        this.cacheElementPut.set(0L);
        this.cacheElementUpdated.set(0L);
        this.minGetTimeNanos.set(-1L);
        this.maxGetTimeNanos.set(-1L);
        this.xaCommitCount.set(0L);
        this.xaRollbackCount.set(0L);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsCleared();
        }
    }

    public void xaCommit() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaCommitCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyXaCommit();
        }
    }

    public void xaRollback() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaRollbackCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyXaRollback();
        }
    }

    public void xaRecovered(int count) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.xaRecoveredCount.addAndGet(count);
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        if (enableStatistics) {
            this.clearStatistics();
        }
        this.statisticsEnabled.set(enableStatistics);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsEnabledChanged(enableStatistics);
        }
    }

    public void addGetTimeNanos(long nanos) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.totalGetTimeTakenNanos.addAndGet(nanos);
        for (CacheUsageListener l : this.listeners) {
            l.notifyGetTimeNanos(nanos);
            l.notifyTimeTakenForGet(nanos / 1000000L);
        }
        if (this.minGetTimeNanos.get() == -1L || nanos < this.minGetTimeNanos.get()) {
            this.minGetTimeNanos.set(nanos);
        }
        if (this.maxGetTimeNanos.get() == -1L || nanos > this.maxGetTimeNanos.get() && nanos > 0L) {
            this.maxGetTimeNanos.set(nanos);
        }
    }

    public void addGetTimeMillis(long millis) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.totalGetTimeTakenNanos.addAndGet(millis);
        for (CacheUsageListener l : this.listeners) {
            l.notifyTimeTakenForGet(millis);
        }
        if (this.minGetTimeNanos.get() == -1L || millis < this.minGetTimeNanos.get()) {
            this.minGetTimeNanos.set(millis);
        }
        if (this.maxGetTimeNanos.get() == -1L || millis > this.maxGetTimeNanos.get() && millis > 0L) {
            this.maxGetTimeNanos.set(millis);
        }
    }

    public void cacheHitInMemory() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitInMemoryCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheHitInMemory();
        }
    }

    public void cacheHitOffHeap() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitOffHeapCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheHitOffHeap();
        }
    }

    public void cacheHitOnDisk() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitOnDiskCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheHitOnDisk();
        }
    }

    public void cacheMissExpired() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissExpired.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissedWithExpired();
        }
    }

    public void cacheMissNotFound() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissNotFound.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissedWithNotFound();
        }
    }

    public void cacheMissInMemory() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissInMemoryCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissInMemory();
        }
    }

    public void cacheMissOffHeap() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissOffHeapCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissOffHeap();
        }
    }

    public void cacheMissOnDisk() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissOnDiskCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissOnDisk();
        }
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        if (!Statistics.isValidStatisticsAccuracy(statisticsAccuracy)) {
            throw new IllegalArgumentException("Invalid statistics accuracy value: " + statisticsAccuracy);
        }
        this.statisticsAccuracy.set(statisticsAccuracy);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsAccuracyChanged(statisticsAccuracy);
        }
    }

    public void dispose() {
        for (CacheUsageListener l : this.listeners) {
            l.dispose();
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementEvictedCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementEvicted();
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementExpired.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementExpired();
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementPut.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementPut();
        }
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementRemoved.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementRemoved();
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementUpdated.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementUpdated();
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        for (CacheUsageListener l : this.listeners) {
            l.notifyRemoveAll();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    public float getAverageGetTimeMillis() {
        return (float)this.getAverageGetTimeNanos() / 1000000.0f;
    }

    public long getAverageGetTimeNanos() {
        long accessCount = this.getCacheHitCount() + this.getCacheMissCount();
        if (accessCount == 0L) {
            return 0L;
        }
        return this.totalGetTimeTakenNanos.get() / accessCount;
    }

    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        if (!this.isStatisticsEnabled()) {
            LOG.warn("Registering a CacheUsageListener on {} whose statistics are currently disabled.  No events will be fired until statistics are enabled.", (Object)this.cache.getName());
        }
        this.listeners.add(cacheUsageListener);
    }

    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.listeners.remove(cacheUsageListener);
    }

    public long getCacheHitCount() {
        return this.cacheHitInMemoryCount.get() + this.cacheHitOffHeapCount.get() + this.cacheHitOnDiskCount.get();
    }

    public long getCacheMissCount() {
        return this.cacheMissNotFound.get() + this.cacheMissExpired.get();
    }

    public long getInMemoryMissCount() {
        return this.cacheMissInMemoryCount.get();
    }

    public long getOffHeapMissCount() {
        return this.cacheMissOffHeapCount.get();
    }

    public long getOnDiskMissCount() {
        return this.cacheMissOnDiskCount.get();
    }

    public long getCacheMissCountExpired() {
        return this.cacheMissExpired.get();
    }

    public int getCacheHitRatio() {
        long hits = this.getCacheHitCount();
        long accesses = hits + this.getCacheMissCount();
        return (int)(accesses == 0L ? 0.0 : (double)hits / (double)accesses * 100.0);
    }

    public long getEvictedCount() {
        return this.cacheElementEvictedCount.get();
    }

    public long getInMemoryHitCount() {
        return this.cacheHitInMemoryCount.get();
    }

    public long getOffHeapHitCount() {
        return this.cacheHitOffHeapCount.get();
    }

    public long getOnDiskHitCount() {
        return this.cacheHitOnDiskCount.get();
    }

    public long getSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getSizeBasedOnAccuracy(this.statisticsAccuracy.get());
    }

    @Deprecated
    public long getInMemorySize() {
        return this.getLocalHeapSize();
    }

    @Deprecated
    public long getOffHeapSize() {
        return this.getLocalOffHeapSize();
    }

    @Deprecated
    public long getOnDiskSize() {
        return this.getLocalDiskSize();
    }

    public long getLocalHeapSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getMemoryStoreSize();
    }

    public long getLocalOffHeapSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getOffHeapStoreSize();
    }

    public long getLocalDiskSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getDiskStoreSize();
    }

    public long getLocalDiskSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateOnDiskSize();
    }

    public long getLocalHeapSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateInMemorySize();
    }

    public long getLocalOffHeapSizeInBytes() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.calculateOffHeapSize();
    }

    public String getCacheName() {
        return this.cache.getName();
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy.get();
    }

    public long getExpiredCount() {
        return this.cacheElementExpired.get();
    }

    public long getPutCount() {
        return this.cacheElementPut.get();
    }

    public long getRemovedCount() {
        return this.cacheElementRemoved.get();
    }

    public long getUpdateCount() {
        return this.cacheElementUpdated.get();
    }

    public String getStatisticsAccuracyDescription() {
        int value = this.statisticsAccuracy.get();
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    public long getMaxGetTimeMillis() {
        return this.maxGetTimeNanos.get() / 1000000L;
    }

    public long getMinGetTimeMillis() {
        return this.minGetTimeNanos.get() / 1000000L;
    }

    public long getMaxGetTimeNanos() {
        return this.maxGetTimeNanos.get();
    }

    public long getMinGetTimeNanos() {
        return this.minGetTimeNanos.get();
    }

    public long getXaCommitCount() {
        return this.xaCommitCount.get();
    }

    public long getXaRollbackCount() {
        return this.xaRollbackCount.get();
    }

    public long getXaRecoveredCount() {
        return this.xaRecoveredCount.get();
    }

    public long getWriterQueueLength() {
        CacheWriterManager writerManager = this.cache.getWriterManager();
        if (writerManager instanceof WriteBehindManager) {
            return ((WriteBehindManager)writerManager).getQueueSize();
        }
        return 0L;
    }
}

