/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hive.beeline.BeeLine;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.LauncherMain;

public class Hive2Main
extends LauncherMain {
    @VisibleForTesting
    static final Pattern[] HIVE2_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Ended Job = (job_\\S*)"), Pattern.compile("Submitted application (application[0-9_]*)"), Pattern.compile("Running with YARN Application = (application[0-9_]*)")};
    private static final Set<String> DISALLOWED_BEELINE_OPTIONS = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        Hive2Main.run(Hive2Main.class, (String[])args);
    }

    private static Configuration initActionConf() {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        System.out.println("Using action configuration file " + actionXml);
        actionConf.addResource(new Path("file:///", actionXml));
        Hive2Main.setYarnTag((Configuration)actionConf);
        String delegationToken = Hive2Main.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            actionConf.set("mapreduce.job.credentials.binary", delegationToken);
            actionConf.set("tez.credentials.path", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        actionConf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        return actionConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void run(String[] args) throws Exception {
        String[] files;
        System.out.println();
        System.out.println("Oozie Hive 2 action configuration");
        System.out.println("=================================================================");
        System.out.println();
        Configuration actionConf = Hive2Main.initActionConf();
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("hive2-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        ArrayList<String> arguments = new ArrayList<String>();
        String jdbcUrl = actionConf.get("oozie.hive2.jdbc.url");
        if (jdbcUrl == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.hive2.jdbc.url] property");
        }
        arguments.add("-u");
        arguments.add(jdbcUrl);
        String username = actionConf.get("user.name");
        arguments.add("-n");
        arguments.add(username);
        String password = actionConf.get("oozie.hive2.password");
        if (password == null) {
            password = "DUMMY";
        }
        arguments.add("-p");
        arguments.add(password);
        arguments.add("-d");
        arguments.add("org.apache.hive.jdbc.HiveDriver");
        String scriptPath = actionConf.get("oozie.hive2.script");
        String query = actionConf.get("oozie.hive2.query");
        if (scriptPath != null) {
            if (!new File(scriptPath).exists()) {
                throw new RuntimeException("Hive 2 script file [" + scriptPath + "] does not exist");
            }
            File localDir = new File("dummy").getAbsoluteFile().getParentFile();
            System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
            System.out.println("------------------------");
            files = localDir.list();
            if (files != null) {
                String[] stringArray = files;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String file = stringArray[i];
                    System.out.println("  " + file);
                }
            }
            System.out.println("------------------------");
            System.out.println();
            String script = Hive2Main.readStringFromFile(scriptPath);
            System.out.println();
            System.out.println("Script [" + scriptPath + "] content: ");
            System.out.println("------------------------");
            System.out.println(script);
            System.out.println("------------------------");
            System.out.println();
            arguments.add("-f");
            arguments.add(scriptPath);
        } else if (query != null) {
            System.out.println("Query: ");
            System.out.println("------------------------");
            System.out.println(query);
            System.out.println("------------------------");
            System.out.println();
            String filename = this.createScriptFile(query);
            arguments.add("-f");
            arguments.add(filename);
        } else {
            throw new RuntimeException("Action Configuration does not have [oozie.hive2.script], or [oozie.hive2.query] property");
        }
        String[] params = ActionUtils.getStrings((Configuration)actionConf, (String)"oozie.hive2.params");
        if (params.length > 0) {
            void var14_18;
            System.out.println("Parameters:");
            System.out.println("------------------------");
            files = params;
            int n = files.length;
            boolean bl = false;
            while (var14_18 < n) {
                String param = files[var14_18];
                System.out.println("  " + param);
                int idx = param.indexOf(61);
                if (idx == -1) {
                    throw new RuntimeException("Parameter expression must contain an assignment: " + param);
                }
                if (idx == 0) {
                    throw new RuntimeException("Parameter value not specified: " + param);
                }
                arguments.add("--hivevar");
                arguments.add(param);
                ++var14_18;
            }
            System.out.println("------------------------");
            System.out.println();
        }
        arguments.add("-a");
        arguments.add("delegationToken");
        String[] beelineArgs = ActionUtils.getStrings((Configuration)actionConf, (String)"oozie.hive2.args");
        for (String beelineArg : beelineArgs) {
            if (DISALLOWED_BEELINE_OPTIONS.contains(beelineArg)) {
                throw new RuntimeException("Error: Beeline argument " + beelineArg + " is not supported");
            }
            arguments.add(beelineArg);
        }
        if (actionConf.get("mapreduce.job.tags") != null) {
            arguments.add("--hiveconf");
            arguments.add("mapreduce.job.tags=" + actionConf.get("mapreduce.job.tags"));
        }
        for (Map.Entry entry : actionConf.getValByRegex("^oozie\\.(?!launcher|hive2).+").entrySet()) {
            arguments.add("--hiveconf");
            arguments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        System.out.println("Beeline command arguments :");
        for (String string : arguments) {
            System.out.println("             " + string);
        }
        System.out.println();
        LauncherMain.killChildYarnJobs((Configuration)actionConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Beeline command line now >>>");
        System.out.println();
        System.out.flush();
        try {
            this.runBeeline(arguments.toArray(new String[arguments.size()]), logFile);
        }
        finally {
            System.out.println("\n<<< Invocation of Beeline command completed <<<\n");
            Hive2Main.writeExternalChildIDs((String)logFile, (Pattern[])HIVE2_JOB_IDS_PATTERNS, (String)"Beeline");
        }
    }

    private String createScriptFile(String query) throws IOException {
        String filename = "oozie-hive2-query-" + System.currentTimeMillis() + ".hql";
        File f = new File(filename);
        FileUtils.writeStringToFile((File)f, (String)query, (String)"UTF-8");
        return filename;
    }

    private void runBeeline(String[] args, String logFile) throws Exception {
        BeeLine beeLine = new BeeLine();
        beeLine.setErrorStream(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)System.err, (OutputStream)new FileOutputStream(logFile)), false, "UTF-8"));
        int status = beeLine.begin(args, null);
        beeLine.close();
        if (status != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromFile(String filePath) throws IOException {
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = br.readLine()) != null) {
                sb.append(line).append(sep);
            }
            String string = sb.toString();
            return string;
        }
    }

    static {
        DISALLOWED_BEELINE_OPTIONS.add("-u");
        DISALLOWED_BEELINE_OPTIONS.add("-n");
        DISALLOWED_BEELINE_OPTIONS.add("-p");
        DISALLOWED_BEELINE_OPTIONS.add("-d");
        DISALLOWED_BEELINE_OPTIONS.add("-e");
        DISALLOWED_BEELINE_OPTIONS.add("-f");
        DISALLOWED_BEELINE_OPTIONS.add("-a");
        DISALLOWED_BEELINE_OPTIONS.add("--help");
    }
}

