/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.LauncherMain;

public class HiveMain
extends LauncherMain {
    @VisibleForTesting
    static final Pattern[] HIVE_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Ended Job = (job_\\S*)"), Pattern.compile("Submitted application (application[0-9_]*)")};
    private static final Set<String> DISALLOWED_HIVE_OPTIONS = new HashSet<String>();
    public static final String HIVE_L4J_PROPS = "hive-log4j.properties";
    public static final String HIVE_EXEC_L4J_PROPS = "hive-exec-log4j.properties";
    public static final String HIVE_SITE_CONF = "hive-site.xml";

    public static void main(String[] args) throws Exception {
        HiveMain.run(HiveMain.class, (String[])args);
    }

    private static Configuration initActionConf() throws IOException {
        Configuration hiveConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        System.out.println("Using action configuration file " + actionXml);
        hiveConf.addResource(new Path("file:///", actionXml));
        HiveMain.setYarnTag((Configuration)hiveConf);
        HiveMain.setApplicationTags((Configuration)hiveConf, (String)"tez.application.tags");
        String delegationToken = HiveMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            hiveConf.set("mapreduce.job.credentials.binary", delegationToken);
            hiveConf.set("tez.credentials.path", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for tez.credentials.path to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("tez.credentials.path", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        if (hiveConf.get("mapred.job.name", "").startsWith("oozie:action:")) {
            hiveConf.set("mapred.job.name", "");
        }
        hiveConf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        hiveConf.setBoolean("hive.exec.mode.local.auto", false);
        String pwd = new File("").getCanonicalPath();
        hiveConf.set("hive.querylog.location", pwd + File.separator + "hivetmp" + File.separator + "querylog");
        hiveConf.set("hive.exec.local.scratchdir", pwd + File.separator + "hivetmp" + File.separator + "scratchdir");
        return hiveConf;
    }

    private String setUpHiveLog4J(Configuration hiveConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("hive-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        String logLevel = hiveConf.get("oozie.hive.log.level", "INFO");
        String rootLogLevel = hiveConf.get("oozie.action.rootlogger.log.level", "INFO");
        this.log4jProperties.setProperty("log4j.rootLogger", rootLogLevel + ", A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.hive", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.hadoop.hive", "false");
        this.log4jProperties.setProperty("log4j.logger.hive", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.hive", "false");
        this.log4jProperties.setProperty("log4j.logger.DataNucleus", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.DataNucleus", "false");
        this.log4jProperties.setProperty("log4j.logger.DataStore", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.DataStore", "false");
        this.log4jProperties.setProperty("log4j.logger.JPOX", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.JPOX", "false");
        this.log4jProperties.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        this.log4jProperties.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.A.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        this.log4jProperties.setProperty("log4j.appender.jobid.file", logFile);
        this.log4jProperties.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.hive.ql.exec", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.hadoop.hive.ql.exec", "false");
        this.log4jProperties.setProperty("log4j.logger.SessionState", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.additivity.SessionState", "false");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "false");
        HiveMain.createFileWithContentIfNotExists((String)new File(HIVE_L4J_PROPS).getAbsolutePath(), (Properties)this.log4jProperties);
        HiveMain.createFileWithContentIfNotExists((String)new File(HIVE_EXEC_L4J_PROPS).getAbsolutePath(), (Properties)this.log4jProperties);
        return logFile;
    }

    public static Configuration setUpHiveSite() throws Exception {
        Configuration hiveConf = HiveMain.initActionConf();
        URL hiveSiteURL = HiveMain.createFileWithContentIfNotExists((String)HIVE_SITE_CONF, (Configuration)hiveConf);
        HiveMain.logMasking((String)"Hive Configuration Properties:", (Iterable)hiveConf);
        HiveConf.setHiveSiteLocation((URL)hiveSiteURL);
        return hiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        System.out.println();
        System.out.println("Oozie Hive action configuration");
        System.out.println("=================================================================");
        System.out.println();
        Configuration hiveConf = HiveMain.setUpHiveSite();
        ArrayList<String> arguments = new ArrayList<String>();
        String logFile = this.setUpHiveLog4J(hiveConf);
        arguments.add("--hiveconf");
        arguments.add("hive.log4j.file=" + new File(HIVE_L4J_PROPS).getAbsolutePath());
        arguments.add("--hiveconf");
        arguments.add("hive.exec.log4j.file=" + new File(HIVE_EXEC_L4J_PROPS).getAbsolutePath());
        String callerId = "oozie:" + System.getProperty("oozie.job.id");
        arguments.add("--hiveconf");
        arguments.add("hive.log.trace.id=" + callerId);
        String scriptPath = hiveConf.get("oozie.hive.script");
        String query = hiveConf.get("oozie.hive.query");
        if (scriptPath != null) {
            if (!new File(scriptPath).exists()) {
                throw new RuntimeException("Hive script file [" + scriptPath + "] does not exist");
            }
            File localDir = new File("dummy").getAbsoluteFile().getParentFile();
            System.out.println("Current (local) dir = " + localDir.getAbsolutePath());
            System.out.println("------------------------");
            String[] files = localDir.list();
            if (files != null) {
                String[] stringArray = files;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String file = stringArray[i];
                    System.out.println("  " + file);
                }
            }
            System.out.println("------------------------");
            System.out.println();
            String script = HiveMain.readStringFromFile(scriptPath);
            System.out.println();
            System.out.println("Script [" + scriptPath + "] content: ");
            System.out.println("------------------------");
            System.out.println(script);
            System.out.println("------------------------");
            System.out.println();
            arguments.add("-f");
            arguments.add(scriptPath);
        } else if (query != null) {
            System.out.println("Query: ");
            System.out.println("------------------------");
            System.out.println(query);
            System.out.println("------------------------");
            System.out.println();
            String filename = this.createScriptFile(query);
            arguments.add("-f");
            arguments.add(filename);
        } else {
            throw new RuntimeException("Action Configuration does not have [oozie.hive.script], or [oozie.hive.query] property");
        }
        String[] params = ActionUtils.getStrings((Configuration)hiveConf, (String)"oozie.hive.params");
        if (params.length > 0) {
            System.out.println("Parameters:");
            System.out.println("------------------------");
            for (String param : params) {
                System.out.println("  " + param);
                int idx = param.indexOf(61);
                if (idx == -1) {
                    throw new RuntimeException("Parameter expression must contain an assignment: " + param);
                }
                if (idx == 0) {
                    throw new RuntimeException("Parameter value not specified: " + param);
                }
                arguments.add("--hivevar");
                arguments.add(param);
            }
            System.out.println("------------------------");
            System.out.println();
        }
        String[] hiveArgs = ActionUtils.getStrings((Configuration)hiveConf, (String)"oozie.hive.args");
        for (String hiveArg : hiveArgs) {
            if (DISALLOWED_HIVE_OPTIONS.contains(hiveArg)) {
                throw new RuntimeException("Error: Hive argument " + hiveArg + " is not supported");
            }
            arguments.add(hiveArg);
        }
        System.out.println("Hive command arguments :");
        for (String arg : arguments) {
            System.out.println("             " + arg);
        }
        System.out.println();
        LauncherMain.killChildYarnJobs((Configuration)hiveConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Hive command line now >>>");
        System.out.println();
        System.out.flush();
        try {
            this.runHive(arguments.toArray(new String[arguments.size()]));
        }
        finally {
            System.out.println("\n<<< Invocation of Hive command completed <<<\n");
            HiveMain.writeExternalChildIDs((String)logFile, (Pattern[])HIVE_JOB_IDS_PATTERNS, (String)"Hive");
        }
    }

    private String createScriptFile(String query) throws IOException {
        String filename = "oozie-hive-query-" + System.currentTimeMillis() + ".hql";
        File f = new File(filename);
        FileUtils.writeStringToFile((File)f, (String)query, (String)"UTF-8");
        return filename;
    }

    private void runHive(String[] args) throws Exception {
        CliDriver.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromFile(String filePath) throws IOException {
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = br.readLine()) != null) {
                sb.append(line).append(sep);
            }
            String string = sb.toString();
            return string;
        }
    }

    static {
        DISALLOWED_HIVE_OPTIONS.add("-d");
        DISALLOWED_HIVE_OPTIONS.add("--define");
        DISALLOWED_HIVE_OPTIONS.add("-e");
        DISALLOWED_HIVE_OPTIONS.add("-f");
        DISALLOWED_HIVE_OPTIONS.add("-H");
        DISALLOWED_HIVE_OPTIONS.add("--help");
        DISALLOWED_HIVE_OPTIONS.add("--hiveconf");
        DISALLOWED_HIVE_OPTIONS.add("--hivevar");
        DISALLOWED_HIVE_OPTIONS.add("-s");
        DISALLOWED_HIVE_OPTIONS.add("--silent");
        DISALLOWED_HIVE_OPTIONS.add("-D");
    }
}

