/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;

public class PlacementManager {
    private static final Log LOG = LogFactory.getLog(PlacementManager.class);
    List<PlacementRule> rules;
    ReentrantReadWriteLock.ReadLock readLock;
    ReentrantReadWriteLock.WriteLock writeLock;

    public PlacementManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void updateRules(List<PlacementRule> rules) {
        try {
            this.writeLock.lock();
            this.rules = rules;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void placeApplication(ApplicationSubmissionContext asc, String user) throws YarnException {
        try {
            PlacementRule rule;
            this.readLock.lock();
            if (null == this.rules || this.rules.isEmpty()) {
                return;
            }
            String newQueueName = null;
            Iterator<PlacementRule> iterator = this.rules.iterator();
            while (iterator.hasNext() && (newQueueName = (rule = iterator.next()).getQueueForApp(asc, user)) == null) {
            }
            if (null == newQueueName && null == asc.getQueue()) {
                String msg = "Failed to get where to place application=" + asc.getApplicationId();
                LOG.error((Object)msg);
                throw new YarnException(msg);
            }
            if (!StringUtils.equals((String)asc.getQueue(), newQueueName)) {
                LOG.info((Object)("Placed application=" + asc.getApplicationId() + " to queue=" + newQueueName + ", original queue=" + asc.getQueue()));
                asc.setQueue(newQueueName);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public List<PlacementRule> getPlacementRules() {
        return this.rules;
    }
}

