/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RegularContainerAllocator
extends AbstractContainerAllocator {
    private static final Log LOG = LogFactory.getLog(RegularContainerAllocator.class);

    public RegularContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext, ActivitiesManager activitiesManager) {
        super(application, rc, rmContext, activitiesManager);
    }

    private boolean checkHeadroom(Resource clusterResource, ResourceLimits currentResourceLimits, Resource required, String nodePartition) {
        Resource resourceCouldBeUnReserved = this.application.getCurrentReservation();
        if (!this.application.getCSLeafQueue().getReservationContinueLooking() || !nodePartition.equals("")) {
            resourceCouldBeUnReserved = Resources.none();
        }
        return Resources.greaterThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.add((Resource)currentResourceLimits.getHeadroom(), (Resource)resourceCouldBeUnReserved), (Resource)required);
    }

    private ContainerAllocation preCheckForNodeCandidateSet(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, SchedulingMode schedulingMode, ResourceLimits resourceLimits, SchedulerRequestKey schedulerKey) {
        Priority priority = schedulerKey.getPriority();
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        PendingAsk offswitchPendingAsk = this.application.getPendingAsk(schedulerKey, "*");
        if (offswitchPendingAsk.getCount() <= 0) {
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Priority skipped because off-switch request is null");
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        Resource required = offswitchPendingAsk.getPerAllocationResource();
        if (this.application.getOutstandingAsksCount(schedulerKey) <= 0) {
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Application priority does not need more resource");
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY && this.application.isWaitingForAMContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip allocating AM container to app_attempt=" + this.application.getApplicationAttemptId() + ", don't allow to allocate AM container in non-exclusive mode"));
            }
            this.application.updateAppSkipNodeDiagnostics("Skipping assigning to Node in Ignore Exclusivity mode. ");
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Skipping assigning to Node in Ignore Exclusivity mode");
            return ContainerAllocation.APP_SKIPPED;
        }
        if (!this.appInfo.acceptNodePartition(schedulerKey, node.getPartition(), schedulingMode)) {
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Priority skipped because partition of node doesn't match request");
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (!this.application.getCSLeafQueue().getReservationContinueLooking() && !this.shouldAllocOrReserveNewContainer(schedulerKey, required)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"doesn't need containers based on reservation algo!");
            }
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Doesn't need containers based on reservation algo!");
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (!this.checkHeadroom(clusterResource, resourceLimits, required, candidates.getPartition())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cannot allocate required resource=" + required + " because of headroom"));
            }
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Queue skipped because of headroom");
            return ContainerAllocation.QUEUE_SKIPPED;
        }
        int missedNonPartitionedRequestSchedulingOpportunity = 0;
        if (StringUtils.equals((String)"", (String)this.appInfo.getAppPlacementAllocator(schedulerKey).getPrimaryRequestedNodePartition())) {
            missedNonPartitionedRequestSchedulingOpportunity = this.application.addMissedNonPartitionedRequestSchedulingOpportunity(schedulerKey);
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY && missedNonPartitionedRequestSchedulingOpportunity < this.rmContext.getScheduler().getNumClusterNodes()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip app_attempt=" + this.application.getApplicationAttemptId() + " priority=" + schedulerKey.getPriority() + " because missed-non-partitioned-resource-request opportunity under required: Now=" + missedNonPartitionedRequestSchedulingOpportunity + " required=" + this.rmContext.getScheduler().getNumClusterNodes()));
            }
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Non-partitioned resource request should be scheduled to non-partitioned partition first");
            return ContainerAllocation.APP_SKIPPED;
        }
        return null;
    }

    private ContainerAllocation checkIfNodeBlackListed(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey) {
        Priority priority = schedulerKey.getPriority();
        if (SchedulerAppUtils.isPlaceBlacklisted(this.application, node, LOG)) {
            this.application.updateAppSkipNodeDiagnostics("Skipped scheduling for this Node as its black listed. ");
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Skip black listed node");
            return ContainerAllocation.APP_SKIPPED;
        }
        return null;
    }

    ContainerAllocation tryAllocateOnNode(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, SchedulerRequestKey schedulerKey, RMContainer reservedContainer) {
        ContainerAllocation result = this.checkIfNodeBlackListed(node, schedulerKey);
        if (null != result) {
            return result;
        }
        this.application.addSchedulingOpportunity(schedulerKey);
        result = this.assignContainersOnNode(clusterResource, node, schedulerKey, reservedContainer, schedulingMode, resourceLimits);
        if (null == reservedContainer && result.state == AllocationState.PRIORITY_SKIPPED) {
            this.application.subtractSchedulingOpportunity(schedulerKey);
        }
        return result;
    }

    public float getLocalityWaitFactor(SchedulerRequestKey schedulerKey, int clusterNodes) {
        int requiredResources = Math.max(this.application.getAppPlacementAllocator(schedulerKey).getUniqueLocationAsks() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    private int getActualNodeLocalityDelay() {
        return Math.min(this.rmContext.getScheduler().getNumClusterNodes(), this.application.getCSLeafQueue().getNodeLocalityDelay());
    }

    private int getActualRackLocalityDelay() {
        return Math.min(this.rmContext.getScheduler().getNumClusterNodes(), this.application.getCSLeafQueue().getNodeLocalityDelay() + this.application.getCSLeafQueue().getRackLocalityAdditionalDelay());
    }

    private boolean canAssign(SchedulerRequestKey schedulerKey, FiCaSchedulerNode node, NodeType type, RMContainer reservedContainer) {
        if (type == NodeType.OFF_SWITCH) {
            if (reservedContainer != null) {
                return true;
            }
            if (this.rmContext.getScheduler().getNumClusterNodes() == 0) {
                return false;
            }
            if (this.application.getResourceRequests(schedulerKey).size() == 1) {
                return true;
            }
            long missedOpportunities = this.application.getSchedulingOpportunities(schedulerKey);
            if (this.application.getCSLeafQueue().getRackLocalityAdditionalDelay() > -1) {
                return missedOpportunities > (long)this.getActualRackLocalityDelay();
            }
            long requiredContainers = this.application.getOutstandingAsksCount(schedulerKey);
            float localityWaitFactor = this.getLocalityWaitFactor(schedulerKey, this.rmContext.getScheduler().getNumClusterNodes());
            return Math.min((float)this.rmContext.getScheduler().getNumClusterNodes(), (float)requiredContainers * localityWaitFactor) < (float)missedOpportunities;
        }
        if (this.application.getOutstandingAsksCount(schedulerKey, node.getRackName()) <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            long missedOpportunities = this.application.getSchedulingOpportunities(schedulerKey);
            return (long)this.getActualNodeLocalityDelay() < missedOpportunities;
        }
        if (type == NodeType.NODE_LOCAL) {
            return this.application.getOutstandingAsksCount(schedulerKey, node.getNodeName()) > 0;
        }
        return false;
    }

    private ContainerAllocation assignNodeLocalContainers(Resource clusterResource, PendingAsk nodeLocalAsk, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(schedulerKey, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, schedulerKey, nodeLocalAsk, NodeType.NODE_LOCAL, reservedContainer, schedulingMode, currentResoureLimits);
        }
        ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, schedulerKey.getPriority(), "Skip node-local request");
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    private ContainerAllocation assignRackLocalContainers(Resource clusterResource, PendingAsk rackLocalAsk, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(schedulerKey, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, schedulerKey, rackLocalAsk, NodeType.RACK_LOCAL, reservedContainer, schedulingMode, currentResoureLimits);
        }
        ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, schedulerKey.getPriority(), "Skip rack-local request");
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    private ContainerAllocation assignOffSwitchContainers(Resource clusterResource, PendingAsk offSwitchAsk, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(schedulerKey, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, schedulerKey, offSwitchAsk, NodeType.OFF_SWITCH, reservedContainer, schedulingMode, currentResoureLimits);
        }
        this.application.updateAppSkipNodeDiagnostics("Skipping assigning to Node as request locality is not matching. ");
        ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, schedulerKey.getPriority(), "Skip offswitch request");
        return ContainerAllocation.APP_SKIPPED;
    }

    private ContainerAllocation assignContainersOnNode(Resource clusterResource, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        PendingAsk offSwitchAsk;
        PendingAsk rackLocalAsk;
        ContainerAllocation allocation;
        Priority priority = schedulerKey.getPriority();
        NodeType requestLocalityType = null;
        PendingAsk nodeLocalAsk = this.application.getPendingAsk(schedulerKey, node.getNodeName());
        if (nodeLocalAsk.getCount() > 0) {
            requestLocalityType = NodeType.NODE_LOCAL;
            allocation = this.assignNodeLocalContainers(clusterResource, nodeLocalAsk, node, schedulerKey, reservedContainer, schedulingMode, currentResoureLimits);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)allocation.getResourceToBeAllocated(), (Resource)Resources.none())) {
                allocation.requestLocalityType = requestLocalityType;
                return allocation;
            }
        }
        if ((rackLocalAsk = this.application.getPendingAsk(schedulerKey, node.getRackName())).getCount() > 0) {
            if (!this.appInfo.canDelayTo(schedulerKey, node.getRackName())) {
                ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Priority skipped because of relax locality is not allowed");
                return ContainerAllocation.PRIORITY_SKIPPED;
            }
            requestLocalityType = requestLocalityType == null ? NodeType.RACK_LOCAL : requestLocalityType;
            allocation = this.assignRackLocalContainers(clusterResource, rackLocalAsk, node, schedulerKey, reservedContainer, schedulingMode, currentResoureLimits);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)allocation.getResourceToBeAllocated(), (Resource)Resources.none())) {
                allocation.requestLocalityType = requestLocalityType;
                return allocation;
            }
        }
        if ((offSwitchAsk = this.application.getPendingAsk(schedulerKey, "*")).getCount() > 0) {
            if (!this.appInfo.canDelayTo(schedulerKey, "*")) {
                ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Priority skipped because of relax locality is not allowed");
                return ContainerAllocation.PRIORITY_SKIPPED;
            }
            requestLocalityType = requestLocalityType == null ? NodeType.OFF_SWITCH : requestLocalityType;
            allocation = this.assignOffSwitchContainers(clusterResource, offSwitchAsk, node, schedulerKey, reservedContainer, schedulingMode, currentResoureLimits);
            if (allocation.state == AllocationState.LOCALITY_SKIPPED) {
                allocation.state = AllocationState.APP_SKIPPED;
            }
            allocation.requestLocalityType = requestLocalityType;
            return allocation;
        }
        ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Priority skipped");
        return ContainerAllocation.PRIORITY_SKIPPED;
    }

    private ContainerAllocation assignContainer(Resource clusterResource, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, PendingAsk pendingAsk, NodeType type, RMContainer rmContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        ContainerAllocation result;
        Priority priority = schedulerKey.getPriority();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getNodeName() + " application=" + this.application.getApplicationId() + " priority=" + schedulerKey.getPriority() + " pendingAsk=" + pendingAsk + " type=" + (Object)((Object)type)));
        }
        Resource capability = pendingAsk.getPerAllocationResource();
        Resource available = node.getUnallocatedResource();
        Resource totalResource = node.getTotalResource();
        if (!Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)capability, (Resource)totalResource)) {
            LOG.warn((Object)("Node : " + node.getNodeID() + " does not have sufficient resource for ask : " + pendingAsk + " node total capability : " + node.getTotalResource()));
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Node does not have sufficient resource for request");
            return ContainerAllocation.LOCALITY_SKIPPED;
        }
        boolean shouldAllocOrReserveNewContainer = this.shouldAllocOrReserveNewContainer(schedulerKey, capability);
        long availableContainers = this.rc.computeAvailableContainers(available, capability);
        Resource resourceNeedToUnReserve = Resources.max((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.subtract((Resource)capability, (Resource)currentResoureLimits.getHeadroom()), (Resource)currentResoureLimits.getAmountNeededUnreserve());
        boolean needToUnreserve = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resourceNeedToUnReserve, (Resource)Resources.none());
        RMContainer unreservedContainer = null;
        boolean reservationsContinueLooking = this.application.getCSLeafQueue().getReservationContinueLooking();
        ArrayList<RMContainer> toKillContainers = null;
        if (availableContainers == 0L && currentResoureLimits.isAllowPreemption()) {
            Resource availableAndKillable = Resources.clone((Resource)available);
            for (RMContainer killableContainer : node.getKillableContainers().values()) {
                if (null == toKillContainers) {
                    toKillContainers = new ArrayList<RMContainer>();
                }
                toKillContainers.add(killableContainer);
                Resources.addTo((Resource)availableAndKillable, (Resource)killableContainer.getAllocatedResource());
                if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)capability, (Resource)availableAndKillable)) continue;
                availableContainers = 1L;
                break;
            }
        }
        if (availableContainers > 0L) {
            if (rmContainer == null && reservationsContinueLooking && node.getLabels().isEmpty() && (!shouldAllocOrReserveNewContainer || needToUnreserve)) {
                if (!needToUnreserve) {
                    resourceNeedToUnReserve = capability;
                }
                if (null == (unreservedContainer = this.application.findNodeToUnreserve(node, schedulerKey, resourceNeedToUnReserve))) {
                    ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Locality skipped");
                    return ContainerAllocation.LOCALITY_SKIPPED;
                }
            }
            result = new ContainerAllocation(unreservedContainer, pendingAsk.getPerAllocationResource(), AllocationState.ALLOCATED);
            result.containerNodeType = type;
            result.setToKillContainers(toKillContainers);
            return result;
        }
        if (shouldAllocOrReserveNewContainer || rmContainer != null) {
            if (reservationsContinueLooking && rmContainer == null && needToUnreserve) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"we needed to unreserve to be able to allocate");
                }
                ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Locality skipped");
                return ContainerAllocation.LOCALITY_SKIPPED;
            }
            result = new ContainerAllocation(null, pendingAsk.getPerAllocationResource(), AllocationState.RESERVED);
            result.containerNodeType = type;
            result.setToKillContainers(null);
            return result;
        }
        ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, priority, "Locality skipped");
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    boolean shouldAllocOrReserveNewContainer(SchedulerRequestKey schedulerKey, Resource required) {
        int requiredContainers = this.application.getOutstandingAsksCount(schedulerKey);
        int reservedContainers = this.application.getNumReservedContainers(schedulerKey);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = Resources.ratio((ResourceCalculator)this.rc, (Resource)required, (Resource)this.application.getCSLeafQueue().getMaximumAllocation());
            starvation = (int)((float)this.application.getReReservations(schedulerKey) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.application.getCSLeafQueue().getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + this.application.getReReservations(schedulerKey) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.application.getCSLeafQueue().getMinimumAllocationFactor() + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private Container getContainer(RMContainer rmContainer, FiCaSchedulerNode node, Resource capability, SchedulerRequestKey schedulerKey) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(node, capability, schedulerKey);
    }

    private Container createContainer(FiCaSchedulerNode node, Resource capability, SchedulerRequestKey schedulerKey) {
        NodeId nodeId = node.getRMNode().getNodeID();
        return BuilderUtils.newContainer(null, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)schedulerKey.getPriority(), null, (long)schedulerKey.getAllocationRequestId());
    }

    private ContainerAllocation handleNewContainerAllocation(ContainerAllocation allocationResult, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Container container) {
        RMContainer allocatedContainer;
        allocationResult.updatedContainer = allocatedContainer = this.application.allocate(node, schedulerKey, container);
        if (allocatedContainer == null) {
            ContainerAllocation ret = new ContainerAllocation(allocationResult.containerToBeUnreserved, null, AllocationState.APP_SKIPPED);
            ActivitiesLogger.APP.recordAppActivityWithoutAllocation(this.activitiesManager, node, this.application, schedulerKey.getPriority(), "Fail to allocate", ActivityState.REJECTED);
            return ret;
        }
        return allocationResult;
    }

    ContainerAllocation doAllocation(ContainerAllocation allocationResult, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer reservedContainer) {
        Container container = this.getContainer(reservedContainer, node, allocationResult.getResourceToBeAllocated(), schedulerKey);
        if (container == null) {
            this.application.updateAppSkipNodeDiagnostics("Scheduling of container failed. ");
            LOG.warn((Object)"Couldn't get container for allocation!");
            ActivitiesLogger.APP.recordAppActivityWithoutAllocation(this.activitiesManager, node, this.application, schedulerKey.getPriority(), "Couldn't get container for allocation", ActivityState.REJECTED);
            return ContainerAllocation.APP_SKIPPED;
        }
        if (allocationResult.getAllocationState() == AllocationState.ALLOCATED) {
            allocationResult = this.handleNewContainerAllocation(allocationResult, node, schedulerKey, container);
        } else {
            RMContainer updatedContainer = reservedContainer;
            if (updatedContainer == null) {
                updatedContainer = new RMContainerImpl(container, schedulerKey, this.application.getApplicationAttemptId(), node.getNodeID(), this.application.getAppSchedulingInfo().getUser(), this.rmContext);
            }
            allocationResult.updatedContainer = updatedContainer;
        }
        if (reservedContainer == null) {
            if (allocationResult.containerNodeType != NodeType.OFF_SWITCH) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Resetting scheduling opportunities");
                }
                if (allocationResult.containerNodeType == NodeType.NODE_LOCAL || this.application.getCSLeafQueue().getRackLocalityFullReset()) {
                    this.application.resetSchedulingOpportunities(schedulerKey);
                }
            }
            if (StringUtils.equals((String)node.getPartition(), (String)"")) {
                this.application.resetMissedNonPartitionedRequestSchedulingOpportunity(schedulerKey);
            }
        }
        return allocationResult;
    }

    private ContainerAllocation allocate(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, SchedulingMode schedulingMode, ResourceLimits resourceLimits, SchedulerRequestKey schedulerKey, RMContainer reservedContainer) {
        ContainerAllocation result;
        if (reservedContainer == null) {
            result = this.preCheckForNodeCandidateSet(clusterResource, candidates, schedulingMode, resourceLimits, schedulerKey);
            if (null != result) {
                return result;
            }
        } else if (this.application.getOutstandingAsksCount(schedulerKey) == 0) {
            return new ContainerAllocation(reservedContainer, null, AllocationState.QUEUE_SKIPPED);
        }
        AppPlacementAllocator<FiCaSchedulerNode> schedulingPS = this.application.getAppSchedulingInfo().getAppPlacementAllocator(schedulerKey);
        result = ContainerAllocation.PRIORITY_SKIPPED;
        Iterator<FiCaSchedulerNode> iter = schedulingPS.getPreferredNodeIterator(candidates);
        while (iter.hasNext()) {
            FiCaSchedulerNode node = iter.next();
            result = this.tryAllocateOnNode(clusterResource, node, schedulingMode, resourceLimits, schedulerKey, reservedContainer);
            if (AllocationState.ALLOCATED != result.state && AllocationState.RESERVED != result.state) continue;
            result = this.doAllocation(result, node, schedulerKey, reservedContainer);
            break;
        }
        return result;
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, SchedulingMode schedulingMode, ResourceLimits resourceLimits, RMContainer reservedContainer) {
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        if (reservedContainer == null) {
            if (!this.application.hasPendingResourceRequest(this.rc, candidates.getPartition(), clusterResource, schedulingMode)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip app_attempt=" + this.application.getApplicationAttemptId() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-label=" + candidates.getPartition()));
                }
                ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, this.application.getPriority(), "Application does not need more resource");
                return CSAssignment.SKIP_ASSIGNMENT;
            }
            for (SchedulerRequestKey schedulerKey : this.application.getSchedulerKeys()) {
                ContainerAllocation result = this.allocate(clusterResource, candidates, schedulingMode, resourceLimits, schedulerKey, null);
                AllocationState allocationState = result.getAllocationState();
                if (allocationState == AllocationState.PRIORITY_SKIPPED) continue;
                return this.getCSAssignmentFromAllocateResult(clusterResource, result, null, node);
            }
            ActivitiesLogger.APP.recordSkippedAppActivityWithoutAllocation(this.activitiesManager, node, this.application, this.application.getPriority(), "All priorities are skipped of the app");
            return CSAssignment.SKIP_ASSIGNMENT;
        }
        ContainerAllocation result = this.allocate(clusterResource, candidates, schedulingMode, resourceLimits, reservedContainer.getReservedSchedulerKey(), reservedContainer);
        return this.getCSAssignmentFromAllocateResult(clusterResource, result, reservedContainer, node);
    }
}

