/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class NodesPage
extends RmView {
    NodesPage() {
    }

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        String type = this.$("node.state");
        String title = "Nodes of the cluster";
        if (type != null && !type.isEmpty()) {
            title = title + " (" + type + ")";
        }
        this.setTitle(title);
        this.set("ui.dataTables.id", "nodes");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"nodes"), this.nodesTableInit());
        this.setTableStyles(html, "nodes", new String[]{".healthStatus {width:10em}", ".healthReport {width:10em}"});
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodesBlock.class;
    }

    private String nodesTableInit() {
        StringBuilder b = JQueryUI.tableInit().append(", 'aaData': nodeTableData").append(", bDeferRender: true").append(", bProcessing: true").append(", aoColumnDefs: [");
        b.append("{'bSearchable': false, 'aTargets': [ 7 ]}");
        b.append(", {'sType': 'title-numeric', 'bSearchable': false, 'aTargets': [ 8, 9 ] }");
        b.append(", {'sType': 'title-numeric', 'aTargets': [ 5 ]}");
        b.append("]}");
        return b.toString();
    }

    static class NodesBlock
    extends HtmlBlock {
        final ResourceManager rm;
        private static final long BYTES_IN_MB = 0x100000L;
        private static final long BYTES_IN_GB = 0x40000000L;
        private static boolean opportunisticContainersEnabled;

        @Inject
        NodesBlock(ResourceManager rm, View.ViewContext ctx) {
            super(ctx);
            this.rm = rm;
            opportunisticContainersEnabled = YarnConfiguration.isOpportunisticContainerAllocationEnabled((Configuration)this.rm.getRMContext().getYarnConfiguration());
        }

        protected void render(HtmlBlock.Block html) {
            html.__(MetricsOverviewTable.class);
            ResourceScheduler sched = this.rm.getResourceScheduler();
            String type = this.$("node.state");
            String labelFilter = this.$("node.label", "*").trim();
            Hamlet.TR trbody = html.table("#nodes").thead().tr().th(".nodelabels", "Node Labels").th(".rack", "Rack").th(".state", "Node State").th(".nodeaddress", "Node Address").th(".nodehttpaddress", "Node HTTP Address").th(".lastHealthUpdate", "Last health-update").th(".healthReport", "Health-report");
            if (!opportunisticContainersEnabled) {
                trbody.th(".containers", "Containers").th(".mem", "Mem Used").th(".mem", "Mem Avail").th(".vcores", "VCores Used").th(".vcores", "VCores Avail");
            } else {
                trbody.th(".containers", "Running Containers (G)").th(".mem", "Mem Used (G)").th(".mem", "Mem Avail (G)").th(".vcores", "VCores Used (G)").th(".vcores", "VCores Avail (G)").th(".containers", "Running Containers (O)").th(".mem", "Mem Used (O)").th(".vcores", "VCores Used (O)").th(".containers", "Queued Containers");
            }
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)trbody.th(".nodeManagerVersion", "Version").__()).__()).tbody();
            NodeState stateFilter = null;
            if (type != null && !type.isEmpty()) {
                stateFilter = NodeState.valueOf((String)StringUtils.toUpperCase((String)type));
            }
            Collection rmNodes = this.rm.getRMContext().getRMNodes().values();
            boolean isInactive = false;
            if (stateFilter != null) {
                switch (stateFilter) {
                    case DECOMMISSIONED: 
                    case LOST: 
                    case REBOOTED: 
                    case SHUTDOWN: {
                        rmNodes = this.rm.getRMContext().getInactiveRMNodes().values();
                        isInactive = true;
                        break;
                    }
                    case DECOMMISSIONING: {
                        break;
                    }
                    default: {
                        LOG.debug("Unexpected state filter for inactive RM node");
                    }
                }
            }
            StringBuilder nodeTableData = new StringBuilder("[\n");
            for (RMNode ni : rmNodes) {
                NodeState state;
                if ((stateFilter == null ? ni.getState() == NodeState.UNHEALTHY : !stateFilter.equals((Object)(state = ni.getState()))) || !labelFilter.equals("*") && (labelFilter.isEmpty() ? !ni.getNodeLabels().isEmpty() : !ni.getNodeLabels().contains(labelFilter))) continue;
                NodeInfo info = new NodeInfo(ni, sched);
                int usedMemory = (int)info.getUsedMemory();
                int availableMemory = (int)info.getAvailableMemory();
                nodeTableData.append("[\"").append(StringUtils.join((CharSequence)",", info.getNodeLabels())).append("\",\"").append(info.getRack()).append("\",\"").append(info.getState()).append("\",\"").append(info.getNodeId());
                if (isInactive) {
                    nodeTableData.append("\",\"").append("N/A").append("\",\"");
                } else {
                    String httpAddress = info.getNodeHTTPAddress();
                    nodeTableData.append("\",\"<a ").append("href='//" + httpAddress).append("'>").append(httpAddress).append("</a>\",").append("\"");
                }
                nodeTableData.append("<br title='").append(String.valueOf(info.getLastHealthUpdate())).append("'>").append(Times.format((long)info.getLastHealthUpdate())).append("\",\"").append(info.getHealthReport()).append("\",\"").append(String.valueOf(info.getNumContainers())).append("\",\"").append("<br title='").append(String.valueOf(usedMemory)).append("'>").append(StringUtils.byteDesc((long)((long)usedMemory * 0x100000L))).append("\",\"").append("<br title='").append(String.valueOf(availableMemory)).append("'>").append(StringUtils.byteDesc((long)((long)availableMemory * 0x100000L))).append("\",\"").append(String.valueOf(info.getUsedVirtualCores())).append("\",\"").append(String.valueOf(info.getAvailableVirtualCores())).append("\",\"");
                if (opportunisticContainersEnabled) {
                    nodeTableData.append(String.valueOf(info.getNumRunningOpportContainers())).append("\",\"").append("<br title='").append(String.valueOf(info.getUsedMemoryOpportGB())).append("'>").append(StringUtils.byteDesc((long)(info.getUsedMemoryOpportGB() * 0x40000000L))).append("\",\"").append(String.valueOf(info.getUsedVirtualCoresOpport())).append("\",\"").append(String.valueOf(info.getNumQueuedContainers())).append("\",\"");
                }
                nodeTableData.append(ni.getNodeManagerVersion()).append("\"],\n");
            }
            if (nodeTableData.charAt(nodeTableData.length() - 2) == ',') {
                nodeTableData.delete(nodeTableData.length() - 2, nodeTableData.length() - 1);
            }
            nodeTableData.append("]");
            html.script().$type("text/javascript").__(new Object[]{"var nodeTableData=" + nodeTableData}).__();
            ((Hamlet.TABLE)tbody.__()).__();
        }
    }
}

