/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import java.lang.reflect.Method;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public final class ECPolicyDisabler {
    private static final String GETREPLICATIONPOLICY_METHOD = "getReplicationPolicy";
    private static final String ERASURECODING_POLICIES_CLASS = "org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies";
    private static final String GETNAME_METHOD = "getName";
    private static final String SETERASURECODINGPOLICY_METHOD = "setErasureCodingPolicy";
    private static final String GETERASURECODINGPOLICY_METHOD = "getErasureCodingPolicy";

    public static void tryDisableECPolicyForPath(FileSystem fs, Path path) {
        if (fs instanceof DistributedFileSystem && ECPolicyDisabler.supportsErasureCoding()) {
            System.out.println("Found Hadoop that supports Erasure Coding. Trying to disable Erasure Coding for path: " + path);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            Object replicationPolicy = ECPolicyDisabler.getReplicationPolicy();
            Method getErasureCodingPolicyMethod = ECPolicyDisabler.getMethod(dfs, GETERASURECODINGPOLICY_METHOD);
            Object currentECPolicy = ECPolicyDisabler.invokeMethod(getErasureCodingPolicyMethod, dfs, path);
            if (currentECPolicy != replicationPolicy) {
                Method setECPolicyMethod = ECPolicyDisabler.getMethod(dfs, SETERASURECODINGPOLICY_METHOD);
                Method policyGetNameMethod = ECPolicyDisabler.getMethod(replicationPolicy, GETNAME_METHOD);
                String name = (String)ECPolicyDisabler.invokeMethod(policyGetNameMethod, replicationPolicy, new Object[0]);
                ECPolicyDisabler.invokeMethod(setECPolicyMethod, dfs, path, name);
                System.out.println("Done");
            } else {
                System.out.println("Current policy is already replication");
            }
        } else {
            System.out.println("Found Hadoop that does not support Erasure Coding. Not taking any action.");
        }
    }

    private static boolean supportsErasureCoding() {
        try {
            ECPolicyDisabler.getECPoliciesClass();
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object getReplicationPolicy() {
        try {
            Class<?> c = ECPolicyDisabler.getECPoliciesClass();
            Method m = c.getMethod(GETREPLICATIONPOLICY_METHOD, new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Error accessing method with reflection");
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getECPoliciesClass() throws ClassNotFoundException {
        return Class.forName(ERASURECODING_POLICIES_CLASS);
    }

    private static Method getMethod(Object object, String methodName) {
        Method[] methods = object.getClass().getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method " + methodName + "() not found");
        }
        return method;
    }

    private static Object invokeMethod(Method m, Object instance, Object ... args) {
        try {
            return m.invoke(instance, args);
        }
        catch (Exception e) {
            System.err.println("Error invoking method with reflection");
            throw new RuntimeException(e);
        }
    }
}

