/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.tools.ECPolicyDisabler;

public class OozieSharelibCLI {
    public static final String[] HELP_INFO = new String[]{"", "OozieSharelibCLI creates or upgrade sharelib for oozie"};
    public static final String HELP_CMD = "help";
    public static final String CREATE_CMD = "create";
    public static final String UPGRADE_CMD = "upgrade";
    public static final String LIB_OPT = "locallib";
    public static final String FS_OPT = "fs";
    public static final String CONCURRENCY_OPT = "concurrency";
    public static final String OOZIE_HOME = "oozie.home.dir";
    public static final String SHARE_LIB_PREFIX = "lib_";
    private boolean used = false;

    public static void main(String[] args) throws Exception {
        System.exit(new OozieSharelibCLI().run(args));
    }

    protected Options createUpgradeOptions(String subCommand) {
        Option sharelib = new Option(LIB_OPT, true, "Local share library directory");
        Option uri = new Option(FS_OPT, true, "URI of the fileSystem to " + subCommand + " oozie share library");
        Option concurrency = new Option(CONCURRENCY_OPT, true, "Number of threads to be used for copy operations. (default=1)");
        Options options = new Options();
        options.addOption(sharelib);
        options.addOption(uri);
        options.addOption(concurrency);
        return options;
    }

    public synchronized int run(String[] args) throws Exception {
        if (this.used) {
            throw new IllegalStateException("CLI instance already used");
        }
        this.used = true;
        CLIParser parser = new CLIParser("oozie-setup.sh", HELP_INFO);
        String oozieHome = System.getProperty(OOZIE_HOME);
        parser.addCommand(HELP_CMD, "", "display usage for all commands or specified command", new Options(), false);
        parser.addCommand(CREATE_CMD, "", "create a new timestamped version of oozie sharelib", this.createUpgradeOptions(CREATE_CMD), false);
        parser.addCommand(UPGRADE_CMD, "", "[deprecated][use command \"create\" to create new version]   upgrade oozie sharelib \n", this.createUpgradeOptions(UPGRADE_CMD), false);
        try {
            CLIParser.Command command = parser.parse(args);
            String sharelibAction = command.getName();
            if (sharelibAction.equals(HELP_CMD)) {
                parser.showHelp(command.getCommandLine());
                return 0;
            }
            if (!command.getCommandLine().hasOption(FS_OPT)) {
                throw new Exception("-fs option must be specified");
            }
            int threadPoolSize = Integer.valueOf(command.getCommandLine().getOptionValue(CONCURRENCY_OPT, "1"));
            File srcFile = null;
            if (command.getCommandLine().hasOption(LIB_OPT)) {
                srcFile = new File(command.getCommandLine().getOptionValue(LIB_OPT));
            } else {
                Collection files = FileUtils.listFiles((File)new File(oozieHome), (IOFileFilter)new WildcardFileFilter("oozie-sharelib*.tar.gz"), null);
                if (files.size() > 1) {
                    throw new IOException("more than one sharelib tar found at " + oozieHome);
                }
                if (files.isEmpty()) {
                    throw new IOException("default sharelib tar not found in oozie home dir: " + oozieHome);
                }
                srcFile = (File)files.iterator().next();
            }
            File temp = File.createTempFile("oozie", ".dir");
            temp.delete();
            temp.mkdir();
            temp.deleteOnExit();
            if (!srcFile.isDirectory()) {
                FileUtil.unTar((File)srcFile, (File)temp);
                srcFile = new File(temp.toString() + "/share/lib");
            } else {
                srcFile = new File(srcFile, "lib");
            }
            String hdfsUri = command.getCommandLine().getOptionValue(FS_OPT);
            Path srcPath = new Path(srcFile.toString());
            Services services = new Services();
            services.getConf().set("oozie.services", "org.apache.oozie.service.LiteWorkflowAppService, org.apache.oozie.service.HadoopAccessorService");
            services.getConf().set("oozie.services.ext", "");
            services.init();
            WorkflowAppService lwas = (WorkflowAppService)services.get(WorkflowAppService.class);
            HadoopAccessorService has = (HadoopAccessorService)services.get(HadoopAccessorService.class);
            Path dstPath = lwas.getSystemLibPath();
            URI uri = new Path(hdfsUri).toUri();
            Configuration fsConf = has.createConfiguration(uri.getAuthority());
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)fsConf);
            if (!fs.exists(dstPath)) {
                fs.mkdirs(dstPath);
            }
            ECPolicyDisabler.tryDisableECPolicyForPath(fs, dstPath);
            if (sharelibAction.equals(CREATE_CMD) || sharelibAction.equals(UPGRADE_CMD)) {
                dstPath = new Path(dstPath.toString() + "/" + SHARE_LIB_PREFIX + this.getTimestampDirectory());
            }
            System.out.println("the destination path for sharelib is: " + dstPath);
            if (!srcFile.exists()) {
                throw new IOException(srcPath + " cannot be found");
            }
            if (threadPoolSize > 1) {
                this.concurrentCopyFromLocal(fs, threadPoolSize, srcFile, dstPath);
            } else {
                fs.copyFromLocalFile(false, srcPath, dstPath);
            }
            services.destroy();
            FileUtils.deleteDirectory((File)temp);
            return 0;
        }
        catch (ParseException ex) {
            System.err.println("Invalid sub-command: " + ex.getMessage());
            System.err.println();
            System.err.println(parser.shortHelp());
            return 1;
        }
        catch (Exception ex) {
            this.logError(ex.getMessage(), ex);
            return 1;
        }
    }

    private void logError(String errorMessage, Throwable ex) {
        System.err.println();
        System.err.println("Error: " + errorMessage);
        System.err.println();
        System.err.println("Stack trace for the error was (for debug purposes):");
        System.err.println("--------------------------------------");
        ex.printStackTrace(System.err);
        System.err.println("--------------------------------------");
        System.err.println();
    }

    public String getTimestampDirectory() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return dateFormat.format(date).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentCopyFromLocal(FileSystem fs, int threadPoolSize, File srcFile, Path dstPath) throws IOException {
        List<Future<Void>> futures = Collections.emptyList();
        ExecutorService threadPool = Executors.newFixedThreadPool(threadPoolSize);
        try {
            futures = this.copyFolderRecursively(fs, threadPool, srcFile, dstPath);
            System.out.println("Running " + futures.size() + " copy tasks on " + threadPoolSize + " threads");
        }
        finally {
            try {
                threadPool.shutdown();
            }
            finally {
                this.checkCopyResults(futures);
            }
        }
    }

    private void checkCopyResults(List<Future<Void>> futures) throws IOException {
        Throwable t = null;
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (CancellationException ce) {
                t = ce;
                this.logError("Copy task was cancelled", ce);
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
                this.logError("Copy task failed with exception", t);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            throw new IOException("At least one copy task failed with exception", t);
        }
    }

    private List<Future<Void>> copyFolderRecursively(final FileSystem fs, ExecutorService threadPool, File srcFile, Path dstPath) throws IOException {
        ArrayList<Future<Void>> taskList = new ArrayList<Future<Void>>();
        File[] files = srcFile.listFiles();
        if (files != null) {
            for (final File file : files) {
                final Path trgName = new Path(dstPath, file.getName());
                if (file.isDirectory()) {
                    taskList.addAll(this.copyFolderRecursively(fs, threadPool, file, trgName));
                    continue;
                }
                taskList.add(threadPool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        fs.copyFromLocalFile(new Path(file.toURI()), trgName);
                        return null;
                    }
                }));
            }
        } else {
            System.out.println("WARNING: directory listing of " + srcFile.getAbsolutePath().toString() + " returned null");
        }
        return taskList;
    }
}

