/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.tools.diag.AppInfoCollector;
import org.apache.oozie.tools.diag.ArgParser;
import org.apache.oozie.tools.diag.DiagBundleCompressor;
import org.apache.oozie.tools.diag.DiagOozieClient;
import org.apache.oozie.tools.diag.MetricsCollector;
import org.apache.oozie.tools.diag.ServerInfoCollector;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Output directory is specified by user")
public class DiagBundleCollectorDriver {
    static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
    private String oozieURL;
    private Integer numWorkflows;
    private Integer numCoords;
    private Integer numBundles;
    private String[] jobIds;
    private Integer maxChildActions;
    private File outputDir;
    private Configuration hadoopConfig;

    public static void main(String[] args) throws Exception {
        DiagBundleCollectorDriver oozieDiagBundleCollector = new DiagBundleCollectorDriver();
        System.exit(oozieDiagBundleCollector.run(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) throws Exception {
        if (!this.parseCommandLineArgs(args) || !this.setHadoopConfig()) {
            return -1;
        }
        DiagOozieClient client = new DiagOozieClient(this.oozieURL, null);
        this.checkOozieConnection((OozieClient)client);
        File tempDir = Files.createTempDir();
        System.out.println("Using Temporary Directory: " + tempDir);
        try {
            this.collectDiagInformation(this.numWorkflows, this.numCoords, this.numBundles, this.jobIds, this.maxChildActions, client, tempDir);
            DiagBundleCompressor.compressDiagInformationToBundle(this.outputDir, tempDir);
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir);
        }
        System.out.println();
        return 0;
    }

    private boolean parseCommandLineArgs(String[] args) throws IOException {
        ArgParser cliParser = new ArgParser();
        if (!cliParser.parseCommandLineArguments(args)) {
            return false;
        }
        this.oozieURL = cliParser.getOozieUrl();
        this.numWorkflows = cliParser.getNumWorkflows();
        this.numCoords = cliParser.getNumCoordinators();
        this.numBundles = cliParser.getNumBundles();
        this.jobIds = cliParser.getJobIds();
        this.maxChildActions = cliParser.getMaxChildActions();
        this.outputDir = cliParser.ensureOutputDir();
        return true;
    }

    private void collectDiagInformation(Integer numWorkflows, Integer numCoords, Integer numBundles, String[] jobIds, Integer maxChildActions, DiagOozieClient client, File tempDir) {
        ServerInfoCollector serverInfoCollector = new ServerInfoCollector(client);
        serverInfoCollector.storeShareLibInfo(tempDir);
        serverInfoCollector.storeServerConfiguration(tempDir);
        serverInfoCollector.storeOsEnv(tempDir);
        serverInfoCollector.storeJavaSystemProperties(tempDir);
        serverInfoCollector.storeCallableQueueDump(tempDir);
        serverInfoCollector.storeThreadDump(tempDir);
        MetricsCollector metricsCollector = new MetricsCollector((OozieClient)client);
        metricsCollector.storeInstrumentationInfo(tempDir);
        metricsCollector.storeMetrics(tempDir);
        AppInfoCollector workflowInfoCollector = new AppInfoCollector(this.hadoopConfig, client);
        workflowInfoCollector.storeLastWorkflows(tempDir, numWorkflows, maxChildActions);
        workflowInfoCollector.storeLastCoordinators(tempDir, numCoords, maxChildActions);
        workflowInfoCollector.storeLastBundles(tempDir, numBundles, maxChildActions);
        workflowInfoCollector.getSpecificJobs(tempDir, jobIds, maxChildActions);
    }

    private void checkOozieConnection(OozieClient client) throws OozieClientException {
        System.out.print("Checking Connection...");
        client.validateWSVersion();
        System.out.println("Done");
    }

    private boolean setHadoopConfig() {
        String oozieHome = System.getenv("OOZIE_HOME");
        if (oozieHome == null) {
            System.err.println("OOZIE_HOME environment variable is not set. Make sure you've set it to an absolute path.");
            return false;
        }
        System.setProperty("oozie.home.dir", oozieHome);
        try {
            Services services = this.initOozieServices();
            HadoopAccessorService hadoopAccessorService = (HadoopAccessorService)services.get(HadoopAccessorService.class);
            this.hadoopConfig = hadoopAccessorService.createConfiguration("*");
        }
        catch (ServiceException e) {
            System.err.printf("Could not initialize Hadoop configuration: %s%n", e.getMessage());
            return false;
        }
        return true;
    }

    private Services initOozieServices() throws ServiceException {
        Services services = new Services();
        services.getConf().set("oozie.services", "org.apache.oozie.service.LiteWorkflowAppService,org.apache.oozie.service.SchedulerService,org.apache.oozie.service.HadoopAccessorService,org.apache.oozie.service.ShareLibService");
        services.init();
        return services;
    }
}

