/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.apache.oozie.util.IOUtils;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Output directory is specified by user")
class DiagBundleCompressor {
    DiagBundleCompressor() {
    }

    private static void zip(File inputDir, File outputFile) throws IOException {
        System.out.print("Creating Zip File: " + outputFile.getAbsolutePath() + "...");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));){
            IOUtils.zipDir((File)inputDir, (String)"/", (ZipOutputStream)zos);
        }
        System.out.println("Done");
    }

    static void compressDiagInformationToBundle(File outputDir, File tempDir) throws IOException {
        File zipFile = new File(outputDir, "oozie-diag-bundle-" + System.currentTimeMillis() + ".zip");
        DiagBundleCompressor.zip(tempDir, zipFile);
    }
}

