/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.oozie.tools.diag.DiagBundleCollectorDriver;
import org.apache.oozie.util.IOUtils;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Output directory is specified by user")
public class DiagBundleEntryWriter
implements Closeable {
    private final Writer writer;

    DiagBundleEntryWriter(File parentDir, String fileName) throws FileNotFoundException {
        this(new FileOutputStream(new File(parentDir, fileName)));
    }

    private DiagBundleEntryWriter(OutputStream ous) {
        try {
            this.writer = new OutputStreamWriter(ous, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    DiagBundleEntryWriter writeDateValue(String key, Date date) throws IOException {
        if (date != null) {
            this.writeStringValue(key, DiagBundleCollectorDriver.DATE_FORMAT.format(date));
        } else {
            this.writeStringValue(key, "null");
        }
        return this;
    }

    DiagBundleEntryWriter writeLongValue(String key, long value) throws IOException {
        this.writeStringValue(key, Long.toString(value));
        return this;
    }

    DiagBundleEntryWriter writeIntValue(String key, int value) throws IOException {
        this.writeStringValue(key, Integer.toString(value));
        return this;
    }

    DiagBundleEntryWriter writeStringValue(String key, String value) throws IOException {
        this.writer.write(key);
        if (value != null && !value.isEmpty()) {
            this.writer.write(String.format("\"%s\"", value));
        } else if (value == null) {
            this.writeNull();
        } else {
            this.writer.write("\"\"");
        }
        this.writer.write("\n");
        return this;
    }

    DiagBundleEntryWriter writeString(String s) throws IOException {
        if (s == null) {
            this.writeNull();
        } else {
            this.writer.write(s);
        }
        return this;
    }

    DiagBundleEntryWriter writeNewLine() throws IOException {
        this.writer.write("\n");
        return this;
    }

    DiagBundleEntryWriter writeNull() throws IOException {
        this.writer.write("null");
        return this;
    }

    void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            try {
                System.err.printf("Could not persist data. Exception: %s%n", e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeSafely((Closeable[])new Closeable[]{this.writer});
                throw throwable;
            }
            IOUtils.closeSafely((Closeable[])new Closeable[]{this.writer});
        }
        IOUtils.closeSafely((Closeable[])new Closeable[]{this.writer});
    }
}

