/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.tools.diag.DiagBundleEntryWriter;

class MetricsCollector {
    private final OozieClient client;

    MetricsCollector(OozieClient client) {
        this.client = client;
    }

    void storeMetrics(File outputDir) {
        try {
            System.out.print("Getting Metrics...");
            OozieClient.Metrics metrics = this.client.getMetrics();
            if (metrics == null) {
                System.out.println("Skipping (Metrics are unavailable)");
                return;
            }
            try (DiagBundleEntryWriter diagEntryWriter = new DiagBundleEntryWriter(outputDir, "metrics.txt");){
                diagEntryWriter.writeString("COUNTERS\n").writeString("--------\n");
                TreeMap counters = new TreeMap(metrics.getCounters());
                for (Map.Entry entry : counters.entrySet()) {
                    diagEntryWriter.writeLongValue((String)entry.getKey() + " : ", (Long)entry.getValue()).flush();
                }
                diagEntryWriter.writeNewLine().writeString("GAUGES\n").writeString("------\n");
                TreeMap gauges = new TreeMap(metrics.getGauges());
                for (Map.Entry entry : gauges.entrySet()) {
                    diagEntryWriter.writeStringValue((String)entry.getKey() + " : ", entry.getValue().toString());
                }
                diagEntryWriter.writeNewLine().writeString("TIMERS\n").writeString("------\n");
                TreeMap treeMap = new TreeMap(metrics.getTimers());
                for (Map.Entry entry : treeMap.entrySet()) {
                    diagEntryWriter.writeString((String)entry.getKey()).writeNewLine().writeString(((OozieClient.Metrics.Timer)entry.getValue()).toString()).writeNewLine();
                }
                diagEntryWriter.writeNewLine().writeString("HISTOGRAMS\n").writeString("----------\n");
                TreeMap treeMap2 = new TreeMap(metrics.getHistograms());
                for (Map.Entry ent : treeMap2.entrySet()) {
                    diagEntryWriter.writeString((String)ent.getKey()).writeNewLine().writeString(((OozieClient.Metrics.Histogram)ent.getValue()).toString()).writeNewLine();
                }
                System.out.println("Done");
            }
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of Oozie metrics information: %s%n", e.getMessage());
        }
    }

    void storeInstrumentationInfo(File outputDir) {
        try {
            System.out.print("Getting Instrumentation...");
            OozieClient.Instrumentation instrumentation = this.client.getInstrumentation();
            if (instrumentation == null) {
                System.out.println("Skipping (Instrumentation is unavailable)");
                return;
            }
            try (DiagBundleEntryWriter diagEntryWriter = new DiagBundleEntryWriter(outputDir, "instrumentation.txt");){
                diagEntryWriter.writeString("COUNTERS\n");
                diagEntryWriter.writeString("--------\n");
                TreeMap counters = new TreeMap(instrumentation.getCounters());
                for (Map.Entry entry : counters.entrySet()) {
                    diagEntryWriter.writeLongValue((String)entry.getKey() + " : ", (Long)entry.getValue()).flush();
                }
                diagEntryWriter.writeNewLine();
                diagEntryWriter.writeString("VARIABLES\n");
                diagEntryWriter.writeString("---------\n");
                TreeMap variables = new TreeMap(instrumentation.getVariables());
                for (Map.Entry entry : variables.entrySet()) {
                    diagEntryWriter.writeStringValue((String)entry.getKey() + " : ", entry.getValue().toString());
                }
                diagEntryWriter.writeNewLine();
                diagEntryWriter.writeString("SAMPLERS\n");
                diagEntryWriter.writeString("---------\n");
                TreeMap treeMap = new TreeMap(instrumentation.getSamplers());
                for (Map.Entry entry : treeMap.entrySet()) {
                    diagEntryWriter.writeStringValue((String)entry.getKey() + " : ", ((Double)entry.getValue()).toString());
                }
                diagEntryWriter.writeNewLine();
                diagEntryWriter.writeString("TIMERS\n");
                diagEntryWriter.writeString("---------\n");
                TreeMap treeMap2 = new TreeMap(instrumentation.getTimers());
                for (Map.Entry ent : treeMap2.entrySet()) {
                    diagEntryWriter.writeString((String)ent.getKey());
                    diagEntryWriter.writeNewLine();
                    diagEntryWriter.writeString(((OozieClient.Instrumentation.Timer)ent.getValue()).toString());
                    diagEntryWriter.writeNewLine();
                }
                System.out.println("Done");
            }
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of Oozie instrumentation information: %s%n", e.getMessage());
        }
    }
}

