/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.PropertyConfigurator;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.LauncherMain;

public class DistcpMain
extends JavaMain {
    private Constructor<?> construct;
    private Object[] constArgs;
    private static final String DISTCP_LOG4J_PROPS = "distcp-log4j.properties";
    @VisibleForTesting
    static final Pattern[] DISTCP_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Job complete: (job_\\S*)"), Pattern.compile("Job (job_\\S*) completed successfully"), Pattern.compile("Submitted application (application[0-9_]*)")};

    public static void main(String[] args) throws Exception {
        DistcpMain.run(DistcpMain.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        Configuration actionConf = DistcpMain.loadActionConf();
        LauncherMain.killChildYarnJobs((Configuration)actionConf);
        String logFile = this.setUpDistcpLog4J(actionConf);
        Class klass = actionConf.getClass("oozie.launcher.action.main.class", DistCp.class);
        System.out.println("Main class        : " + klass.getName());
        System.out.println("Arguments         :");
        for (String arg : args) {
            System.out.println("                    " + arg);
        }
        if (DistcpMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION") != null) {
            actionConf.set("mapreduce.job.credentials.binary", DistcpMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION"));
        }
        this.getConstructorAndArgs(klass, actionConf);
        if (this.construct == null) {
            throw new RuntimeException("Distcp constructor was not found, unable to instantiate");
        }
        if (this.constArgs == null) {
            throw new RuntimeException("Arguments for distcp constructor is null, unable to instantiate");
        }
        try {
            Tool distcp = (Tool)this.construct.newInstance(this.constArgs);
            int i = ToolRunner.run((Tool)distcp, (String[])args);
            if (i != 0) {
                throw new RuntimeException("Returned value from distcp is non-zero (" + i + ")");
            }
        }
        catch (InvocationTargetException ex) {
            throw new JavaMain.JavaMainException(ex.getCause());
        }
        finally {
            System.out.println("\n<<< Invocation of DistCp command completed <<<\n");
            DistcpMain.writeExternalChildIDs((String)logFile, (Pattern[])DISTCP_JOB_IDS_PATTERNS, (String)"Distcp");
        }
    }

    protected void getConstructorAndArgs(Class<?> klass, Configuration actionConf) throws Exception {
        Constructor<?>[] allConstructors;
        for (Constructor<?> cstruct : allConstructors = klass.getConstructors()) {
            Class<?>[] pType = cstruct.getParameterTypes();
            this.construct = cstruct;
            if (pType.length == 1 && pType[0].equals(Class.forName("org.apache.hadoop.conf.Configuration"))) {
                System.out.println("found Distcp v1 Constructor");
                System.out.println("                    " + cstruct.toString());
                this.constArgs = new Object[1];
                this.constArgs[0] = actionConf;
                break;
            }
            if (pType.length != 2 || !pType[0].equals(Class.forName("org.apache.hadoop.conf.Configuration"))) continue;
            System.out.println("found Distcp v2 Constructor");
            System.out.println("                    " + cstruct.toString());
            this.constArgs = new Object[2];
            this.constArgs[0] = actionConf;
            this.constArgs[1] = null;
            break;
        }
    }

    private String setUpDistcpLog4J(Configuration distcpConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system,property not set");
        }
        String logFile = new File("distcp-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        String logLevel = distcpConf.get("oozie.distcp.log.level", "INFO");
        String rootLogLevel = distcpConf.get("oozie.action.rootlogger.log.level", "INFO");
        this.log4jProperties.setProperty("log4j.rootLogger", rootLogLevel + ", A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.tools", logLevel + ", A, jobid");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.hadoop.tools", "false");
        this.log4jProperties.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        this.log4jProperties.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.A.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        this.log4jProperties.setProperty("log4j.appender.jobid.file", logFile);
        this.log4jProperties.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapred", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapreduce.Job", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "INFO, jobid");
        String localProps = new File(DISTCP_LOG4J_PROPS).getAbsolutePath();
        DistcpMain.createFileWithContentIfNotExists((String)localProps, (Properties)this.log4jProperties);
        PropertyConfigurator.configure((String)DISTCP_LOG4J_PROPS);
        return logFile;
    }
}

