/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizServerEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Serializer;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class Graphviz {
    private static volatile BlockingQueue<GraphvizEngine> engineQueue;
    private static GraphvizEngine engine;
    private final String src;
    private final Options options;
    final Rasterizer rasterizer;
    final int width;
    final int height;
    final double scale;

    private Graphviz(String src, Rasterizer rasterizer, int width, int height, double scale, Options options) {
        this.src = src;
        this.rasterizer = rasterizer;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useEngine(GraphvizEngine first, GraphvizEngine ... engines) {
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engineQueue == null) {
                engineQueue = new ArrayBlockingQueue<GraphvizEngine>(1);
            } else {
                try {
                    Graphviz.getEngine().release();
                }
                catch (GraphvizException graphvizException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            engine = null;
            first.init(e -> engineQueue.add((GraphvizEngine)e), e -> Graphviz.useEngine(Arrays.asList(engines)));
            return;
        }
    }

    private static void useEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            engineQueue.add(new ErrorGraphvizEngine());
        } else {
            engines.get(0).init(e -> engineQueue.add((GraphvizEngine)e), e -> Graphviz.useEngine(engines.subList(1, engines.size())));
        }
    }

    public static void initEngine() {
        Graphviz.useEngine(new GraphvizCmdLineEngine(), new GraphvizV8Engine(), new GraphvizServerEngine(), new GraphvizJdkEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GraphvizEngine getEngine() {
        if (engineQueue == null) {
            Graphviz.initEngine();
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine == null) {
                try {
                    engine = engineQueue.poll(60L, TimeUnit.SECONDS);
                    if (engine == null) {
                        throw new GraphvizException("Initializing graphviz engine took too long.");
                    }
                    if (engine instanceof ErrorGraphvizEngine) {
                        throw new GraphvizException("None of the provided engines could be initialized.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    public static void releaseEngine() {
        if (engine != null) {
            engine.release();
        }
        engine = null;
        engineQueue = null;
    }

    public static void printFontNames() {
        for (String name : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            System.out.println(name);
        }
    }

    public static Graphviz fromString(String src) {
        return new Graphviz(src, Rasterizer.BATIK, 0, 0, 1.0, Options.create());
    }

    public static Graphviz fromFile(File src) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            Graphviz graphviz = Graphviz.fromString(IoUtils.readStream(in));
            return graphviz;
        }
    }

    public static Graphviz fromGraph(Graph graph) {
        return Graphviz.fromGraph((MutableGraph)((Object)graph));
    }

    public static Graphviz fromGraph(MutableGraph graph) {
        return Graphviz.fromString(new Serializer(graph).serialize());
    }

    public Graphviz engine(Engine engine) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.options.engine(engine));
    }

    public Graphviz totalMemory(Integer totalMemory) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.options.totalMemory(totalMemory));
    }

    public Graphviz rasterizer(Rasterizer rasterizer) {
        return new Graphviz(this.src, rasterizer, this.width, this.height, this.scale, this.options);
    }

    public Graphviz width(int width) {
        return new Graphviz(this.src, this.rasterizer, width, this.height, this.scale, this.options);
    }

    public Graphviz height(int height) {
        return new Graphviz(this.src, this.rasterizer, this.width, height, this.scale, this.options);
    }

    public Graphviz scale(double scale) {
        return new Graphviz(this.src, this.rasterizer, this.width, this.height, scale, this.options);
    }

    public Renderer render(Format format) {
        Graphviz graphviz = new Graphviz(this.src, this.rasterizer, this.width, this.height, this.scale, this.options.format(format));
        return new Renderer(graphviz, null);
    }

    String execute() {
        return this.options.format.postProcess(Graphviz.getEngine().execute(this.src, this.options));
    }

    Format format() {
        return this.options.format;
    }

    private static class ErrorGraphvizEngine
    implements GraphvizEngine {
        private ErrorGraphvizEngine() {
        }

        @Override
        public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        }

        @Override
        public String execute(String src, Options options) {
            return null;
        }

        @Override
        public void release() {
        }
    }
}

