/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.Lit;
import org.apache.openjpa.jdbc.kernel.exps.Param;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.AbstractDB2Dictionary;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class DB2Dictionary
extends AbstractDB2Dictionary {
    private static final Localizer _loc = Localizer.forPackage(DB2Dictionary.class);
    public static final String VENDOR_IBM = "ibm";
    public String optimizeClause = "optimize for";
    public String rowClause = "row";
    protected int db2ServerType = 0;
    public static final int db2ISeriesV5R3OrEarlier = 1;
    public static final int db2UDBV81OrEarlier = 2;
    public static final int db2ZOSV8xOrLater = 3;
    public static final int db2UDBV82OrLater = 4;
    public static final int db2ISeriesV5R4OrLater = 5;
    protected static final String forUpdate = "FOR UPDATE";
    protected static final String withURClause = "WITH UR";
    protected static final String withCSClause = "WITH CS";
    protected static final String withRSClause = "WITH RS";
    protected static final String withRRClause = "WITH RR";
    protected static final String useKeepShareLockClause = "USE AND KEEP SHARE LOCKS";
    protected static final String useKeepUpdateLockClause = "USE AND KEEP UPDATE LOCKS";
    protected static final String useKeepExclusiveLockClause = "USE AND KEEP EXCLUSIVE LOCKS";
    protected static final String forReadOnlyClause = "FOR READ ONLY";
    protected static final String defaultSequenceSQL = "SELECT SEQSCHEMA AS SEQUENCE_SCHEMA, SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES";
    static final String SYSDUMMY = "SYSIBM.SYSDUMMY1";
    private int defaultBatchLimit = 100;
    public boolean appendExtendedExceptionText = true;
    public boolean supportsRowNum = false;

    public DB2Dictionary() {
        this.platform = "DB2";
        this.validationSQL = "SELECT DISTINCT(CURRENT TIMESTAMP) FROM SYSIBM.SYSTABLES";
        this.supportsSelectEndIndex = true;
        this.nextSequenceQuery = "VALUES NEXTVAL FOR {0}";
        this.sequenceSQL = defaultSequenceSQL;
        this.sequenceSchemaSQL = "SEQSCHEMA = ?";
        this.sequenceNameSQL = "SEQNAME = ?";
        this.characterColumnSize = 254;
        this.binaryTypeName = "BLOB(1M)";
        this.longVarbinaryTypeName = "BLOB(1M)";
        this.varbinaryTypeName = "BLOB(1M)";
        this.clobTypeName = "CLOB(1M)";
        this.longVarcharTypeName = "LONG VARCHAR";
        this.datePrecision = 1000;
        this.storeCharsAsNumbers = false;
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("LONG VARCHAR FOR BIT DATA", "LONG VARCHAR", "LONG VARGRAPHIC"));
        this.systemSchemas = "SYSCAT,SYSIBM,SYSSTAT,SYSIBMADM,SYSTOOLS";
        this.maxConstraintNameLength = 18;
        this.maxIndexNameLength = 128;
        this.maxColumnNameLength = 30;
        this.supportsDeferredConstraints = false;
        this.supportsDefaultDeleteAction = false;
        this.supportsAlterTableWithDropColumn = false;
        this.supportsLockingWithOrderClause = true;
        this.supportsNullUniqueColumn = false;
        this.supportsNullTableForGetColumns = false;
        this.requiresCastForMathFunctions = true;
        this.requiresCastForComparisons = true;
        this.reservedWordSet.addAll(Arrays.asList("AFTER", "ALIAS", "ALLOW", "APPLICATION", "ASSOCIATE", "ASUTIME", "AUDIT", "AUX", "AUXILIARY", "BEFORE", "BINARY", "BUFFERPOOL", "CACHE", "CALL", "CALLED", "CAPTURE", "CARDINALITY", "CCSID", "CLUSTER", "COLLECTION", "COLLID", "COMMENT", "CONCAT", "CONDITION", "CONTAINS", "COUNT_BIG", "CURRENT_LC_CTYPE", "CURRENT_PATH", "CURRENT_SERVER", "CURRENT_TIMEZONE", "CYCLE", "DATABASE", "DAYS", "DB2GENERAL", "DB2GENRL", "DB2SQL", "DBINFO", "DEFAULTS", "DEFINITION", "DETERMINISTIC", "DISALLOW", "DO", "DSNHATTR", "DSSIZE", "DYNAMIC", "EACH", "EDITPROC", "ELSEIF", "ENCODING", "END-EXEC1", "ERASE", "EXCLUDING", "EXIT", "FENCED", "FIELDPROC", "FILE", "FINAL", "FREE", "FUNCTION", "GENERAL", "GENERATED", "GRAPHIC", "HANDLER", "HOLD", "HOURS", "IF", "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INOUT", "INTEGRITY", "ISOBID", "ITERATE", "JAR", "JAVA", "LABEL", "LC_CTYPE", "LEAVE", "LINKTYPE", "LOCALE", "LOCATOR", "LOCATORS", "LOCK", "LOCKMAX", "LOCKSIZE", "LONG", "LOOP", "MAXVALUE", "MICROSECOND", "MICROSECONDS", "MINUTES", "MINVALUE", "MODE", "MODIFIES", "MONTHS", "NEW", "NEW_TABLE", "NOCACHE", "NOCYCLE", "NODENAME", "NODENUMBER", "NOMAXVALUE", "NOMINVALUE", "NOORDER", "NULLS", "NUMPARTS", "OBID", "OLD", "OLD_TABLE", "OPTIMIZATION", "OPTIMIZE", "OUT", "OVERRIDING", "PACKAGE", "PARAMETER", "PART", "PARTITION", "PATH", "PIECESIZE", "PLAN", "PRIQTY", "PROGRAM", "PSID", "QUERYNO", "READS", "RECOVERY", "REFERENCING", "RELEASE", "RENAME", "REPEAT", "RESET", "RESIGNAL", "RESTART", "RESULT", "RESULT_SET_LOCATOR", "RETURN", "RETURNS", "ROUTINE", "ROW", "RRN", "RUN", "SAVEPOINT", "SCRATCHPAD", "SECONDS", "SECQTY", "SECURITY", "SENSITIVE", "SIGNAL", "SIMPLE", "SOURCE", "SPECIFIC", "SQLID", "STANDARD", "START", "STATIC", "STAY", "STOGROUP", "STORES", "STYLE", "SUBPAGES", "SYNONYM", "SYSFUN", "SYSIBM", "SYSPROC", "SYSTEM", "TABLESPACE", "TRIGGER", "UNDO", "UNTIL", "VALIDPROC", "VARIABLE", "VARIANT", "VCAT", "VOLUMES", "WHILE", "WLM", "YEARS"));
        this.invalidColumnWordSet.addAll(Arrays.asList("CONSTRAINT", "END-EXEC", "END-EXEC1"));
        super.setBatchLimit(this.defaultBatchLimit);
        this.selectWordSet.add("WITH");
    }

    @Override
    public boolean supportsRandomAccessResultSet(Select sel, boolean forUpdate) {
        return !forUpdate && super.supportsRandomAccessResultSet(sel, forUpdate);
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (!subselect) {
            buf.append(" FETCH FIRST ").append(Long.toString(end)).append(" ROWS ONLY");
        }
    }

    @Override
    protected void appendSelect(SQLBuffer selectSQL, Object alias, Select sel, int idx) {
        boolean toCast;
        Object val = sel.getSelects().get(idx);
        boolean bl = toCast = val instanceof Lit && ((Lit)val).getParseType() != 8 && ((Lit)val).getParseType() != 9 && ((Lit)val).getParseType() != 10;
        if (toCast) {
            selectSQL.append("CAST(");
        }
        super.appendSelect(selectSQL, alias, sel, idx);
        if (toCast) {
            Class c = ((Lit)val).getType();
            int javaTypeCode = JavaTypes.getTypeCode((Class)c);
            int jdbcTypeCode = this.getJDBCType(javaTypeCode, false);
            String typeName = this.getTypeName(jdbcTypeCode);
            selectSQL.append(" AS " + typeName);
            if (String.class.equals((Object)c)) {
                selectSQL.append("(" + this.getCastStringColumnSize(val) + ")");
            }
            selectSQL.append(")");
        }
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sequenceSQL);
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(this.sequenceSchemaSQL);
            if (!DBIdentifier.isNull(sequenceName)) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append(this.sequenceNameSQL);
        }
        return buf.toString();
    }

    @Override
    public Connection decorate(Connection conn) throws SQLException {
        conn = super.decorate(conn);
        if (this.conf.getTransactionIsolationConstant() == -1 && conn.getTransactionIsolation() < 2) {
            conn.setTransactionIsolation(2);
        }
        return conn;
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        DatabaseMetaData metaData = conn.getMetaData();
        String driverName = metaData.getDriverName();
        this.driverVendor = driverName != null && driverName.startsWith("IBM DB2") ? VENDOR_IBM : "other";
        this.getProductVersionMajorMinorForISeries();
        if (this.versionLaterThan(0)) {
            if (this.isDB2ISeriesV5R3OrEarlier()) {
                this.db2ServerType = 1;
            } else if (this.isDB2ISeriesV5R4OrLater()) {
                this.db2ServerType = 5;
            }
        }
        if (this.db2ServerType == 0) {
            if (this.isJDBC3) {
                this.setMajorVersion(metaData.getDatabaseMajorVersion());
                this.setMinorVersion(metaData.getDatabaseMinorVersion());
            } else {
                this.getProductVersionMajorMinor();
            }
            if (this.isDB2UDBV81OrEarlier()) {
                this.db2ServerType = 2;
            } else if (this.isDB2ZOSV8xOrLater()) {
                this.db2ServerType = 3;
            } else if (this.isDB2UDBV82OrLater()) {
                this.db2ServerType = 4;
            }
        }
        if (this.db2ServerType == 0 || this.getMajorVersion() < 0) {
            throw new UnsupportedException(_loc.get("db-not-supported", new Object[]{this.databaseProductName, this.databaseProductVersion}));
        }
        if (this.versionEqualOrLaterThan(9, 2)) {
            this.supportsLockingWithMultipleTables = true;
            this.supportsLockingWithInnerJoin = true;
            this.supportsLockingWithOuterJoin = true;
            this.forUpdateClause = "WITH RR USE AND KEEP UPDATE LOCKS";
            this.supportsXMLColumn = this.versionEqualOrLaterThan(9, 0);
        }
        switch (this.db2ServerType) {
            case 4: {
                this.lastGeneratedKeyQuery = "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
                break;
            }
            case 3: {
                this.characterColumnSize = 255;
                this.lastGeneratedKeyQuery = "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
                this.nextSequenceQuery = "SELECT NEXTVAL FOR {0} FROM SYSIBM.SYSDUMMY1";
                if (defaultSequenceSQL.equals(this.sequenceSQL)) {
                    this.sequenceSQL = "SELECT SCHEMA AS SEQUENCE_SCHEMA, NAME AS SEQUENCE_NAME FROM SYSIBM.SYSSEQUENCES";
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("sequencesql-override", new Object[]{defaultSequenceSQL, this.sequenceSQL}));
                    }
                }
                this.sequenceSchemaSQL = "SCHEMA = ?";
                this.sequenceNameSQL = "NAME = ?";
                if (this.getMajorVersion() != 8) break;
                this.bigintTypeName = "DECIMAL(31,0)";
                break;
            }
            case 1: 
            case 5: {
                this.lastGeneratedKeyQuery = "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
                this.nextSequenceQuery = "SELECT NEXTVAL FOR {0} FROM SYSIBM.SYSDUMMY1";
                this.validationSQL = "SELECT DISTINCT(CURRENT TIMESTAMP) FROM QSYS2.SYSTABLES";
                if (defaultSequenceSQL.equals(this.sequenceSQL)) {
                    this.sequenceSQL = "SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM QSYS2.SYSSEQUENCES";
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("sequencesql-override", new Object[]{defaultSequenceSQL, this.sequenceSQL}));
                    }
                }
                this.sequenceSchemaSQL = "SEQUENCE_SCHEMA = ?";
                this.sequenceNameSQL = "SEQUENCE_NAME = ?";
                if (!this.isDB2ISeriesV5R4OrEarlier()) break;
                this.supportsGetGeneratedKeys = false;
            }
        }
    }

    @Override
    public boolean supportsIsolationForUpdate() {
        return true;
    }

    @Override
    protected String getForUpdateClause(JDBCFetchConfiguration fetch, boolean isForUpdate, Select sel) {
        StringBuffer forUpdateString = new StringBuffer(this.getOptimizeClause(sel));
        int isolationLevel = fetch != null && fetch.getIsolation() != -1 ? fetch.getIsolation() : this.conf.getTransactionIsolationConstant();
        if (fetch != null && fetch.getReadLockLevel() >= 40) {
            isolationLevel = 8;
        }
        if (isForUpdate) {
            switch (this.db2ServerType) {
                case 1: 
                case 2: {
                    if (isolationLevel == 8) {
                        forUpdateString.append(" ").append(this.forUpdateClause);
                        break;
                    }
                    forUpdateString.append(" ").append(forUpdate).append(" ").append(withRSClause);
                    break;
                }
                case 3: 
                case 4: {
                    if (isolationLevel == 8) {
                        forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRRClause).append(" ").append(useKeepUpdateLockClause);
                        break;
                    }
                    forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRSClause).append(" ").append(useKeepUpdateLockClause);
                    break;
                }
                case 5: {
                    if (isolationLevel == 8) {
                        forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRRClause).append(" ").append(useKeepExclusiveLockClause);
                        break;
                    }
                    forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRSClause).append(" ").append(useKeepExclusiveLockClause);
                }
            }
        } else if (fetch != null && fetch.getIsolation() == 1 && sel != null && sel.getParent() == null) {
            forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withURClause);
        }
        return forUpdateString.toString();
    }

    public boolean isDB2UDBV82OrLater() {
        return (this.databaseProductVersion.indexOf("SQL") != -1 || this.databaseProductName.indexOf("DB2/") != -1) && this.versionEqualOrLaterThan(8, 2);
    }

    public boolean isDB2ZOSV8xOrLater() {
        return (this.databaseProductVersion.indexOf("DSN") != -1 || this.databaseProductName.indexOf("DB2/") == -1) && this.versionLaterThan(7);
    }

    public boolean isDB2ISeriesV5R3OrEarlier() {
        return this.databaseProductName.indexOf("AS") != -1 && this.versionEqualOrEarlierThan(5, 3);
    }

    public boolean isDB2ISeriesV5R4OrLater() {
        return this.databaseProductName.indexOf("AS") != -1 && this.versionEqualOrLaterThan(5, 4);
    }

    public boolean isDB2ISeriesV5R4OrEarlier() {
        return this.databaseProductName.indexOf("AS") != -1 && this.versionEqualOrEarlierThan(5, 4);
    }

    public boolean isDB2UDBV81OrEarlier() {
        return (this.databaseProductVersion.indexOf("SQL") != -1 || this.databaseProductName.indexOf("DB2/") != -1) && this.versionEqualOrEarlierThan(8, 1);
    }

    private void getProductVersionMajorMinorForISeries() {
        if (this.databaseProductName.indexOf("AS") != -1) {
            this.setMajorVersion(5);
            this.setMinorVersion(4);
            int index = this.databaseProductVersion.indexOf(86);
            if (index != -1) {
                String s = this.databaseProductVersion.substring(index);
                StringTokenizer stringtokenizer = new StringTokenizer(s = s.toUpperCase(Locale.ENGLISH), "VRM", false);
                if (stringtokenizer.countTokens() == 3) {
                    String s1 = stringtokenizer.nextToken();
                    this.setMajorVersion(Integer.parseInt(s1));
                    String s2 = stringtokenizer.nextToken();
                    this.setMinorVersion(Integer.parseInt(s2));
                }
            } else {
                index = this.databaseProductVersion.indexOf(48);
                if (index != -1) {
                    String s = this.databaseProductVersion.substring(index);
                    StringTokenizer stringtokenizer = new StringTokenizer(s = s.toUpperCase(Locale.ENGLISH), "0", false);
                    if (stringtokenizer.countTokens() == 2) {
                        String s1 = stringtokenizer.nextToken();
                        this.setMajorVersion(Integer.parseInt(s1));
                        String s2 = stringtokenizer.nextToken();
                        this.setMinorVersion(Integer.parseInt(s2));
                    }
                }
            }
        }
    }

    private void getProductVersionMajorMinor() {
        if (this.databaseProductVersion.indexOf("09") != -1) {
            this.setMajorVersion(9);
            if (this.databaseProductVersion.indexOf("01") != -1) {
                this.setMinorVersion(1);
            }
        } else if (this.databaseProductVersion.indexOf("08") != -1) {
            this.setMajorVersion(8);
            this.setMinorVersion(2);
            if (this.databaseProductVersion.indexOf("01") != -1) {
                this.setMinorVersion(1);
            }
        }
    }

    protected String getOptimizeClause(Select sel) {
        if (sel != null && sel.getExpectedResultCount() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(" ").append(this.optimizeClause).append(" ").append(String.valueOf(sel.getExpectedResultCount())).append(" ").append(this.rowClause);
            return buf.toString();
        }
        return "";
    }

    @Override
    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        if (this.appendExtendedExceptionText && causes != null && causes.length > 0) {
            msg = this.appendExtendedExceptionMsg(msg, causes[0]);
        }
        return super.newStoreException(msg, causes, failed);
    }

    private String appendExtendedExceptionMsg(String msg, SQLException sqle) {
        String GETSQLCA = "getSqlca";
        try {
            Method sqlcaM2 = sqle.getNextException().getClass().getMethod("getSqlca", null);
            Object sqlca = sqlcaM2.invoke((Object)sqle.getNextException(), new Object[0]);
            Method getSqlErrpMethd = sqlca.getClass().getMethod("getSqlErrp", null);
            Method getSqlWarnMethd = sqlca.getClass().getMethod("getSqlWarn", null);
            Method getSqlErrdMethd = sqlca.getClass().getMethod("getSqlErrd", null);
            StringBuilder errdStr = new StringBuilder();
            int[] errds = (int[])getSqlErrdMethd.invoke(sqlca, new Object[0]);
            for (int i = 0; i < errds.length; ++i) {
                errdStr.append(errdStr.length() > 0 ? ", " : "").append(errds[i]);
            }
            StringBuilder exceptionMsg = new StringBuilder();
            exceptionMsg.append("SQLCA OUTPUT");
            exceptionMsg.append("[Errp=");
            exceptionMsg.append(getSqlErrpMethd.invoke(sqlca, new Object[0]));
            exceptionMsg.append(", Errd=");
            exceptionMsg.append((CharSequence)errdStr);
            String Warn = new String((char[])getSqlWarnMethd.invoke(sqlca, new Object[0]));
            if (Warn.trim().length() != 0) {
                exceptionMsg.append(", Warn=");
                exceptionMsg.append(Warn);
                exceptionMsg.append("]");
            } else {
                exceptionMsg.append("]");
            }
            msg = msg.concat(exceptionMsg.toString());
            for (SQLException sqle2 = sqle.getNextException(); sqle2 != null; sqle2 = sqle2.getNextException()) {
                msg = msg.concat("\n" + sqle2.getMessage());
            }
            return msg;
        }
        catch (Throwable t) {
            return sqle.getMessage();
        }
    }

    public int getDb2ServerType() {
        return this.db2ServerType;
    }

    @Override
    protected void appendLength(SQLBuffer buf, int type) {
        if (type == 12) {
            buf.append("(").append(Integer.toString(this.characterColumnSize)).append(")");
        }
    }

    @Override
    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml && rhsxml) {
            this.appendXmlComparison2(buf, op, lhs, rhs);
        } else if (lhsxml) {
            this.appendXmlComparison1(buf, op, lhs, rhs);
        } else {
            this.appendXmlComparison1(buf, op, rhs, lhs);
        }
    }

    private void appendXmlComparison1(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        boolean castrhs = false;
        Class rc = Filters.wrap((Class)rhs.getType());
        int type = 0;
        if (rhs.isConstant()) {
            type = this.getJDBCType(JavaTypes.getTypeCode((Class)rc), false);
            castrhs = true;
        }
        this.appendXmlExists(buf, lhs);
        buf.append(" ").append(op).append(" ");
        buf.append("$");
        if (castrhs) {
            buf.append("Parm");
        } else {
            rhs.appendTo(buf);
        }
        buf.append("]' PASSING ");
        this.appendXmlVar(buf, lhs);
        buf.append(", ");
        if (castrhs) {
            this.appendCast(buf, rhs, type);
        } else {
            rhs.appendTo(buf);
        }
        buf.append(" AS \"");
        if (castrhs) {
            buf.append("Parm");
        } else {
            rhs.appendTo(buf);
        }
        buf.append("\")");
    }

    private void appendXmlComparison2(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        this.appendXmlExists(buf, lhs);
        buf.append(" ").append(op).append(" ");
        buf.append("$").append(rhs.getColumnAlias(rhs.getFieldMapping().getColumns()[0])).append("/*/");
        rhs.appendTo(buf);
        buf.append("]' PASSING ");
        this.appendXmlVar(buf, lhs);
        buf.append(", ");
        this.appendXmlVar(buf, rhs);
        buf.append(")");
    }

    private void appendXmlVar(SQLBuffer buf, FilterValue val) {
        buf.append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append(" AS ").append("\"").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append("\"");
    }

    private void appendXmlExists(SQLBuffer buf, FilterValue val) {
        buf.append("XMLEXISTS('");
        buf.append("$").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append("/*[");
        val.appendTo(buf);
    }

    private String addCastAsString(String func, String target, String asString) {
        String fstring = func;
        if (func.indexOf(target) != -1) {
            fstring = Strings.replace((String)func, (String)target, (String)("CAST(" + target + asString + ")"));
        }
        return fstring;
    }

    @Override
    public String addCastAsType(String func, Val val) {
        String fstring = null;
        String type = this.getTypeName(this.getJDBCType(JavaTypes.getTypeCode((Class)val.getType()), false));
        if (String.class.equals((Object)val.getType())) {
            type = type + "(" + this.getCastStringColumnSize(val) + ")";
        }
        fstring = "CAST(? AS " + type + ")";
        return fstring;
    }

    @Override
    public int getBatchLimit() {
        int limit = super.getBatchLimit();
        if (limit == -1) {
            limit = this.defaultBatchLimit;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("batch_unlimit", (Object)String.valueOf(limit)));
            }
        }
        return limit;
    }

    @Override
    public String getCastFunction(Val val, String func) {
        if ((val instanceof Lit || val instanceof Param) && func.indexOf("VARCHAR") == -1) {
            func = this.addCastAsString(func, "{0}", " AS VARCHAR(" + this.varcharCastLength + ")");
        }
        return func;
    }

    @Override
    public String getCastFunction(Val val, String func, Column col) {
        boolean doCast = false;
        if (val instanceof Lit || val instanceof Param) {
            doCast = true;
        }
        if (col.getType() != 12) {
            doCast = true;
        }
        if (doCast && func.indexOf("VARCHAR") == -1) {
            func = this.addCastAsString(func, "{0}", " AS VARCHAR(" + this.varcharCastLength + ")");
        }
        return func;
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        if (find.getValue() != null) {
            buf.append("LOCATE(CAST((");
            find.appendTo(buf);
            buf.append(") AS VARCHAR(1000)), ");
        } else {
            buf.append("LOCATE(");
            find.appendTo(buf);
            buf.append(", ");
        }
        if (str.getValue() != null) {
            buf.append("CAST((");
            str.appendTo(buf);
            buf.append(") AS VARCHAR(1000))");
        } else {
            str.appendTo(buf);
        }
        if (start != null) {
            if (start.getValue() != null) {
                buf.append(", CAST((");
                start.appendTo(buf);
                buf.append(") AS INTEGER)");
            } else {
                buf.append(", ");
                start.appendTo(buf);
            }
        }
        buf.append(")");
    }

    public void appendCast(SQLBuffer buf, FilterValue val, int type) {
        String post;
        int firstParam = this.castFunction.indexOf("{0}");
        String pre = this.castFunction.substring(0, firstParam);
        String mid = this.castFunction.substring(firstParam + 3);
        int secondParam = mid.indexOf("{1}");
        if (secondParam > -1) {
            post = mid.substring(secondParam + 3);
            mid = mid.substring(0, secondParam);
        } else {
            post = "";
        }
        if (val instanceof Lit || val instanceof Param) {
            buf.append(pre);
            val.appendTo(buf);
            buf.append(mid);
            buf.append(this.getTypeName(type));
            this.appendLength(buf, type);
            buf.append(post);
        } else {
            val.appendTo(buf);
            String sqlString = buf.getSQL(false);
            if (sqlString.endsWith("?")) {
                String typeName = this.getTypeName(type);
                if (String.class.equals((Object)val.getType())) {
                    typeName = typeName + "(" + this.getCastStringColumnSize(val) + ")";
                }
                String str = "CAST(? AS " + typeName + ")";
                buf.replaceSqlString(sqlString.length() - 1, sqlString.length(), str);
            }
        }
    }

    @Override
    public void createIndexIfNecessary(Schema schema, String table, Column pkColumn) {
        this.createIndexIfNecessary(schema, DBIdentifier.newTable(table), pkColumn);
    }

    @Override
    public void createIndexIfNecessary(Schema schema, DBIdentifier table, Column pkColumn) {
        if (this.db2ServerType == 3) {
            Table tab = schema.getTable(table);
            DBIdentifier fullIdxId = tab.getFullIdentifier().clone();
            DBIdentifier unQualifiedName = DBIdentifier.append(fullIdxId.getUnqualifiedName(), "IDX");
            fullIdxId.setName(this.getValidIndexName(unQualifiedName, tab));
            Index idx = tab.addIndex(fullIdxId);
            idx.setUnique(true);
            idx.addColumn(pkColumn);
        }
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        String errorState = ex.getSQLState();
        int errorCode = ex.getErrorCode();
        if (errorCode == -952 && "57014".equals(errorState)) {
            return false;
        }
        if (subtype == 1 && "57033".equals(errorState) && (ex.getMessage().indexOf("80") != -1 || errorCode == -913 && ex.getMessage().contains("00C9008E"))) {
            return false;
        }
        if (subtype == 6 && "57014".equals(errorState) && (errorCode == -952 || errorCode == -905)) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }

    @Override
    protected void setDelimitedCase(DatabaseMetaData metaData) {
        this.delimitedCase = "preserve";
    }

    @Override
    public void setQueryTimeout(PreparedStatement stmnt, int timeout) throws SQLException {
        if (this.db2ServerType == 3) {
            try {
                super.setQueryTimeout(stmnt, timeout);
            }
            catch (SQLException e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("error-setting-query-timeout", (Object)timeout, (Object)e.getMessage()), (Throwable)e);
                }
            }
        } else {
            super.setQueryTimeout(stmnt, timeout);
        }
    }

    @Override
    public void setBytes(PreparedStatement stmnt, int idx, byte[] val, Column col) throws SQLException {
        if (this.useSetBytesForBlobs || !DBIdentifier.isNull(col.getTypeIdentifier()) && col.getTypeIdentifier().getName().contains("BIT DATA")) {
            stmnt.setBytes(idx, val);
        } else {
            this.setBinaryStream(stmnt, idx, new ByteArrayInputStream(val), val.length, col);
        }
    }

    @Override
    public byte[] getBytes(ResultSet rs, int column) throws SQLException {
        if (this.useGetBytesForBlobs) {
            return rs.getBytes(column);
        }
        if (this.useGetObjectForBlobs) {
            return (byte[])rs.getObject(column);
        }
        try {
            Blob blob = this.getBlob(rs, column);
            if (blob == null) {
                return null;
            }
            int length = (int)blob.length();
            if (length == 0) {
                return null;
            }
            return blob.getBytes(1L, length);
        }
        catch (SQLException e) {
            try {
                return rs.getBytes(column);
            }
            catch (SQLException e2) {
                throw e;
            }
        }
    }

    private int getCastStringColumnSize(Object val) {
        int literalLen;
        String literal;
        int colSize = this.characterColumnSize;
        if (val instanceof Lit && (literal = (String)((Lit)val).getValue()) != null && (literalLen = literal.length()) > this.characterColumnSize) {
            colSize = literalLen;
        }
        return colSize;
    }

    @Override
    public void insertBlobForStreamingLoad(Row row, Column col, JDBCStore store, Object ob, Select sel) throws SQLException {
        if (ob != null) {
            row.setBinaryStream(col, (InputStream)ob, -1);
        } else {
            row.setNull(col);
        }
    }

    @Override
    public void insertClobForStreamingLoad(Row row, Column col, Object ob) throws SQLException {
        if (ob != null) {
            row.setCharacterStream(col, (Reader)ob, -1);
        } else {
            row.setNull(col);
        }
    }

    @Override
    public void updateBlob(Select sel, JDBCStore store, InputStream is) throws SQLException {
    }

    @Override
    public void updateClob(Select sel, JDBCStore store, Reader reader) throws SQLException {
    }

    @Override
    public void setDate(PreparedStatement stmnt, int idx, java.util.Date val, Column col) throws SQLException {
        if (this.db2ServerType == 3 && col == null && val != null && "java.util.Date".equals(val.getClass().getName())) {
            this.setDate(stmnt, idx, new Date(val.getTime()), null, col);
            return;
        }
        super.setDate(stmnt, idx, val, col);
    }

    public int getDB2MajorVersion() {
        return this.getMajorVersion();
    }

    public int getDB2MinorVersion() {
        return this.getMinorVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultSchemaName() {
        if (this.defaultSchemaName == null) {
            Connection conn = null;
            Statement stmnt = null;
            ResultSet rs = null;
            try {
                String str = "SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1";
                conn = this.getConnection();
                if (conn != null) {
                    String currSchema;
                    stmnt = conn.createStatement();
                    rs = stmnt.executeQuery(str);
                    if (rs.next() && (currSchema = rs.getString(1)) != null) {
                        this.setDefaultSchemaName(currSchema.trim());
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("can_not_get_current_schema", (Object)"Unable to obtain a datasource"));
                }
            }
            catch (SQLException e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("can_not_get_current_schema", (Object)e.getMessage()));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se) {}
                }
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException se) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException se) {}
                }
            }
        }
        return this.defaultSchemaName;
    }

    private Connection getConnection() throws SQLException {
        DataSource ds = null;
        try {
            ds = this.conf.getDataSource(null);
        }
        catch (UserException uex) {
            // empty catch block
        }
        if (ds == null) {
            try {
                ds = this.conf.getDataSource2(null);
            }
            catch (UserException userException) {
                // empty catch block
            }
        }
        if (ds != null) {
            return ds.getConnection();
        }
        return null;
    }

    @Override
    protected SQLBuffer toSelect(SQLBuffer select, JDBCFetchConfiguration fetch, SQLBuffer tables, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end, Select sel) {
        if (!this.supportsRowNum) {
            return super.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, start, end, sel);
        }
        if (!this.isUsingRange(start, end)) {
            return super.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        }
        SQLBuffer buf = new SQLBuffer(this);
        if (!this.requiresSubselectForRange(start, end, distinct, order)) {
            if (where != null && !where.isEmpty()) {
                buf.append(where).append(" AND ");
            }
            buf.append("ROWNUM <= ").appendValue(end);
            return super.toSelect(select, fetch, tables, buf, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        }
        SQLBuffer newsel = super.toSelect(select, fetch, tables, where, group, having, order, distinct, forUpdate, 0L, Long.MAX_VALUE, sel);
        if (!this.isUsingOffset(start)) {
            buf.append(this.getSelectOperation(fetch) + " * FROM (");
            buf.append(newsel);
            buf.append(") WHERE ROWNUM <= ").appendValue(end);
            return buf;
        }
        buf.append(this.getSelectOperation(fetch)).append(" * FROM (SELECT r.*, ROWNUM RNUM FROM (");
        buf.append(newsel);
        buf.append(") r");
        if (this.isUsingLimit(end)) {
            buf.append(" WHERE ROWNUM <= ").appendValue(end);
        }
        buf.append(") WHERE RNUM > ").appendValue(start);
        return buf;
    }

    private boolean requiresSubselectForRange(long start, long end, boolean distinct, SQLBuffer order) {
        if (!this.isUsingRange(start, end)) {
            return false;
        }
        return this.isUsingOffset(start) || distinct || this.isUsingOrderBy(order);
    }
}

