/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.PropertyConfigurator;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.sqoop.Sqoop;

public class SqoopMain
extends LauncherMain {
    public static final String SQOOP_SITE_CONF = "sqoop-site.xml";
    @VisibleForTesting
    static final Pattern[] SQOOP_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Job complete: (job_\\S*)"), Pattern.compile("Job (job_\\S*) has completed successfully"), Pattern.compile("Submitted application (application[0-9_]*)")};
    private static final String SQOOP_LOG4J_PROPS = "sqoop-log4j.properties";

    public static void main(String[] args) throws Exception {
        SqoopMain.run(SqoopMain.class, (String[])args);
    }

    private static Configuration initActionConf() {
        Configuration sqoopConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        sqoopConf.addResource(new Path("file:///", actionXml));
        SqoopMain.setYarnTag((Configuration)sqoopConf);
        String delegationToken = SqoopMain.getFilePathFromEnv((String)"HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            sqoopConf.setBoolean("sqoop.hbase.security.token.skip", true);
            sqoopConf.set("mapreduce.job.credentials.binary", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        return sqoopConf;
    }

    public static Configuration setUpSqoopSite() throws Exception {
        Configuration sqoopConf = SqoopMain.initActionConf();
        SqoopMain.createFileWithContentIfNotExists((String)SQOOP_SITE_CONF, (Configuration)sqoopConf);
        SqoopMain.logMasking((String)"Sqoop Configuration Properties:", (Iterable)sqoopConf);
        return sqoopConf;
    }

    private String setUpSqoopLog4J(Configuration sqoopConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("sqoop-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        String logLevel = sqoopConf.get("oozie.sqoop.log.level", "INFO");
        String rootLogLevel = sqoopConf.get("oozie.action.rootlogger.log.level", "INFO");
        this.log4jProperties.setProperty("log4j.rootLogger", rootLogLevel + ", A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.sqoop", logLevel + ", A");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.sqoop", "false");
        this.log4jProperties.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        this.log4jProperties.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.A.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        this.log4jProperties.setProperty("log4j.appender.jobid.file", logFile);
        this.log4jProperties.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapred", "INFO, jobid, A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapreduce.Job", "INFO, jobid, A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "INFO, jobid");
        String localProps = new File(SQOOP_LOG4J_PROPS).getAbsolutePath();
        SqoopMain.createFileWithContentIfNotExists((String)localProps, (Properties)this.log4jProperties);
        PropertyConfigurator.configure((String)SQOOP_LOG4J_PROPS);
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        System.out.println();
        System.out.println("Oozie Sqoop action configuration");
        System.out.println("=================================================================");
        Configuration sqoopConf = SqoopMain.setUpSqoopSite();
        String logFile = this.setUpSqoopLog4J(sqoopConf);
        String[] sqoopArgs = ActionUtils.getStrings((Configuration)sqoopConf, (String)"oozie.sqoop.args");
        if (sqoopArgs == null) {
            throw new RuntimeException("Action Configuration does not have [oozie.sqoop.args] property");
        }
        this.printArgs("Sqoop command arguments :", sqoopArgs);
        LauncherMain.killChildYarnJobs((Configuration)sqoopConf);
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Sqoop command line now >>>");
        System.out.println();
        System.out.flush();
        try {
            this.runSqoopJob(sqoopArgs);
        }
        finally {
            System.out.println("\n<<< Invocation of Sqoop command completed <<<\n");
            SqoopMain.writeExternalChildIDs((String)logFile, (Pattern[])SQOOP_JOB_IDS_PATTERNS, (String)"Sqoop");
        }
    }

    protected void runSqoopJob(String[] args) throws Exception {
        Sqoop.main((String[])args);
    }
}

