/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.Properties;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class XOozieClient
extends OozieClient {
    public static final String RM = "yarn.resourcemanager.address";
    public static final String NN = "fs.default.name";
    public static final String NN_2 = "fs.defaultFS";
    public static final String PIG_SCRIPT = "oozie.pig.script";
    public static final String PIG_OPTIONS = "oozie.pig.options";
    public static final String PIG_SCRIPT_PARAMS = "oozie.pig.script.params";
    public static final String HIVE_SCRIPT = "oozie.hive.script";
    public static final String HIVE_OPTIONS = "oozie.hive.options";
    public static final String HIVE_SCRIPT_PARAMS = "oozie.hive.script.params";
    public static final String SQOOP_COMMAND = "oozie.sqoop.command";
    public static final String SQOOP_OPTIONS = "oozie.sqoop.options";
    public static final String FILES = "oozie.files";
    public static final String ARCHIVES = "oozie.archives";
    public static final String IS_PROXY_SUBMISSION = "oozie.proxysubmission";

    protected XOozieClient() {
    }

    public XOozieClient(String oozieUrl) {
        super(oozieUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScript(String script) throws IOException {
        if (!new File(script).exists()) {
            throw new IOException("Error: script file [" + script + "] does not exist");
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(script));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
    }

    private String serializeSqoopCommand(String[] command) {
        StringBuilder sb = new StringBuilder();
        for (String arg : command) {
            sb.append(arg).append("\n");
        }
        return sb.toString();
    }

    static void setStrings(Properties conf, String key, String[] values) {
        if (values != null) {
            conf.setProperty(key + ".size", new Integer(values.length).toString());
            for (int i = 0; i < values.length; ++i) {
                conf.setProperty(key + "." + i, values[i]);
            }
        }
    }

    private void validateHttpSubmitConf(Properties conf) {
        String libPath;
        String RM = conf.getProperty(RM);
        if (RM == null) {
            throw new RuntimeException("Resource manager is not specified in conf");
        }
        String NN = conf.getProperty(NN);
        String NN_2 = conf.getProperty(NN_2);
        if (NN == null) {
            if (NN_2 == null) {
                throw new RuntimeException("namenode is not specified in conf");
            }
            NN = NN_2;
        }
        if ((libPath = conf.getProperty("oozie.libpath")) == null) {
            throw new RuntimeException("libpath is not specified in conf");
        }
        if (!libPath.contains(":/")) {
            String newLibPath;
            if (libPath.startsWith("/")) {
                newLibPath = NN.endsWith("/") ? NN + libPath.substring(1) : NN + libPath;
            } else {
                throw new RuntimeException("libpath should be absolute");
            }
            conf.setProperty("oozie.libpath", newLibPath);
        }
        conf.setProperty(IS_PROXY_SUBMISSION, "true");
    }

    @Deprecated
    public String submitPig(Properties conf, String pigScriptFile, String[] pigArgs) throws IOException, OozieClientException {
        return this.submitScriptLanguage(conf, pigScriptFile, pigArgs, "pig");
    }

    public String submitScriptLanguage(Properties conf, String scriptFile, String[] args, String jobType) throws IOException, OozieClientException {
        return this.submitScriptLanguage(conf, scriptFile, args, null, jobType);
    }

    public String submitScriptLanguage(Properties conf, String scriptFile, String[] args, String[] params, String jobType) throws IOException, OozieClientException {
        OozieClient.notNull(conf, "conf");
        OozieClient.notNull(scriptFile, "scriptFile");
        this.validateHttpSubmitConf(conf);
        String script = "";
        String options = "";
        String scriptParams = "";
        if (jobType.equals("hive")) {
            script = HIVE_SCRIPT;
            options = HIVE_OPTIONS;
            scriptParams = HIVE_SCRIPT_PARAMS;
        } else if (jobType.equals("pig")) {
            script = PIG_SCRIPT;
            options = PIG_OPTIONS;
            scriptParams = PIG_SCRIPT_PARAMS;
        } else {
            throw new IllegalArgumentException("jobType must be either pig or hive");
        }
        conf.setProperty(script, this.readScript(scriptFile));
        XOozieClient.setStrings(conf, options, args);
        XOozieClient.setStrings(conf, scriptParams, params);
        return (String)new HttpJobSubmit(conf, jobType).call();
    }

    public String submitSqoop(Properties conf, String[] command, String[] args) throws OozieClientException {
        OozieClient.notNull(conf, "conf");
        OozieClient.notNull(command, "command");
        this.validateHttpSubmitConf(conf);
        conf.setProperty(SQOOP_COMMAND, this.serializeSqoopCommand(command));
        XOozieClient.setStrings(conf, SQOOP_OPTIONS, args);
        return (String)new HttpJobSubmit(conf, "sqoop").call();
    }

    public String submitMapReduce(Properties conf) throws OozieClientException {
        OozieClient.notNull(conf, "conf");
        this.validateHttpSubmitConf(conf);
        return (String)new HttpJobSubmit(conf, "mapreduce").call();
    }

    public void setLib(Properties conf, String pathStr) {
        conf.setProperty("oozie.libpath", pathStr);
    }

    public void addFile(Properties conf, String file) {
        OozieClient.notEmpty(file, "file");
        String files = conf.getProperty(FILES);
        conf.setProperty(FILES, files == null ? file : files + "," + file);
    }

    public void addArchive(Properties conf, String file) {
        OozieClient.notEmpty(file, "file");
        String files = conf.getProperty(ARCHIVES);
        conf.setProperty(ARCHIVES, files == null ? file : files + "," + file);
    }

    private class HttpJobSubmit
    extends OozieClient.ClientCallable<String> {
        private Properties conf;

        HttpJobSubmit(Properties conf, String jobType) {
            super(XOozieClient.this, "POST", "jobs", "", OozieClient.prepareParams("jobtype", jobType));
            this.conf = OozieClient.notNull(conf, "conf");
        }

        @Override
        protected String call(HttpURLConnection conn) throws IOException, OozieClientException {
            conn.setRequestProperty("content-type", "application/xml");
            XOozieClient.this.writeToXml(this.conf, conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                return (String)json.get((Object)"id");
            }
            if (conn.getResponseCode() != 200) {
                OozieClient.handleError(conn);
            }
            return null;
        }
    }
}

