/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.FilterMapper;
import org.apache.oozie.server.HttpConfigurationWrapper;
import org.apache.oozie.server.JspHandler;
import org.apache.oozie.server.SSLServerConnectorFactory;
import org.apache.oozie.server.ServletMapper;
import org.apache.oozie.server.guice.OozieGuiceModule;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedOozieServer {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedOozieServer.class);
    protected static final String OOZIE_HTTPS_TRUSTSTORE_FILE = "oozie.https.truststore.file";
    protected static final String TRUSTSTORE_PATH_SYSTEM_PROPERTY = "javax.net.ssl.trustStore";
    private static String contextPath;
    protected Server server;
    private int httpPort;
    private int httpsPort;
    private final WebAppContext servletContextHandler;
    private final ServletMapper oozieServletMapper;
    private final FilterMapper oozieFilterMapper;
    private JspHandler jspHandler;
    private Services serviceController;
    private SSLServerConnectorFactory sslServerConnectorFactory;
    private Configuration conf;
    private final RewriteHandler oozieRewriteHandler;
    private final ConstraintSecurityHandler constraintSecurityHandler;

    @Inject
    public EmbeddedOozieServer(Server server, JspHandler jspHandler, Services serviceController, SSLServerConnectorFactory sslServerConnectorFactory, RewriteHandler oozieRewriteHandler, WebAppContext servletContextHandler, ServletMapper oozieServletMapper, FilterMapper oozieFilterMapper, ConstraintSecurityHandler constraintSecurityHandler) {
        this.constraintSecurityHandler = constraintSecurityHandler;
        this.serviceController = (Services)Preconditions.checkNotNull((Object)serviceController, (Object)"serviceController is null");
        this.jspHandler = (JspHandler)Preconditions.checkNotNull((Object)jspHandler, (Object)"jspHandler is null");
        this.sslServerConnectorFactory = (SSLServerConnectorFactory)Preconditions.checkNotNull((Object)sslServerConnectorFactory, (Object)"sslServerConnectorFactory is null");
        this.server = (Server)Preconditions.checkNotNull((Object)server, (Object)"server is null");
        this.oozieRewriteHandler = (RewriteHandler)Preconditions.checkNotNull((Object)oozieRewriteHandler, (Object)"rewriter is null");
        this.servletContextHandler = (WebAppContext)Preconditions.checkNotNull((Object)servletContextHandler, (Object)"servletContextHandler is null");
        this.oozieServletMapper = (ServletMapper)Preconditions.checkNotNull((Object)oozieServletMapper, (Object)"oozieServletMapper is null");
        this.oozieFilterMapper = (FilterMapper)Preconditions.checkNotNull((Object)oozieFilterMapper, (Object)"oozieFilterMapper is null");
    }

    public void setup() throws URISyntaxException, IOException, ServiceException {
        this.conf = ((ConfigurationService)this.serviceController.get(ConfigurationService.class)).getConf();
        EmbeddedOozieServer.setContextPath(this.conf);
        this.httpPort = this.getConfigPort("oozie.http.port");
        HttpConfiguration httpConfiguration = new HttpConfigurationWrapper(this.conf).getDefaultHttpConfiguration();
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        connector.setPort(this.httpPort);
        connector.setHost(this.conf.get("oozie.http.hostname"));
        HandlerCollection handlerCollection = new HandlerCollection();
        this.setTrustStore();
        if (this.isSecured()) {
            this.httpsPort = this.getConfigPort("oozie.https.port");
            ServerConnector sslConnector = this.sslServerConnectorFactory.createSecureServerConnector(this.httpsPort, this.conf, this.server);
            this.server.setConnectors(new Connector[]{connector, sslConnector});
            this.constraintSecurityHandler.setHandler((Handler)this.servletContextHandler);
            handlerCollection.addHandler((Handler)this.constraintSecurityHandler);
        } else {
            this.server.setConnectors(new Connector[]{connector});
        }
        this.servletContextHandler.setContextPath(contextPath);
        this.oozieServletMapper.mapOozieServlets();
        this.oozieFilterMapper.addFilters();
        this.servletContextHandler.setParentLoaderPriority(true);
        this.jspHandler.setupWebAppContext(this.servletContextHandler);
        this.addErrorHandler();
        handlerCollection.addHandler((Handler)this.servletContextHandler);
        handlerCollection.addHandler((Handler)this.oozieRewriteHandler);
        this.server.setHandler((Handler)handlerCollection);
    }

    private void setTrustStore() {
        if (System.getProperty(TRUSTSTORE_PATH_SYSTEM_PROPERTY) == null) {
            String trustStorePath = this.conf.get(OOZIE_HTTPS_TRUSTSTORE_FILE);
            if (trustStorePath != null) {
                LOG.info("Setting javax.net.ssl.trustStore from config file");
                System.setProperty(TRUSTSTORE_PATH_SYSTEM_PROPERTY, trustStorePath);
            }
        } else {
            LOG.info("javax.net.ssl.trustStore is already set. The value from config file will be ignored");
        }
    }

    private void addErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(400, "/error");
        errorHandler.addErrorPage(401, "/error");
        errorHandler.addErrorPage(403, "/error");
        errorHandler.addErrorPage(404, "/error");
        errorHandler.addErrorPage(405, "/error");
        errorHandler.addErrorPage(409, "/error");
        errorHandler.addErrorPage(500, "/error");
        errorHandler.addErrorPage(501, "/error");
        errorHandler.addErrorPage(503, "/error");
        errorHandler.addErrorPage("java.lang.Throwable", "/error");
        this.servletContextHandler.setErrorHandler((ErrorHandler)errorHandler);
    }

    private int getConfigPort(String confVar) {
        int port;
        String confHttpPort = this.conf.get(confVar);
        try {
            port = Integer.parseInt(confHttpPort);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(String.format("Port number for '%s \"%s\" ('%s') is not an integer.", confVar, confHttpPort, confHttpPort));
        }
        return port;
    }

    private boolean isSecured() {
        String isSSLEnabled = this.conf.get("oozie.https.enabled");
        LOG.info("Server started with oozie.https.enabled = " + isSSLEnabled);
        return isSSLEnabled != null && Boolean.valueOf(isSSLEnabled) != false;
    }

    public static void setContextPath(Configuration oozieConfiguration) {
        String baseUrl = oozieConfiguration.get("oozie.base.url");
        String contextPath = baseUrl.substring(baseUrl.lastIndexOf("/"));
        LOG.info("Server started with contextPath = " + contextPath);
        EmbeddedOozieServer.contextPath = contextPath;
    }

    public static String getContextPath(Configuration oozieConfiguration) {
        if (contextPath != null) {
            return contextPath;
        }
        EmbeddedOozieServer.setContextPath(oozieConfiguration);
        return contextPath;
    }

    public void start() throws Exception {
        this.server.start();
        LOG.info("Server started.");
    }

    public void shutdown() throws Exception {
        LOG.info("Shutting down.");
        if (this.serviceController != null) {
            this.serviceController.destroy();
            LOG.info("Oozie services stopped.");
        }
        if (this.server != null) {
            this.server.stop();
            LOG.info("Server stopped.");
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    EmbeddedOozieServer.this.shutdown();
                }
                catch (Exception e) {
                    LOG.error(String.format("There were errors during shutdown. Error message: %s", e.getMessage()));
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Injector guiceInjector = Guice.createInjector((Module[])new Module[]{new OozieGuiceModule()});
        EmbeddedOozieServer embeddedOozieServer = null;
        try {
            embeddedOozieServer = (EmbeddedOozieServer)guiceInjector.getInstance(EmbeddedOozieServer.class);
        }
        catch (ProvisionException ex) {
            LOG.error(ex.getMessage());
            System.exit(1);
        }
        embeddedOozieServer.addShutdownHook();
        embeddedOozieServer.setup();
        try {
            embeddedOozieServer.start();
        }
        catch (Exception e) {
            LOG.error(String.format("Could not start EmbeddedOozieServer! Error message: %s", e.getMessage()));
            System.exit(1);
        }
        embeddedOozieServer.join();
    }
}

