/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.oozie.servlet.AuthFilter;
import org.apache.oozie.servlet.HostnameFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class FilterMapper {
    private final WebAppContext servletContextHandler;

    @Inject
    public FilterMapper(WebAppContext servletContextHandler) {
        this.servletContextHandler = (WebAppContext)Preconditions.checkNotNull((Object)servletContextHandler, (Object)"ServletContextHandler is null");
    }

    void addFilters() {
        this.mapFilter(new FilterHolder((Filter)new HostnameFilter()), "/*");
        FilterHolder authFilter = new FilterHolder((Filter)new AuthFilter());
        this.mapFilter(authFilter, "/versions/*");
        this.mapFilter(authFilter, "/v0/*");
        this.mapFilter(authFilter, "/v1/*");
        this.mapFilter(authFilter, "/v2/*");
        this.mapFilter(authFilter, "/index.jsp");
        this.mapFilter(authFilter, "/admin/*");
        this.mapFilter(authFilter, "/*.js");
        this.mapFilter(authFilter, "/ext-2.2/*");
        this.mapFilter(authFilter, "/docs/*");
        this.mapFilter(authFilter, "/error/*");
    }

    private void mapFilter(FilterHolder authFilter, String pathSpec) {
        this.servletContextHandler.addFilter(authFilter, pathSpec, EnumSet.of(DispatcherType.REQUEST));
    }
}

