/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.eclipse.jetty.server.HttpConfiguration;

public class HttpConfigurationWrapper {
    public static final String OOZIE_HTTP_REQUEST_HEADER_SIZE = "oozie.http.request.header.size";
    public static final String OOZIE_HTTP_RESPONSE_HEADER_SIZE = "oozie.http.response.header.size";
    private Configuration conf;

    public HttpConfigurationWrapper(Configuration conf) {
        this.conf = (Configuration)Preconditions.checkNotNull((Object)conf, (Object)"conf");
    }

    public HttpConfiguration getDefaultHttpConfiguration() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setRequestHeaderSize(this.getConfigHeaderSize(OOZIE_HTTP_REQUEST_HEADER_SIZE));
        httpConfiguration.setResponseHeaderSize(this.getConfigHeaderSize(OOZIE_HTTP_RESPONSE_HEADER_SIZE));
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        return httpConfiguration;
    }

    private int getConfigHeaderSize(String confVar) {
        int headerSize;
        String confHeaderSize = this.conf.get(confVar);
        try {
            headerSize = Integer.parseInt(confHeaderSize);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(String.format("Header size for %s \"%s\" ( '%s') is not an integer.", confVar, confVar, confHeaderSize));
        }
        return headerSize;
    }
}

