/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContainerInitializer;
import org.apache.oozie.server.WebRootResourceLocator;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JspHandler.class);
    private final File scratchDir;
    private final WebRootResourceLocator webRootResourceLocator;

    public JspHandler(File scratchDir, WebRootResourceLocator webRootResourceLocator) {
        this.scratchDir = scratchDir;
        this.webRootResourceLocator = webRootResourceLocator;
    }

    private File getScratchDir() throws IOException {
        if (this.scratchDir.exists()) {
            LOG.info(String.format("Scratch directory exists and will be reused: %s", this.scratchDir.getAbsolutePath()));
            return this.scratchDir;
        }
        if (!this.scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + this.scratchDir);
        }
        LOG.info(String.format("Scratch directory created: %s", this.scratchDir.getAbsolutePath()));
        return this.scratchDir;
    }

    public void setupWebAppContext(WebAppContext servletContextHandler) throws IOException, URISyntaxException {
        Preconditions.checkNotNull((Object)servletContextHandler, (Object)"servletContextHandler is null");
        File scratchDir = this.getScratchDir();
        servletContextHandler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        servletContextHandler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/.*taglibs.*\\.jar$");
        URI baseUri = this.webRootResourceLocator.getWebRootResourceUri();
        servletContextHandler.setResourceBase(baseUri.toASCIIString());
        servletContextHandler.setAttribute("org.eclipse.jetty.containerInitializers", this.jspInitializers());
        servletContextHandler.addBean((Object)new ServletContainerInitializersStarter(servletContextHandler), true);
        servletContextHandler.setClassLoader(this.getUrlClassLoader());
        servletContextHandler.addServlet(this.jspServletHolder(), "*.jsp");
        servletContextHandler.addServlet(this.jspFileMappedServletHolder(), "/oozie/");
        servletContextHandler.addServlet(this.defaultServletHolder(baseUri), "/");
    }

    private List<ContainerInitializer> jspInitializers() {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(initializer);
        return initializers;
    }

    private ClassLoader getUrlClassLoader() {
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        return jspClassLoader;
    }

    private ServletHolder jspServletHolder() {
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "DEBUG");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.7");
        holderJsp.setInitParameter("compilerSourceVM", "1.7");
        holderJsp.setInitParameter("keepgenerated", "true");
        return holderJsp;
    }

    private ServletHolder jspFileMappedServletHolder() {
        ServletHolder holderAltMapping = new ServletHolder();
        holderAltMapping.setName("index.jsp");
        holderAltMapping.setForcedPath("/index.jsp");
        return holderAltMapping;
    }

    private ServletHolder defaultServletHolder(URI baseUri) {
        ServletHolder holderDefault = new ServletHolder("default", DefaultServlet.class);
        holderDefault.setInitParameter("resourceBase", baseUri.toASCIIString());
        holderDefault.setInitParameter("dirAllowed", "true");
        return holderDefault;
    }
}

