/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.HttpConfigurationWrapper;
import org.apache.oozie.service.ConfigurationService;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLServerConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLServerConnectorFactory.class);
    public static final String OOZIE_HTTPS_KEYSTORE_PASS = "oozie.https.keystore.pass";
    public static final String OOZIE_HTTPS_KEYSTORE_FILE = "oozie.https.keystore.file";
    public static final String OOZIE_HTTPS_EXCLUDE_PROTOCOLS = "oozie.https.exclude.protocols";
    public static final String OOZIE_HTTPS_INCLUDE_PROTOCOLS = "oozie.https.include.protocols";
    public static final String OOZIE_HTTPS_INCLUDE_CIPHER_SUITES = "oozie.https.include.cipher.suites";
    public static final String OOZIE_HTTPS_EXCLUDE_CIPHER_SUITES = "oozie.https.exclude.cipher.suites";
    private SslContextFactory sslContextFactory;
    private Configuration conf;

    @Inject
    public SSLServerConnectorFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = (SslContextFactory)Preconditions.checkNotNull((Object)sslContextFactory, (Object)"sslContextFactory is null");
    }

    public ServerConnector createSecureServerConnector(int oozieHttpsPort, Configuration conf, Server server) {
        this.conf = (Configuration)Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)server, (Object)"server is null");
        Preconditions.checkState((oozieHttpsPort >= 1 && oozieHttpsPort <= 65535 ? 1 : 0) != 0, (Object)String.format("Invalid port number specified: '%d'. It should be between 1 and 65535.", oozieHttpsPort));
        this.setIncludeProtocols();
        this.setExcludeProtocols();
        this.setIncludeCipherSuites();
        this.setExludeCipherSuites();
        this.setKeyStoreFile();
        this.setKeystorePass();
        HttpConfiguration httpsConfiguration = this.getHttpsConfiguration();
        ServerConnector secureServerConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfiguration)});
        secureServerConnector.setPort(oozieHttpsPort);
        LOG.info(String.format("Secure server connector created, listening on port %d", oozieHttpsPort));
        return secureServerConnector;
    }

    private void setExludeCipherSuites() {
        String excludeCipherList = this.conf.get(OOZIE_HTTPS_EXCLUDE_CIPHER_SUITES);
        Object[] excludeCipherSuites = excludeCipherList.split(",");
        this.sslContextFactory.setExcludeCipherSuites((String[])excludeCipherSuites);
        LOG.info(String.format("SSL context - excluding cipher suites: %s", Arrays.toString(excludeCipherSuites)));
    }

    private void setIncludeCipherSuites() {
        String includeCipherList = this.conf.get(OOZIE_HTTPS_INCLUDE_CIPHER_SUITES);
        if (includeCipherList == null || includeCipherList.isEmpty()) {
            return;
        }
        Object[] includeCipherSuites = includeCipherList.split(",");
        this.sslContextFactory.setIncludeCipherSuites((String[])includeCipherSuites);
        LOG.info(String.format("SSL context - including cipher suites: %s", Arrays.toString(includeCipherSuites)));
    }

    private void setIncludeProtocols() {
        String enabledProtocolsList = this.conf.get(OOZIE_HTTPS_INCLUDE_PROTOCOLS);
        Object[] enabledProtocols = enabledProtocolsList.split(",");
        this.sslContextFactory.setIncludeProtocols((String[])enabledProtocols);
        LOG.info(String.format("SSL context - including protocols: %s", Arrays.toString(enabledProtocols)));
    }

    private void setExcludeProtocols() {
        String excludedProtocolsList = this.conf.get(OOZIE_HTTPS_EXCLUDE_PROTOCOLS);
        if (excludedProtocolsList == null || excludedProtocolsList.isEmpty()) {
            return;
        }
        Object[] excludedProtocols = excludedProtocolsList.split(",");
        this.sslContextFactory.setExcludeProtocols((String[])excludedProtocols);
        LOG.info(String.format("SSL context - excluding protocols: %s", Arrays.toString(excludedProtocols)));
    }

    private void setKeystorePass() {
        String keystorePass = ConfigurationService.getPassword((Configuration)this.conf, (String)OOZIE_HTTPS_KEYSTORE_PASS);
        Preconditions.checkNotNull((Object)keystorePass, (Object)"keystorePass is null");
        this.sslContextFactory.setKeyManagerPassword(keystorePass);
    }

    private void setKeyStoreFile() {
        String keystoreFile = this.conf.get(OOZIE_HTTPS_KEYSTORE_FILE);
        Preconditions.checkNotNull((Object)keystoreFile, (Object)"keystoreFile is null");
        this.sslContextFactory.setKeyStorePath(keystoreFile);
    }

    private HttpConfiguration getHttpsConfiguration() {
        HttpConfiguration https = new HttpConfigurationWrapper(this.conf).getDefaultHttpConfiguration();
        https.setSecureScheme("https");
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return https;
    }
}

