/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.servlet.Servlet;
import org.apache.oozie.servlet.CallbackServlet;
import org.apache.oozie.servlet.ErrorServlet;
import org.apache.oozie.servlet.SLAServlet;
import org.apache.oozie.servlet.V0AdminServlet;
import org.apache.oozie.servlet.V0JobServlet;
import org.apache.oozie.servlet.V0JobsServlet;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.servlet.V2AdminServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.apache.oozie.servlet.V2SLAServlet;
import org.apache.oozie.servlet.V2ValidateServlet;
import org.apache.oozie.servlet.VersionServlet;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletMapper {
    private final WebAppContext servletContextHandler;
    private static final Logger LOG = LoggerFactory.getLogger(ServletMapper.class);

    @Inject
    public ServletMapper(WebAppContext servletContextHandler) {
        this.servletContextHandler = (WebAppContext)Preconditions.checkNotNull((Object)servletContextHandler, (Object)"ServletContextHandler is null");
    }

    void mapOozieServlets() {
        this.mapServlet(VersionServlet.class, "/versions");
        this.mapServlet(V0AdminServlet.class, "/v0/admin/*");
        this.mapServlet(V1AdminServlet.class, "/v1/admin/*");
        this.mapServlet(V2AdminServlet.class, "/v2/admin/*");
        this.mapServlet(CallbackServlet.class, "/callback/*");
        ServletHandler servletHandler = this.servletContextHandler.getServletHandler();
        String v0JobsServletName = V0JobsServlet.class.getSimpleName();
        servletHandler.addServlet(new ServletHolder(v0JobsServletName, (Servlet)new V0JobsServlet()));
        ServletMapping jobServletMappingV0 = new ServletMapping();
        jobServletMappingV0.setPathSpec("/v0/jobs");
        jobServletMappingV0.setServletName(v0JobsServletName);
        String v1JobsServletName = V1JobsServlet.class.getSimpleName();
        servletHandler.addServlet(new ServletHolder(v1JobsServletName, (Servlet)new V1JobsServlet()));
        ServletMapping jobServletMappingV1 = new ServletMapping();
        jobServletMappingV1.setPathSpec("/v1/jobs");
        jobServletMappingV1.setServletName(v1JobsServletName);
        ServletMapping jobServletMappingV2 = new ServletMapping();
        jobServletMappingV2.setPathSpec("/v2/jobs");
        jobServletMappingV2.setServletName(v1JobsServletName);
        servletHandler.addServletMapping(jobServletMappingV0);
        servletHandler.addServletMapping(jobServletMappingV1);
        servletHandler.addServletMapping(jobServletMappingV2);
        this.mapServlet(V0JobServlet.class, "/v0/job/*");
        this.mapServlet(V1JobServlet.class, "/v1/job/*");
        this.mapServlet(V2JobServlet.class, "/v2/job/*");
        this.mapServlet(SLAServlet.class, "/v1/sla/*");
        this.mapServlet(V2SLAServlet.class, "/v2/sla/*");
        this.mapServlet(V2ValidateServlet.class, "/v2/validate/*");
        this.mapServlet(ErrorServlet.class, "/error/*");
    }

    private void mapServlet(Class<? extends Servlet> servletClass, String servletPath) {
        try {
            this.servletContextHandler.addServlet(new ServletHolder(servletClass.newInstance()), servletPath);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

