/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class JettyServerProvider
implements Provider<Server> {
    public static final String OOZIE_SERVER_THREADPOOL_MAX_THREADS = "oozie.server.threadpool.max.threads";
    private final Configuration oozieConfiguration;

    @Inject
    public JettyServerProvider(Services oozieServices) {
        this.oozieConfiguration = ((ConfigurationService)oozieServices.get(ConfigurationService.class)).getConf();
    }

    public Server get() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        int maxThreads = Integer.parseInt(this.oozieConfiguration.get(OOZIE_SERVER_THREADPOOL_MAX_THREADS));
        threadPool.setMaxThreads(maxThreads);
        return new Server((ThreadPool)threadPool);
    }
}

