/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.server.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.server.JspHandler;
import org.apache.oozie.server.WebRootResourceLocator;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;

public class JspHandlerProvider
implements Provider<JspHandler> {
    public static final String OOZIE_JSP_TMP_DIR = "oozie.jsp.tmp.dir";
    public static final String EMBEDDED_JETTY_JSP_DIR = "embedded-jetty-jsp";
    private final Configuration oozieConfiguration;

    @Inject
    public JspHandlerProvider(Services oozieServices) {
        this.oozieConfiguration = ((ConfigurationService)oozieServices.get(ConfigurationService.class)).getConf();
    }

    public JspHandler get() {
        File tempDir = new File(this.oozieConfiguration.get(OOZIE_JSP_TMP_DIR), EMBEDDED_JETTY_JSP_DIR);
        return new JspHandler(tempDir, new WebRootResourceLocator());
    }
}

