/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.util.NucleusLogger;

public class OIDMapping
extends SingleFieldMapping {
    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(ps, param[0], null);
        } else {
            OID oid;
            ApiAdapter api = ec.getApiAdapter();
            if (api.isPersistable(value)) {
                oid = (OID)api.getIdForObject(value);
                if (oid == null) {
                    if (ec.isInserting(value)) {
                        this.getDatastoreMapping(0).setObject(ps, param[0], null);
                        throw new NotYetFlushedException(value);
                    }
                    ec.persistObjectInternal(value, null, -1, 0);
                    ec.flushInternal(false);
                }
                oid = (OID)api.getIdForObject(value);
            } else {
                oid = (OID)value;
            }
            try {
                this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue());
            }
            catch (Exception e) {
                this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue().toString());
            }
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] param) {
        Object value;
        if (this.getNumberOfDatastoreMappings() > 0) {
            value = this.getDatastoreMapping(0).getObject(rs, param[0]);
        } else {
            if (this.referenceMapping != null) {
                return this.referenceMapping.getObject(ec, rs, param);
            }
            Class fieldType = this.mmd.getType();
            JavaTypeMapping referenceMapping = this.storeMgr.getDatastoreClass(fieldType.getName(), ec.getClassLoaderResolver()).getIdMapping();
            value = referenceMapping.getDatastoreMapping(0).getObject(rs, param[0]);
        }
        if (value != null) {
            value = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)this.getType(), (Object)value);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER_RDBMS.msg("041034", value));
            }
        }
        return value;
    }

    @Override
    public Class getJavaType() {
        return OID.class;
    }
}

