/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinOuterStringOperator
extends VectorMapJoinOuterGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOuterStringOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinOuterStringOperator.class.getName();
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient int singleJoinColumn;

    public VectorMapJoinOuterStringOperator() {
    }

    public VectorMapJoinOuterStringOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.outerPerBatchSetup(batch);
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    byte[] keyBytes = vector[0];
                    int keyStart = start[0];
                    int keyLength = length[0];
                    joinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                numSel = this.finishOuterRepeated(batch, joinResult, this.hashMapResults[0], this.scratch1);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int matchCount = 0;
                int nonSpillCount = 0;
                int spillCount = 0;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block15: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    boolean isNull;
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    boolean bl = isNull = !joinColVector.noNulls && joinColVector.isNull[batchIndex];
                    if (isNull) {
                        this.nonSpills[nonSpillCount++] = batchIndex;
                        continue;
                    }
                    if (!haveSaveKey || StringExpr.compare(vector[saveKeyBatchIndex], start[saveKeyBatchIndex], length[saveKeyBatchIndex], vector[batchIndex], start[batchIndex], length[batchIndex]) != 0) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: 
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKeyBatchIndex = batchIndex;
                        byte[] keyBytes = vector[batchIndex];
                        int keyStart = start[batchIndex];
                        int keyLength = length[batchIndex];
                        saveJoinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[hashMapResultCount]);
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.matchs[matchCount] = batchIndex;
                            this.matchHashMapResultIndices[matchCount] = hashMapResultCount;
                            ++matchCount;
                            this.nonSpills[nonSpillCount++] = batchIndex;
                            continue block15;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block15;
                        }
                        case NOMATCH: {
                            this.nonSpills[nonSpillCount++] = batchIndex;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: 
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " matchs " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.matchs, matchCount) + " matchHashMapResultIndices " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.matchHashMapResultIndices, matchCount) + " nonSpills " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.nonSpills, nonSpillCount) + " spills " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount))));
                }
                numSel = this.finishOuter(batch, this.matchs, this.matchHashMapResultIndices, matchCount, this.nonSpills, nonSpillCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashMapResults, hashMapResultCount, this.scratch1);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

