/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;

public class GenTezUtils {
    private static final Log LOG = LogFactory.getLog((String)GenTezUtils.class.getName());
    private int sequenceNumber = 0;
    private static GenTezUtils utils;

    public static GenTezUtils getUtils() {
        if (utils == null) {
            utils = new GenTezUtils();
        }
        return utils;
    }

    protected GenTezUtils() {
    }

    public void resetSequenceNumber() {
        this.sequenceNumber = 0;
    }

    public UnionWork createUnionWork(GenTezProcContext context, Operator<?> root, Operator<?> leaf, TezWork tezWork) {
        UnionWork unionWork = new UnionWork("Union " + ++this.sequenceNumber);
        context.rootUnionWorkMap.put(root, unionWork);
        context.unionWorkMap.put(leaf, unionWork);
        tezWork.add(unionWork);
        return unionWork;
    }

    public ReduceWork createReduceWork(GenTezProcContext context, Operator<?> root, TezWork tezWork) {
        assert (!root.getParentOperators().isEmpty());
        boolean isAutoReduceParallelism = context.conf.getBoolVar(HiveConf.ConfVars.TEZ_AUTO_REDUCER_PARALLELISM);
        float maxPartitionFactor = context.conf.getFloatVar(HiveConf.ConfVars.TEZ_MAX_PARTITION_FACTOR);
        float minPartitionFactor = context.conf.getFloatVar(HiveConf.ConfVars.TEZ_MIN_PARTITION_FACTOR);
        long bytesPerReducer = context.conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        ReduceWork reduceWork = new ReduceWork(Utilities.REDUCENAME + ++this.sequenceNumber);
        LOG.debug((Object)("Adding reduce work (" + reduceWork.getName() + ") for " + root));
        reduceWork.setReducer(root);
        reduceWork.setNeedsTagging(GenMapRedUtils.needsTagging(reduceWork));
        assert (context.parentOfRoot instanceof ReduceSinkOperator);
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)context.parentOfRoot;
        reduceWork.setNumReduceTasks(((ReduceSinkDesc)reduceSink.getConf()).getNumReducers());
        if (isAutoReduceParallelism && ((ReduceSinkDesc)reduceSink.getConf()).getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL)) {
            reduceWork.setAutoReduceParallelism(true);
            int maxReducers = context.conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
            int minPartition = Math.max(1, (int)((float)((ReduceSinkDesc)reduceSink.getConf()).getNumReducers() * minPartitionFactor));
            minPartition = minPartition > maxReducers ? maxReducers : minPartition;
            int maxPartition = (int)((float)((ReduceSinkDesc)reduceSink.getConf()).getNumReducers() * maxPartitionFactor);
            maxPartition = maxPartition > maxReducers ? maxReducers : maxPartition;
            reduceWork.setMinReduceTasks(minPartition);
            reduceWork.setMaxReduceTasks(maxPartition);
        }
        this.setupReduceSink(context, reduceWork, reduceSink);
        tezWork.add(reduceWork);
        TezEdgeProperty edgeProp = reduceWork.isAutoReduceParallelism() ? new TezEdgeProperty(context.conf, TezEdgeProperty.EdgeType.SIMPLE_EDGE, true, reduceWork.getMinReduceTasks(), reduceWork.getMaxReduceTasks(), bytesPerReducer) : new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        tezWork.connect(context.preceedingWork, reduceWork, edgeProp);
        context.connectedReduceSinks.add(reduceSink);
        return reduceWork;
    }

    protected void setupReduceSink(GenTezProcContext context, ReduceWork reduceWork, ReduceSinkOperator reduceSink) {
        LOG.debug((Object)("Setting up reduce sink: " + reduceSink + " with following reduce work: " + reduceWork.getName()));
        GenMapRedUtils.setKeyAndValueDesc(reduceWork, reduceSink);
        int tag = ((ReduceSinkDesc)reduceSink.getConf()).getTag();
        reduceWork.getTagToInput().put(tag == -1 ? 0 : tag, context.preceedingWork.getName());
        ((ReduceSinkDesc)reduceSink.getConf()).setOutputName(reduceWork.getName());
    }

    public MapWork createMapWork(GenTezProcContext context, Operator<?> root, TezWork tezWork, PrunedPartitionList partitions) throws SemanticException {
        assert (root.getParentOperators().isEmpty());
        MapWork mapWork = new MapWork(Utilities.MAPNAME + ++this.sequenceNumber);
        LOG.debug((Object)("Adding map work (" + mapWork.getName() + ") for " + root));
        assert (root instanceof TableScanOperator);
        TableScanOperator ts = (TableScanOperator)root;
        String alias = ((TableScanDesc)ts.getConf()).getAlias();
        this.setupMapWork(mapWork, context, partitions, root, alias);
        if (((TableScanDesc)ts.getConf()).getTableMetadata() != null && ((TableScanDesc)ts.getConf()).getTableMetadata().isDummyTable()) {
            mapWork.setDummyTableScan(true);
        }
        tezWork.add(mapWork);
        return mapWork;
    }

    protected void setupMapWork(MapWork mapWork, GenTezProcContext context, PrunedPartitionList partitions, Operator<? extends OperatorDesc> root, String alias) throws SemanticException {
        GenMapRedUtils.setMapWork(mapWork, context.parseContext, context.inputs, partitions, root, alias, context.conf, false);
    }

    public void removeUnionOperators(Configuration conf, GenTezProcContext context, BaseWork work) throws SemanticException {
        ArrayList roots = new ArrayList();
        roots.addAll(work.getAllRootOperators());
        if (work.getDummyOps() != null) {
            roots.addAll(work.getDummyOps());
        }
        roots.addAll(context.eventOperatorSet);
        List<Operator<?>> newRoots = Utilities.cloneOperatorTree(conf, roots);
        HashBiMap<Operator<?>, Operator<?>> replacementMap = HashBiMap.create();
        LinkedList<HashTableDummyOperator> dummyOps = new LinkedList<HashTableDummyOperator>();
        Iterator<Operator<?>> it = newRoots.iterator();
        for (Operator operator : roots) {
            Operator<?> newRoot = it.next();
            replacementMap.put(operator, newRoot);
            if (newRoot instanceof HashTableDummyOperator) {
                dummyOps.add((HashTableDummyOperator)newRoot);
                it.remove();
                continue;
            }
            if (newRoot instanceof AppMasterEventOperator) {
                if (newRoot.getConf() instanceof DynamicPruningEventDesc) {
                    TableScanOperator ts = ((DynamicPruningEventDesc)operator.getConf()).getTableScan();
                    if (ts == null) {
                        throw new AssertionError((Object)("No table scan associated with dynamic event pruning. " + operator));
                    }
                    ((DynamicPruningEventDesc)newRoot.getConf()).setTableScan(ts);
                }
                it.remove();
                continue;
            }
            if (newRoot instanceof TableScanOperator && context.tsToEventMap.containsKey(operator)) {
                for (AppMasterEventOperator event : context.tsToEventMap.get(operator)) {
                    ((DynamicPruningEventDesc)event.getConf()).setTableScan((TableScanOperator)newRoot);
                }
            }
            context.rootToWorkMap.remove(operator);
            context.rootToWorkMap.put(newRoot, work);
        }
        LinkedList operators = new LinkedList();
        operators.addAll(newRoots);
        HashSet<Operator> hashSet = new HashSet<Operator>();
        while (!operators.isEmpty()) {
            Operator current = (Operator)operators.pop();
            hashSet.add(current);
            if (current instanceof FileSinkOperator) {
                List<Object> linked;
                FileSinkOperator fileSink = (FileSinkOperator)current;
                context.fileSinkSet.add(fileSink);
                FileSinkDesc desc = (FileSinkDesc)fileSink.getConf();
                Path path = desc.getDirName();
                if (!context.linkedFileSinks.containsKey(path)) {
                    linked = new ArrayList();
                    context.linkedFileSinks.put(path, linked);
                }
                linked = context.linkedFileSinks.get(path);
                linked.add(desc);
                desc.setDirName(new Path(path, "" + linked.size()));
                desc.setLinkedFileSinkDesc(linked);
            }
            if (current instanceof AppMasterEventOperator) {
                context.eventOperatorSet.add((AppMasterEventOperator)current);
                context.abandonedEventOperatorSet.add((AppMasterEventOperator)replacementMap.inverse().get(current));
            }
            if (current instanceof UnionOperator) {
                Operator<OperatorDesc> parent = null;
                int count = 0;
                for (Operator<OperatorDesc> op : current.getParentOperators()) {
                    if (!hashSet.contains(op)) continue;
                    ++count;
                    parent = op;
                }
                assert (count <= 1);
                if (parent == null) {
                    replacementMap.put(current, current.getChildOperators().get(0));
                } else {
                    parent.removeChildAndAdoptItsChildren(current);
                }
            }
            if (current instanceof FileSinkOperator || current instanceof ReduceSinkOperator) {
                current.setChildOperators(null);
                continue;
            }
            operators.addAll(current.getChildOperators());
        }
        work.setDummyOps(dummyOps);
        work.replaceRoots(replacementMap);
    }

    public void processFileSink(GenTezProcContext context, FileSinkOperator fileSink) throws SemanticException {
        FetchTask fetchTask;
        ParseContext parseContext = context.parseContext;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseContext, fileSink);
        HiveConf hconf = parseContext.getConf();
        boolean chDir = GenMapRedUtils.isMergeRequired(context.moveTask, hconf, fileSink, context.currentTask, isInsertTable);
        Path finalName = GenMapRedUtils.createMoveTask(context.currentTask, chDir, fileSink, parseContext, context.moveTask, hconf, context.dependencyTask);
        if (chDir) {
            LOG.info((Object)"using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fileSink, finalName, context.dependencyTask, context.moveTask, hconf, context.currentTask);
        }
        if ((fetchTask = parseContext.getFetchTask()) != null && context.currentTask.getNumChild() == 0 && fetchTask.isFetchFrom((FileSinkDesc)fileSink.getConf())) {
            context.currentTask.setFetchSource(true);
        }
    }

    public void processAppMasterEvent(GenTezProcContext procCtx, AppMasterEventOperator event) {
        if (procCtx.abandonedEventOperatorSet.contains(event)) {
            return;
        }
        DynamicPruningEventDesc eventDesc = (DynamicPruningEventDesc)event.getConf();
        TableScanOperator ts = eventDesc.getTableScan();
        MapWork work = (MapWork)procCtx.rootToWorkMap.get(ts);
        if (work == null) {
            throw new AssertionError((Object)("No work found for tablescan " + ts));
        }
        BaseWork enclosingWork = this.getEnclosingWork(event, procCtx);
        if (enclosingWork == null) {
            throw new AssertionError((Object)("Cannot find work for operator" + event));
        }
        String sourceName = enclosingWork.getName();
        eventDesc.setVertexName(work.getName());
        eventDesc.setInputName(work.getAliases().get(0));
        if (!work.getEventSourceTableDescMap().containsKey(sourceName)) {
            work.getEventSourceTableDescMap().put(sourceName, new LinkedList());
        }
        List<TableDesc> tables = work.getEventSourceTableDescMap().get(sourceName);
        tables.add(((AppMasterEventDesc)event.getConf()).getTable());
        if (!work.getEventSourceColumnNameMap().containsKey(sourceName)) {
            work.getEventSourceColumnNameMap().put(sourceName, new LinkedList());
        }
        List<String> columns = work.getEventSourceColumnNameMap().get(sourceName);
        columns.add(eventDesc.getTargetColumnName());
        if (!work.getEventSourcePartKeyExprMap().containsKey(sourceName)) {
            work.getEventSourcePartKeyExprMap().put(sourceName, new LinkedList());
        }
        List<ExprNodeDesc> keys = work.getEventSourcePartKeyExprMap().get(sourceName);
        keys.add(eventDesc.getPartKey());
    }

    public BaseWork getEnclosingWork(Operator<?> op, GenTezProcContext procCtx) {
        ArrayList ops = new ArrayList();
        this.findRoots(op, ops);
        for (Operator operator : ops) {
            BaseWork work = procCtx.rootToWorkMap.get(operator);
            if (work == null) continue;
            return work;
        }
        return null;
    }

    private void findRoots(Operator<?> op, List<Operator<?>> ops) {
        List<Operator<OperatorDesc>> parents = op.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            ops.add(op);
            return;
        }
        for (Operator<OperatorDesc> p : parents) {
            this.findRoots(p, ops);
        }
    }
}

