/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.fast;

import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class LazyBinaryDeserializeRead
implements DeserializeRead {
    public static final Log LOG = LogFactory.getLog((String)LazyBinaryDeserializeRead.class.getName());
    private PrimitiveTypeInfo[] primitiveTypeInfos;
    private byte[] bytes;
    private int start;
    private int offset;
    private int end;
    private int fieldCount;
    private int fieldIndex;
    private byte nullByte;
    private DecimalTypeInfo saveDecimalTypeInfo;
    private HiveDecimal saveDecimal;
    private LazyBinaryUtils.VInt tempVInt;
    private LazyBinaryUtils.VLong tempVLong;
    private HiveDecimalWritable tempHiveDecimalWritable;
    private boolean readBeyondConfiguredFieldsWarned;
    private boolean readBeyondBufferRangeWarned;
    private boolean bufferRangeHasExtraDataWarned;

    public LazyBinaryDeserializeRead(PrimitiveTypeInfo[] primitiveTypeInfos) {
        this.primitiveTypeInfos = primitiveTypeInfos;
        this.fieldCount = primitiveTypeInfos.length;
        this.tempVInt = new LazyBinaryUtils.VInt();
        this.tempVLong = new LazyBinaryUtils.VLong();
        this.readBeyondConfiguredFieldsWarned = false;
        this.readBeyondBufferRangeWarned = false;
        this.bufferRangeHasExtraDataWarned = false;
    }

    private LazyBinaryDeserializeRead() {
    }

    @Override
    public PrimitiveTypeInfo[] primitiveTypeInfos() {
        return this.primitiveTypeInfos;
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.start = offset;
        this.end = offset + length;
        this.fieldIndex = 0;
    }

    @Override
    public boolean readCheckNull() throws IOException {
        if (this.fieldIndex >= this.fieldCount) {
            if (!this.readBeyondConfiguredFieldsWarned) {
                LOG.info((Object)("Reading beyond configured fields! Configured " + this.fieldCount + " fields but " + " reading more (NULLs returned).  Ignoring similar problems."));
                this.readBeyondConfiguredFieldsWarned = true;
            }
            return true;
        }
        if (this.fieldIndex == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        if ((this.nullByte & 1 << this.fieldIndex % 8) != 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            if (this.primitiveTypeInfos[this.fieldIndex].getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
                return false;
            }
            return this.earlyReadHiveDecimal();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return true;
    }

    @Override
    public void extraFieldsCheck() {
        if (this.offset < this.end && !this.bufferRangeHasExtraDataWarned) {
            int length = this.end - this.start;
            int remaining = this.end - this.offset;
            LOG.info((Object)("Not all fields were read in the buffer range! Buffer range " + this.start + " for length " + length + " but " + remaining + " bytes remain. " + "(total buffer length " + this.bytes.length + ")" + "  Ignoring similar problems."));
            this.bufferRangeHasExtraDataWarned = true;
        }
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.readBeyondConfiguredFieldsWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.readBeyondBufferRangeWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return this.bufferRangeHasExtraDataWarned;
    }

    private void warnBeyondEof() throws EOFException {
        if (!this.readBeyondBufferRangeWarned) {
            int length = this.end - this.start;
            LOG.info((Object)("Reading beyond buffer range! Buffer range " + this.start + " for length " + length + " but reading more... " + "(total buffer length " + this.bytes.length + ")" + "  Ignoring similar problems."));
            this.readBeyondBufferRangeWarned = true;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte result = this.bytes[this.offset++];
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return result != 0;
    }

    @Override
    public byte readByte() throws IOException {
        byte result = this.bytes[this.offset++];
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            if (this.fieldIndex % 8 == 0) {
                this.nullByte = this.bytes[this.offset++];
            }
        }
        return result;
    }

    @Override
    public short readShort() throws IOException {
        if (this.offset + 2 > this.end) {
            this.warnBeyondEof();
        }
        short result = LazyBinaryUtils.byteArrayToShort(this.bytes, this.offset);
        this.offset += 2;
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return result;
    }

    @Override
    public int readInt() throws IOException {
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return this.tempVInt.value;
    }

    @Override
    public long readLong() throws IOException {
        LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
        this.offset += this.tempVLong.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return this.tempVLong.value;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.offset + 4 > this.end) {
            this.warnBeyondEof();
        }
        float result = Float.intBitsToFloat(LazyBinaryUtils.byteArrayToInt(this.bytes, this.offset));
        this.offset += 4;
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return result;
    }

    @Override
    public double readDouble() throws IOException {
        if (this.offset + 8 > this.end) {
            this.warnBeyondEof();
        }
        double result = Double.longBitsToDouble(LazyBinaryUtils.byteArrayToLong(this.bytes, this.offset));
        this.offset += 8;
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return result;
    }

    @Override
    public DeserializeRead.ReadStringResults createReadStringResults() {
        return new LazyBinaryReadStringResults();
    }

    @Override
    public void readString(DeserializeRead.ReadStringResults readStringResults) throws IOException {
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        int saveStart = this.offset;
        int length = this.tempVInt.value;
        this.offset += length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        readStringResults.bytes = this.bytes;
        readStringResults.start = saveStart;
        readStringResults.length = length;
    }

    @Override
    public DeserializeRead.ReadHiveCharResults createReadHiveCharResults() {
        return new LazyBinaryReadHiveCharResults();
    }

    @Override
    public void readHiveChar(DeserializeRead.ReadHiveCharResults readHiveCharResults) throws IOException {
        LazyBinaryReadHiveCharResults lazyBinaryReadHiveCharResults = (LazyBinaryReadHiveCharResults)readHiveCharResults;
        if (!lazyBinaryReadHiveCharResults.isInit()) {
            lazyBinaryReadHiveCharResults.init((CharTypeInfo)this.primitiveTypeInfos[this.fieldIndex]);
        }
        if (lazyBinaryReadHiveCharResults.readStringResults == null) {
            lazyBinaryReadHiveCharResults.readStringResults = new LazyBinaryReadStringResults();
        }
        LazyBinaryReadStringResults readStringResults = lazyBinaryReadHiveCharResults.readStringResults;
        this.readString(readStringResults);
        HiveCharWritable hiveCharWritable = lazyBinaryReadHiveCharResults.getHiveCharWritable();
        hiveCharWritable.getTextValue().set(readStringResults.bytes, readStringResults.start, readStringResults.length);
        hiveCharWritable.enforceMaxLength(lazyBinaryReadHiveCharResults.getMaxLength());
        readHiveCharResults.bytes = hiveCharWritable.getTextValue().getBytes();
        readHiveCharResults.start = 0;
        readHiveCharResults.length = hiveCharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadHiveVarcharResults createReadHiveVarcharResults() {
        return new LazyBinaryReadHiveVarcharResults();
    }

    @Override
    public void readHiveVarchar(DeserializeRead.ReadHiveVarcharResults readHiveVarcharResults) throws IOException {
        LazyBinaryReadHiveVarcharResults lazyBinaryReadHiveVarcharResults = (LazyBinaryReadHiveVarcharResults)readHiveVarcharResults;
        if (!lazyBinaryReadHiveVarcharResults.isInit()) {
            lazyBinaryReadHiveVarcharResults.init((VarcharTypeInfo)this.primitiveTypeInfos[this.fieldIndex]);
        }
        if (lazyBinaryReadHiveVarcharResults.readStringResults == null) {
            lazyBinaryReadHiveVarcharResults.readStringResults = new LazyBinaryReadStringResults();
        }
        LazyBinaryReadStringResults readStringResults = lazyBinaryReadHiveVarcharResults.readStringResults;
        this.readString(readStringResults);
        HiveVarcharWritable hiveVarcharWritable = lazyBinaryReadHiveVarcharResults.getHiveVarcharWritable();
        hiveVarcharWritable.getTextValue().set(readStringResults.bytes, readStringResults.start, readStringResults.length);
        hiveVarcharWritable.enforceMaxLength(lazyBinaryReadHiveVarcharResults.getMaxLength());
        readHiveVarcharResults.bytes = hiveVarcharWritable.getTextValue().getBytes();
        readHiveVarcharResults.start = 0;
        readHiveVarcharResults.length = hiveVarcharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadBinaryResults createReadBinaryResults() {
        return new LazyBinaryReadBinaryResults();
    }

    @Override
    public void readBinary(DeserializeRead.ReadBinaryResults readBinaryResults) throws IOException {
        LazyBinaryReadBinaryResults lazyBinaryReadBinaryResults = (LazyBinaryReadBinaryResults)readBinaryResults;
        if (lazyBinaryReadBinaryResults.readStringResults == null) {
            lazyBinaryReadBinaryResults.readStringResults = new LazyBinaryReadStringResults();
        }
        LazyBinaryReadStringResults readStringResults = lazyBinaryReadBinaryResults.readStringResults;
        this.readString(readStringResults);
        readBinaryResults.bytes = readStringResults.bytes;
        readBinaryResults.start = readStringResults.start;
        readBinaryResults.length = readStringResults.length;
    }

    @Override
    public DeserializeRead.ReadDateResults createReadDateResults() {
        return new LazyBinaryReadDateResults();
    }

    @Override
    public void readDate(DeserializeRead.ReadDateResults readDateResults) throws IOException {
        LazyBinaryReadDateResults lazyBinaryReadDateResults = (LazyBinaryReadDateResults)readDateResults;
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        DateWritable dateWritable = lazyBinaryReadDateResults.getDateWritable();
        dateWritable.set(this.tempVInt.value);
    }

    @Override
    public DeserializeRead.ReadIntervalYearMonthResults createReadIntervalYearMonthResults() {
        return new LazyBinaryReadIntervalYearMonthResults();
    }

    @Override
    public void readIntervalYearMonth(DeserializeRead.ReadIntervalYearMonthResults readIntervalYearMonthResults) throws IOException {
        LazyBinaryReadIntervalYearMonthResults lazyBinaryReadIntervalYearMonthResults = (LazyBinaryReadIntervalYearMonthResults)readIntervalYearMonthResults;
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable = lazyBinaryReadIntervalYearMonthResults.getHiveIntervalYearMonthWritable();
        hiveIntervalYearMonthWritable.set(this.tempVInt.value);
    }

    @Override
    public DeserializeRead.ReadIntervalDayTimeResults createReadIntervalDayTimeResults() {
        return new LazyBinaryReadIntervalDayTimeResults();
    }

    @Override
    public void readIntervalDayTime(DeserializeRead.ReadIntervalDayTimeResults readIntervalDayTimeResults) throws IOException {
        LazyBinaryReadIntervalDayTimeResults lazyBinaryReadIntervalDayTimeResults = (LazyBinaryReadIntervalDayTimeResults)readIntervalDayTimeResults;
        LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
        this.offset += this.tempVLong.length;
        if (this.offset >= this.end) {
            this.warnBeyondEof();
        }
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable = lazyBinaryReadIntervalDayTimeResults.getHiveIntervalDayTimeWritable();
        hiveIntervalDayTimeWritable.set(this.tempVLong.value, this.tempVInt.value);
    }

    @Override
    public DeserializeRead.ReadTimestampResults createReadTimestampResults() {
        return new LazyBinaryReadTimestampResults();
    }

    @Override
    public void readTimestamp(DeserializeRead.ReadTimestampResults readTimestampResults) throws IOException {
        LazyBinaryReadTimestampResults lazyBinaryReadTimestampResults = (LazyBinaryReadTimestampResults)readTimestampResults;
        int length = TimestampWritable.getTotalLength(this.bytes, this.offset);
        int saveStart = this.offset;
        this.offset += length;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        TimestampWritable timestampWritable = lazyBinaryReadTimestampResults.getTimestampWritable();
        timestampWritable.set(this.bytes, saveStart);
    }

    @Override
    public DeserializeRead.ReadDecimalResults createReadDecimalResults() {
        return new LazyBinaryReadDecimalResults();
    }

    @Override
    public void readHiveDecimal(DeserializeRead.ReadDecimalResults readDecimalResults) throws IOException {
        LazyBinaryReadDecimalResults lazyBinaryReadDecimalResults = (LazyBinaryReadDecimalResults)readDecimalResults;
        if (!lazyBinaryReadDecimalResults.isInit()) {
            lazyBinaryReadDecimalResults.init(this.saveDecimalTypeInfo);
        }
        lazyBinaryReadDecimalResults.hiveDecimal = this.saveDecimal;
        this.saveDecimal = null;
        this.saveDecimalTypeInfo = null;
    }

    private boolean earlyReadHiveDecimal() throws EOFException {
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        int saveStart = this.offset;
        this.offset += this.tempVInt.length;
        if (this.offset >= this.end) {
            this.warnBeyondEof();
        }
        LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
        this.offset += this.tempVInt.length;
        if (this.offset >= this.end) {
            this.warnBeyondEof();
        }
        this.offset += this.tempVInt.value;
        if (this.offset > this.end) {
            this.warnBeyondEof();
        }
        int length = this.offset - saveStart;
        if (this.tempHiveDecimalWritable == null) {
            this.tempHiveDecimalWritable = new HiveDecimalWritable();
        }
        this.tempHiveDecimalWritable.setFromBytes(this.bytes, saveStart, length);
        this.saveDecimalTypeInfo = (DecimalTypeInfo)this.primitiveTypeInfos[this.fieldIndex];
        int precision = this.saveDecimalTypeInfo.getPrecision();
        int scale = this.saveDecimalTypeInfo.getScale();
        this.saveDecimal = this.tempHiveDecimalWritable.getHiveDecimal(precision, scale);
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return this.saveDecimal == null;
    }

    private static class LazyBinaryReadDecimalResults
    extends DeserializeRead.ReadDecimalResults {
        public HiveDecimal hiveDecimal;

        private LazyBinaryReadDecimalResults() {
        }

        @Override
        public void init(DecimalTypeInfo decimalTypeInfo) {
            super.init(decimalTypeInfo);
        }

        @Override
        public HiveDecimal getHiveDecimal() {
            return this.hiveDecimal;
        }
    }

    private static class LazyBinaryReadTimestampResults
    extends DeserializeRead.ReadTimestampResults {
        public TimestampWritable getTimestampWritable() {
            return this.timestampWritable;
        }
    }

    private static class LazyBinaryReadIntervalDayTimeResults
    extends DeserializeRead.ReadIntervalDayTimeResults {
        public HiveIntervalDayTimeWritable getHiveIntervalDayTimeWritable() {
            return this.hiveIntervalDayTimeWritable;
        }
    }

    private static class LazyBinaryReadIntervalYearMonthResults
    extends DeserializeRead.ReadIntervalYearMonthResults {
        public HiveIntervalYearMonthWritable getHiveIntervalYearMonthWritable() {
            return this.hiveIntervalYearMonthWritable;
        }
    }

    private static class LazyBinaryReadDateResults
    extends DeserializeRead.ReadDateResults {
        public DateWritable getDateWritable() {
            return this.dateWritable;
        }
    }

    private class LazyBinaryReadBinaryResults
    extends DeserializeRead.ReadBinaryResults {
        public LazyBinaryReadStringResults readStringResults;
    }

    private static class LazyBinaryReadHiveVarcharResults
    extends DeserializeRead.ReadHiveVarcharResults {
        public LazyBinaryReadStringResults readStringResults;

        public HiveVarcharWritable getHiveVarcharWritable() {
            return this.hiveVarcharWritable;
        }
    }

    private static class LazyBinaryReadHiveCharResults
    extends DeserializeRead.ReadHiveCharResults {
        public LazyBinaryReadStringResults readStringResults;

        public HiveCharWritable getHiveCharWritable() {
            return this.hiveCharWritable;
        }
    }

    private class LazyBinaryReadStringResults
    extends DeserializeRead.ReadStringResults {
    }
}

