/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.action.hadoop.SequenceFileWriterFactory;

public class HdfsOperations {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final SequenceFileWriterFactory seqFileWriterFactory;

    public HdfsOperations(SequenceFileWriterFactory seqFileWriterFactory) {
        this.seqFileWriterFactory = (SequenceFileWriterFactory)Preconditions.checkNotNull((Object)seqFileWriterFactory, (Object)"seqFileWriterFactory should not be null");
    }

    public void uploadActionDataToHDFS(Configuration launcherJobConf, Path actionDir, Map<String, String> actionData) throws IOException, InterruptedException {
        block14: {
            Path finalPath = new Path(actionDir, "action-data.seq");
            System.out.println("Oozie Launcher, uploading action data to HDFS sequence file: " + finalPath.toUri());
            try (SequenceFile.Writer wr = this.seqFileWriterFactory.createSequenceFileWriter(launcherJobConf, finalPath, Text.class, Text.class);){
                if (wr != null) {
                    for (Map.Entry<String, String> entry : actionData.entrySet()) {
                        wr.append((Writable)new Text(entry.getKey()), (Writable)new Text(entry.getValue()));
                    }
                    break block14;
                }
                throw new IOException("SequenceFile.Writer is null for " + finalPath);
            }
        }
    }

    public boolean fileExists(Path path, Configuration launcherJobConf) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)launcherJobConf);
        return fs.exists(path);
    }

    public void writeStringToFile(Path path, Configuration conf, String contents) throws IOException, InterruptedException {
        try (FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path), DEFAULT_CHARSET);){
            writer.write(contents);
        }
    }

    public String readFileContents(Path path, Configuration conf) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        try (FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
             FSDataInputStream is = fs.open(path);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, DEFAULT_CHARSET));){
            String contents;
            while ((contents = reader.readLine()) != null) {
                sb.append(contents);
            }
        }
        return sb.toString();
    }
}

