/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherMain;

public class JavaMain
extends LauncherMain {
    public static final String JAVA_MAIN_CLASS = "oozie.action.java.main";

    public static void main(String[] args) throws Exception {
        JavaMain.run(JavaMain.class, args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        Configuration actionConf = JavaMain.loadActionConf();
        JavaMain.setYarnTag(actionConf);
        JavaMain.setApplicationTags(actionConf, "tez.application.tags");
        JavaMain.setApplicationTags(actionConf, "spark.yarn.tags");
        LauncherMain.killChildYarnJobs(actionConf);
        Class klass = actionConf.getClass(JAVA_MAIN_CLASS, Object.class);
        System.out.println("Java action main class        : " + klass.getName());
        this.printArgs("Java action arguments         :", args);
        System.out.println();
        Method mainMethod = klass.getMethod("main", String[].class);
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException ex) {
            throw new JavaMainException(ex.getCause());
        }
    }

    static class JavaMainException
    extends Exception {
        public JavaMainException(Throwable t) {
            super(t);
        }
    }
}

