/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.oozie.action.hadoop.AMRMCallBackHandler;
import org.apache.oozie.action.hadoop.AMRMClientAsyncFactory;
import org.apache.oozie.action.hadoop.ErrorHolder;
import org.apache.oozie.action.hadoop.HdfsOperations;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.LauncherAMCallbackNotifier;
import org.apache.oozie.action.hadoop.LauncherAMCallbackNotifierFactory;
import org.apache.oozie.action.hadoop.LauncherAMUtils;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LocalFsOperations;
import org.apache.oozie.action.hadoop.PrepareActionsHandler;
import org.apache.oozie.action.hadoop.SequenceFileWriterFactory;

public class LauncherAM {
    public static final String OOZIE_ACTION_CONF_XML = "oozie.action.conf.xml";
    public static final String OOZIE_LAUNCHER_JOB_ID = "oozie.launcher.job.id";
    public static final String OOZIE_LAUNCHER_VCORES_PROPERTY = "oozie.launcher.vcores";
    public static final String OOZIE_LAUNCHER_MEMORY_MB_PROPERTY = "oozie.launcher.memory.mb";
    public static final String OOZIE_LAUNCHER_PRIORITY_PROPERTY = "oozie.launcher.priority";
    public static final String OOZIE_LAUNCHER_QUEUE_PROPERTY = "oozie.launcher.queue";
    public static final String OOZIE_LAUNCHER_JAVAOPTS_PROPERTY = "oozie.launcher.javaopts";
    public static final String OOZIE_LAUNCHER_ENV_PROPERTY = "oozie.launcher.env";
    public static final String OOZIE_LAUNCHER_SHARELIB_PROPERTY = "oozie.launcher.sharelib";
    public static final String OOZIE_LAUNCHER_LOG_LEVEL_PROPERTY = "oozie.launcher.log.level";
    public static final String OOZIE_LAUNCHER_MAX_ATTEMPTS = "oozie.launcher.max.attempts";
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String OOZIE_ACTION_ID = "oozie.action.id";
    public static final String OOZIE_JOB_ID = "oozie.job.id";
    public static final String ACTION_PREFIX = "oozie.action.";
    static final String OOZIE_ACTION_RECOVERY_ID = "oozie.action.recovery.id";
    public static final String CONF_OOZIE_ACTION_MAX_OUTPUT_DATA = "oozie.action.max.output.data";
    public static final String CONF_OOZIE_ACTION_MAIN_ARG_PREFIX = "oozie.action.main.arg.";
    public static final String CONF_OOZIE_ACTION_MAIN_ARG_COUNT = "oozie.action.main.arg.count";
    public static final String CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE = "oozie.external.stats.max.size";
    public static final String OOZIE_ACTION_DIR_PATH = "oozie.action.dir.path";
    public static final String ACTION_PREPARE_XML = "oozie.action.prepare.xml";
    public static final String ACTION_DATA_SEQUENCE_FILE = "action-data.seq";
    public static final String ACTION_DATA_EXTERNAL_CHILD_IDS = "externalChildIDs";
    public static final String ACTION_DATA_OUTPUT_PROPS = "output.properties";
    public static final String ACTION_DATA_STATS = "stats.properties";
    public static final String ACTION_DATA_NEW_ID = "newId";
    public static final String ACTION_DATA_ERROR_PROPS = "error.properties";
    public static final String CONF_OOZIE_ACTION_MAIN_CLASS = "oozie.launcher.action.main.class";
    public static final String LAUNCHER_JOB_CONF_XML = "launcher.xml";
    public static final String ACTION_CONF_XML = "action.xml";
    public static final String ACTION_DATA_FINAL_STATUS = "final.status";
    public static final String OOZIE_SUBMITTER_USER = "oozie.submitter.user";
    private final AMRMClientAsyncFactory amrmClientAsyncFactory;
    private final HdfsOperations hdfsOperations;
    private final LocalFsOperations localFsOperations;
    private final PrepareActionsHandler prepareHandler;
    private final LauncherAMCallbackNotifierFactory callbackNotifierFactory;
    private final LauncherSecurityManager launcherSecurityManager;
    private final ContainerId containerId;
    private final Configuration launcherConf;
    private final AMRMCallBackHandler amrmCallBackHandler;
    private AMRMClientAsync<?> amRmClientAsync;
    private Path actionDir;
    private Map<String, String> actionData = new HashMap<String, String>();

    public LauncherAM(AMRMClientAsyncFactory amrmClientAsyncFactory, AMRMCallBackHandler amrmCallBackHandler, HdfsOperations hdfsOperations, LocalFsOperations localFsOperations, PrepareActionsHandler prepareHandler, LauncherAMCallbackNotifierFactory callbackNotifierFactory, LauncherSecurityManager launcherSecurityManager, String containerId, Configuration launcherConf) {
        this.amrmClientAsyncFactory = (AMRMClientAsyncFactory)Preconditions.checkNotNull((Object)amrmClientAsyncFactory, (Object)"amrmClientAsyncFactory should not be null");
        this.amrmCallBackHandler = (AMRMCallBackHandler)Preconditions.checkNotNull((Object)amrmCallBackHandler, (Object)"amrmCallBackHandler should not be null");
        this.hdfsOperations = (HdfsOperations)Preconditions.checkNotNull((Object)hdfsOperations, (Object)"hdfsOperations should not be null");
        this.localFsOperations = (LocalFsOperations)Preconditions.checkNotNull((Object)localFsOperations, (Object)"localFsOperations should not be null");
        this.prepareHandler = (PrepareActionsHandler)Preconditions.checkNotNull((Object)prepareHandler, (Object)"prepareHandler should not be null");
        this.callbackNotifierFactory = (LauncherAMCallbackNotifierFactory)Preconditions.checkNotNull((Object)callbackNotifierFactory, (Object)"callbackNotifierFactory should not be null");
        this.launcherSecurityManager = (LauncherSecurityManager)Preconditions.checkNotNull((Object)launcherSecurityManager, (Object)"launcherSecurityManager should not be null");
        this.containerId = ContainerId.fromString((String)((String)Preconditions.checkNotNull((Object)containerId, (Object)"containerId should not be null")));
        this.launcherConf = (Configuration)Preconditions.checkNotNull((Object)launcherConf, (Object)"launcherConf should not be null");
    }

    public static void main(String[] args) throws Exception {
        LocalFsOperations localFsOperations = new LocalFsOperations();
        final Configuration launcherConf = LauncherAM.readLauncherConfiguration(localFsOperations);
        UserGroupInformation.setConfiguration((Configuration)launcherConf);
        UserGroupInformation ugi = LauncherAM.getUserGroupInformation(launcherConf, new Text[0]);
        LauncherAM.printTokens("Executing Oozie Launcher with tokens:", ugi.getTokens());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                LauncherAM launcher = new LauncherAM(new AMRMClientAsyncFactory(), new AMRMCallBackHandler(), new HdfsOperations(new SequenceFileWriterFactory()), new LocalFsOperations(), new PrepareActionsHandler(), new LauncherAMCallbackNotifierFactory(), new LauncherSecurityManager(), System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name()), launcherConf);
                launcher.run();
                return null;
            }
        });
    }

    private static void printTokens(String message, Collection<Token<? extends TokenIdentifier>> tokens) {
        System.out.println(message);
        for (Token<? extends TokenIdentifier> token : tokens) {
            System.out.println(token);
        }
    }

    private static UserGroupInformation getUserGroupInformation(Configuration launcherConf, Text ... kindToFilter) throws IOException {
        String submitterUser = launcherConf.get(OOZIE_SUBMITTER_USER);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        LauncherAM.filterTokensByKind(credentials, kindToFilter);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)submitterUser);
        ugi.addCredentials(credentials);
        return ugi;
    }

    private static void filterTokensByKind(Credentials credentials, Text[] kindToFilter) throws IOException {
        Iterator iterator = credentials.getAllTokens().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            for (int i = 0; i < kindToFilter.length; ++i) {
                if (!kindToFilter[i].equals((Object)token.getKind())) continue;
                System.out.println("Removing token from the Ugi: " + kindToFilter[i]);
                iterator.remove();
            }
        }
    }

    static Configuration readLauncherConfiguration(LocalFsOperations localFsOperations) {
        Configuration launcherConf = null;
        try {
            launcherConf = localFsOperations.readLauncherConf();
            System.out.println("Launcher AM configuration loaded");
        }
        catch (Exception ex) {
            System.err.println("Could not load the Launcher AM configuration file");
            ex.printStackTrace();
            throw ex;
        }
        return launcherConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws Exception {
        boolean backgroundAction;
        OozieActionResult actionResult;
        ErrorHolder errorHolder;
        block30: {
            errorHolder = new ErrorHolder();
            actionResult = OozieActionResult.FAILED;
            backgroundAction = false;
            try {
                this.actionDir = new Path(this.launcherConf.get(OOZIE_ACTION_DIR_PATH));
                this.registerWithRM(this.amrmCallBackHandler);
                UserGroupInformation ugi = LauncherAM.getUserGroupInformation(this.launcherConf, AMRMTokenIdentifier.KIND_NAME);
                LauncherAM.printTokens("Executing Action Main with tokens:", ugi.getTokens());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        LauncherAM.this.executePrepare(errorHolder);
                        LauncherAM.this.printDebugInfo();
                        LauncherAM.this.setupMainConfiguration();
                        LauncherAM.this.runActionMain(errorHolder);
                        return null;
                    }
                });
                if (errorHolder.isPopulated()) break block30;
                this.handleActionData();
                if (this.actionData.get(ACTION_DATA_OUTPUT_PROPS) != null) {
                    System.out.println();
                    System.out.println("Oozie Launcher, capturing output data:");
                    System.out.println("=======================");
                    System.out.println(this.actionData.get(ACTION_DATA_OUTPUT_PROPS));
                    System.out.println();
                    System.out.println("=======================");
                    System.out.println();
                }
                if (this.actionData.get(ACTION_DATA_NEW_ID) != null) {
                    System.out.println();
                    System.out.println("Oozie Launcher, propagating new Hadoop job id to Oozie");
                    System.out.println("=======================");
                    System.out.println(this.actionData.get(ACTION_DATA_NEW_ID));
                    System.out.println("=======================");
                    System.out.println();
                    backgroundAction = true;
                }
            }
            catch (Exception e) {
                try {
                    System.out.println("Launcher AM execution failed");
                    System.err.println("Launcher AM execution failed");
                    e.printStackTrace(System.out);
                    e.printStackTrace(System.err);
                    if (errorHolder.isPopulated()) throw e;
                    errorHolder.setErrorCause(e);
                    errorHolder.setErrorMessage(e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        ErrorHolder callbackErrorHolder = this.amrmCallBackHandler.getError();
                        if (!errorHolder.isPopulated()) {
                            OozieActionResult oozieActionResult = actionResult = backgroundAction ? OozieActionResult.RUNNING : OozieActionResult.SUCCEEDED;
                        }
                        if (errorHolder.isPopulated()) {
                            this.updateActionDataWithFailure(errorHolder, this.actionData);
                        } else if (callbackErrorHolder != null) {
                            actionResult = OozieActionResult.FAILED;
                            this.updateActionDataWithFailure(callbackErrorHolder, this.actionData);
                        }
                        this.actionData.put(ACTION_DATA_FINAL_STATUS, actionResult.toString());
                        this.hdfsOperations.uploadActionDataToHDFS(this.launcherConf, this.actionDir, this.actionData);
                        throw throwable;
                    }
                    finally {
                        try {
                            this.unregisterWithRM(actionResult, errorHolder.getErrorMessage());
                        }
                        finally {
                            LauncherAMCallbackNotifier cn = this.callbackNotifierFactory.createCallbackNotifier(this.launcherConf);
                            cn.notifyURL(actionResult);
                        }
                    }
                }
            }
        }
        try {
            ErrorHolder callbackErrorHolder = this.amrmCallBackHandler.getError();
            if (!errorHolder.isPopulated()) {
                OozieActionResult oozieActionResult = actionResult = backgroundAction ? OozieActionResult.RUNNING : OozieActionResult.SUCCEEDED;
            }
            if (errorHolder.isPopulated()) {
                this.updateActionDataWithFailure(errorHolder, this.actionData);
            } else if (callbackErrorHolder != null) {
                actionResult = OozieActionResult.FAILED;
                this.updateActionDataWithFailure(callbackErrorHolder, this.actionData);
            }
            this.actionData.put(ACTION_DATA_FINAL_STATUS, actionResult.toString());
            this.hdfsOperations.uploadActionDataToHDFS(this.launcherConf, this.actionDir, this.actionData);
            return;
        }
        finally {
            try {
                this.unregisterWithRM(actionResult, errorHolder.getErrorMessage());
            }
            finally {
                LauncherAMCallbackNotifier cn = this.callbackNotifierFactory.createCallbackNotifier(this.launcherConf);
                cn.notifyURL(actionResult);
            }
        }
    }

    @VisibleForTesting
    Map<String, String> getActionData() {
        return this.actionData;
    }

    private void printDebugInfo() throws IOException {
        this.localFsOperations.printContentsOfDir(new File("."));
        System.out.println();
        System.out.println("Oozie Launcher Application Master configuration");
        System.out.println("===============================================");
        System.out.println("Workflow job id   : " + this.launcherConf.get(OOZIE_JOB_ID));
        System.out.println("Workflow action id: " + this.launcherConf.get(OOZIE_ACTION_ID));
        System.out.println();
        System.out.println("Classpath         :");
        System.out.println("------------------------");
        StringTokenizer st = new StringTokenizer(System.getProperty(JAVA_CLASS_PATH), ":");
        while (st.hasMoreTokens()) {
            System.out.println("  " + st.nextToken());
        }
        System.out.println("------------------------");
        System.out.println();
        String mainClass = this.launcherConf.get(CONF_OOZIE_ACTION_MAIN_CLASS);
        System.out.println("Main class        : " + mainClass);
        System.out.println();
        System.out.println("Maximum output    : " + this.launcherConf.getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048));
        System.out.println();
        System.out.println();
        System.out.println("Java System Properties:");
        System.out.println("------------------------");
        System.getProperties().store(System.out, "");
        System.out.println("------------------------");
        System.out.println();
        System.out.println("Environment variables");
        Map<String, String> env = System.getenv();
        System.out.println("------------------------");
        for (Map.Entry<String, String> entry : env.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
        System.out.println("------------------------");
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Main class now >>>");
        System.out.println();
    }

    private void registerWithRM(AMRMCallBackHandler amrmCallBackHandler) throws IOException, YarnException {
        this.amRmClientAsync = this.amrmClientAsyncFactory.createAMRMClientAsync(60000, amrmCallBackHandler);
        this.amRmClientAsync.init(new Configuration(this.launcherConf));
        this.amRmClientAsync.start();
        this.amRmClientAsync.registerApplicationMaster("", 0, "");
    }

    private void unregisterWithRM(OozieActionResult actionResult, String message) throws YarnException, IOException {
        if (this.amRmClientAsync != null) {
            System.out.println("Stopping AM");
            try {
                message = message == null ? "" : message;
                this.amRmClientAsync.unregisterApplicationMaster(actionResult.getYarnStatus(), message, "");
            }
            catch (Exception ex) {
                System.out.println("Error un-registering AM client");
                throw ex;
            }
            finally {
                this.amRmClientAsync.stop();
            }
        }
    }

    private void executePrepare(ErrorHolder errorHolder) throws Exception {
        try {
            System.out.println("\nStarting the execution of prepare actions");
            String prepareXML = this.launcherConf.get(ACTION_PREPARE_XML);
            if (prepareXML != null) {
                if (prepareXML.length() != 0) {
                    Configuration actionConf = new Configuration(this.launcherConf);
                    actionConf.addResource(ACTION_CONF_XML);
                    this.prepareHandler.prepareAction(prepareXML, actionConf);
                } else {
                    System.out.println("There are no prepare actions to execute.");
                }
            }
            System.out.println("Completed the execution of prepare actions successfully");
        }
        catch (Exception ex) {
            errorHolder.setErrorMessage("Prepare execution in the Launcher AM has failed");
            errorHolder.setErrorCause(ex);
            throw ex;
        }
    }

    private void setupMainConfiguration() throws IOException {
        System.setProperty(OOZIE_LAUNCHER_JOB_ID, this.launcherConf.get(OOZIE_JOB_ID));
        System.setProperty(OOZIE_JOB_ID, this.launcherConf.get(OOZIE_JOB_ID));
        System.setProperty(OOZIE_ACTION_ID, this.launcherConf.get(OOZIE_ACTION_ID));
        System.setProperty(OOZIE_ACTION_CONF_XML, new File(ACTION_CONF_XML).getAbsolutePath());
        System.setProperty("oozie.action.externalChildIDs", new File(ACTION_DATA_EXTERNAL_CHILD_IDS).getAbsolutePath());
        System.setProperty("oozie.action.stats.properties", new File(ACTION_DATA_STATS).getAbsolutePath());
        System.setProperty("oozie.action.newId", new File(ACTION_DATA_NEW_ID).getAbsolutePath());
        System.setProperty("oozie.action.output.properties", new File(ACTION_DATA_OUTPUT_PROPS).getAbsolutePath());
        System.setProperty("oozie.action.error.properties", new File(ACTION_DATA_ERROR_PROPS).getAbsolutePath());
        System.setProperty("oozie.job.launch.time", String.valueOf(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runActionMain(ErrorHolder eHolder) throws Exception {
        boolean actionMainExecutedProperly = false;
        try {
            String[] mainArgs = this.getMainArguments(this.launcherConf);
            this.setRecoveryId();
            Class klass = this.launcherConf.getClass(CONF_OOZIE_ACTION_MAIN_CLASS, null);
            Preconditions.checkNotNull((Object)klass, (Object)"Launcher class should not be null");
            System.out.println("Launcher class: " + klass.toString());
            Method mainMethod = klass.getMethod("main", String[].class);
            this.launcherSecurityManager.enable();
            mainMethod.invoke(null, new Object[]{mainArgs});
            System.out.println();
            System.out.println("<<< Invocation of Main class completed <<<");
            System.out.println();
            actionMainExecutedProperly = true;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace(System.out);
            Throwable cause = ex.getCause();
            if (JavaMain.JavaMainException.class.isInstance(cause)) {
                cause = cause.getCause();
            }
            if (LauncherMainException.class.isInstance(cause)) {
                int errorCode = ((LauncherMainException)ex.getCause()).getErrorCode();
                String mainClass = this.launcherConf.get(CONF_OOZIE_ACTION_MAIN_CLASS);
                eHolder.setErrorMessage("Main Class [" + mainClass + "], exit code [" + errorCode + "]");
                eHolder.setErrorCode(errorCode);
            } else if (SecurityException.class.isInstance(cause)) {
                if (this.launcherSecurityManager.getExitInvoked()) {
                    int exitCode = this.launcherSecurityManager.getExitCode();
                    System.out.println("Intercepting System.exit(" + exitCode + ")");
                    if (exitCode != 0) {
                        eHolder.setErrorCode(exitCode);
                        String mainClass = this.launcherConf.get(CONF_OOZIE_ACTION_MAIN_CLASS);
                        eHolder.setErrorMessage("Main Class [" + mainClass + "], exit code [" + eHolder.getErrorCode() + "]");
                    } else {
                        actionMainExecutedProperly = true;
                    }
                } else {
                    eHolder.setErrorCode(0);
                    eHolder.setErrorCause(cause);
                    eHolder.setErrorMessage(cause.getMessage());
                }
            } else {
                eHolder.setErrorMessage(cause.getMessage());
                eHolder.setErrorCause(cause);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            eHolder.setErrorMessage(t.getMessage());
            eHolder.setErrorCause(t);
        }
        finally {
            this.launcherSecurityManager.disable();
        }
        return actionMainExecutedProperly;
    }

    private void setRecoveryId() throws LauncherException {
        try {
            ApplicationId applicationId = this.containerId.getApplicationAttemptId().getApplicationId();
            String applicationIdStr = applicationId.toString();
            String recoveryId = (String)Preconditions.checkNotNull((Object)this.launcherConf.get(OOZIE_ACTION_RECOVERY_ID), (Object)"RecoveryID should not be null");
            Path path = new Path(this.actionDir, recoveryId);
            if (!this.hdfsOperations.fileExists(path, this.launcherConf)) {
                this.hdfsOperations.writeStringToFile(path, this.launcherConf, applicationIdStr);
            } else {
                String id = this.hdfsOperations.readFileContents(path, this.launcherConf);
                if (id == null || id.isEmpty()) {
                    this.hdfsOperations.writeStringToFile(path, this.launcherConf, applicationIdStr);
                } else if (!applicationIdStr.equals(id)) {
                    throw new LauncherException(MessageFormat.format("YARN Id mismatch, action file [{0}] declares Id [{1}] current Id [{2}]", path, id, applicationIdStr));
                }
            }
        }
        catch (IOException | InterruptedException | RuntimeException ex) {
            throw new LauncherException("IO error", ex);
        }
    }

    private void handleActionData() throws IOException {
        this.processActionData("oozie.action.externalChildIDs", null, ACTION_DATA_EXTERNAL_CHILD_IDS, -1);
        this.processActionData("oozie.action.stats.properties", CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE, ACTION_DATA_STATS, Integer.MAX_VALUE);
        this.processActionData("oozie.action.output.properties", CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, ACTION_DATA_OUTPUT_PROPS, 2048);
        this.processActionData("oozie.action.newId", null, ACTION_DATA_NEW_ID, -1);
    }

    private void processActionData(String propertyName, String maxSizePropertyName, String actionDataPropertyName, int maxSizeDefault) throws IOException {
        File actionDataFile;
        String propValue = System.getProperty(propertyName);
        int maxSize = maxSizeDefault;
        if (maxSizePropertyName != null) {
            maxSize = this.launcherConf.getInt(maxSizePropertyName, maxSizeDefault);
        }
        if (propValue != null && this.localFsOperations.fileExists(actionDataFile = new File(propValue))) {
            this.actionData.put(actionDataPropertyName, this.localFsOperations.getLocalFileContentAsString(actionDataFile, actionDataPropertyName, maxSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionDataWithFailure(ErrorHolder eHolder, Map<String, String> actionData) {
        StringWriter sw;
        if (eHolder.getErrorCause() != null && eHolder.getErrorCause().getMessage() != null) {
            if (Objects.equal((Object)eHolder.getErrorMessage(), (Object)eHolder.getErrorCause().getMessage())) {
                eHolder.setErrorMessage(eHolder.getErrorMessage());
            } else {
                eHolder.setErrorMessage(eHolder.getErrorMessage() + ", " + eHolder.getErrorCause().getMessage());
            }
        }
        Properties errorProps = new Properties();
        errorProps.setProperty("error.code", Integer.toString(eHolder.getErrorCode()));
        String errorMessage = eHolder.getErrorMessage() == null ? "<empty>" : eHolder.getErrorMessage();
        errorProps.setProperty("error.reason", errorMessage);
        if (eHolder.getErrorCause() != null) {
            if (eHolder.getErrorCause().getMessage() != null) {
                errorProps.setProperty("exception.message", eHolder.getErrorCause().getMessage());
            }
            sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            eHolder.getErrorCause().printStackTrace(pw);
            pw.close();
            errorProps.setProperty("exception.stacktrace", sw.toString());
        }
        sw = new StringWriter();
        try {
            File externalChildIDs;
            errorProps.store(sw, "");
            sw.close();
            actionData.put(ACTION_DATA_ERROR_PROPS, sw.toString());
            String externalChildIdsProp = System.getProperty("oozie.action.externalChildIDs");
            if (externalChildIdsProp != null && this.localFsOperations.fileExists(externalChildIDs = new File(externalChildIdsProp))) {
                actionData.put(ACTION_DATA_EXTERNAL_CHILD_IDS, this.localFsOperations.getLocalFileContentAsString(externalChildIDs, ACTION_DATA_EXTERNAL_CHILD_IDS, -1));
            }
        }
        catch (IOException ioe) {
            System.out.println("A problem occured trying to fail the launcher");
            ioe.printStackTrace();
        }
        finally {
            System.out.print("Failing Oozie Launcher, " + eHolder.getErrorMessage() + "\n");
            if (eHolder.getErrorCause() != null) {
                eHolder.getErrorCause().printStackTrace(System.out);
            }
        }
    }

    private String[] getMainArguments(Configuration conf) {
        return LauncherAMUtils.getMainArguments(conf);
    }

    public static enum OozieActionResult {
        SUCCEEDED(FinalApplicationStatus.SUCCEEDED),
        FAILED(FinalApplicationStatus.FAILED),
        RUNNING(FinalApplicationStatus.SUCCEEDED);

        private FinalApplicationStatus yarnStatus;

        private OozieActionResult(FinalApplicationStatus yarnStatus) {
            this.yarnStatus = yarnStatus;
        }

        public FinalApplicationStatus getYarnStatus() {
            return this.yarnStatus;
        }
    }

    public static class LauncherSecurityManager
    extends SecurityManager {
        private boolean exitInvoked = false;
        private int exitCode = 0;
        private SecurityManager originalSecurityManager = System.getSecurityManager();

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPermission(perm, context);
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPermission(perm);
            }
        }

        @Override
        public void checkExit(int status) throws SecurityException {
            this.exitInvoked = true;
            this.exitCode = status;
            throw new SecurityException("Intercepted System.exit(" + status + ")");
        }

        public boolean getExitInvoked() {
            return this.exitInvoked;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public void enable() {
            if (System.getSecurityManager() != this) {
                System.setSecurityManager(this);
            }
        }

        public void disable() {
            if (System.getSecurityManager() == this) {
                System.setSecurityManager(this.originalSecurityManager);
            }
        }

        public void reset() {
            this.exitInvoked = false;
            this.exitCode = 0;
        }
    }
}

