/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherAM;

public class LauncherAMCallbackNotifier {
    private static final String OOZIE_LAUNCHER_CALLBACK = "oozie.launcher.callback.";
    private static final int OOZIE_LAUNCHER_CALLBACK_RETRY_INTERVAL_MAX = 5000;
    public static final String OOZIE_LAUNCHER_CALLBACK_RETRY_ATTEMPTS = "oozie.launcher.callback.retry.attempts";
    public static final String OOZIE_LAUNCHER_CALLBACK_RETRY_INTERVAL = "oozie.launcher.callback.retry.interval";
    public static final String OOZIE_LAUNCHER_CALLBACK_MAX_ATTEMPTS = "oozie.launcher.callback.max.attempts";
    public static final String OOZIE_LAUNCHER_CALLBACK_TIMEOUT = "oozie.launcher.callback.timeout";
    public static final String OOZIE_LAUNCHER_CALLBACK_URL = "oozie.launcher.callback.url";
    public static final String OOZIE_LAUNCHER_CALLBACK_PROXY = "oozie.launcher.callback.proxy";
    public static final String OOZIE_LAUNCHER_CALLBACK_JOBSTATUS_TOKEN = "$jobStatus";
    protected String userUrl;
    protected String proxyConf;
    protected int numTries;
    protected int waitInterval;
    protected int timeout;
    protected URL urlToNotify;
    protected Proxy proxyToUse = Proxy.NO_PROXY;

    public LauncherAMCallbackNotifier(Configuration conf) {
        this.numTries = Math.min(conf.getInt(OOZIE_LAUNCHER_CALLBACK_RETRY_ATTEMPTS, 0) + 1, conf.getInt(OOZIE_LAUNCHER_CALLBACK_MAX_ATTEMPTS, 1));
        this.waitInterval = Math.min(conf.getInt(OOZIE_LAUNCHER_CALLBACK_RETRY_INTERVAL, 5000), 5000);
        this.waitInterval = this.waitInterval < 0 ? 5000 : this.waitInterval;
        this.timeout = conf.getInt(OOZIE_LAUNCHER_CALLBACK_TIMEOUT, 5000);
        this.userUrl = conf.get(OOZIE_LAUNCHER_CALLBACK_URL);
        this.proxyConf = conf.get(OOZIE_LAUNCHER_CALLBACK_PROXY);
        if (this.proxyConf != null && !this.proxyConf.equals("") && this.proxyConf.lastIndexOf(":") != -1) {
            int typeIndex = this.proxyConf.indexOf("@");
            Proxy.Type proxyType = Proxy.Type.HTTP;
            if (typeIndex != -1 && this.proxyConf.substring(0, typeIndex).compareToIgnoreCase("socks") == 0) {
                proxyType = Proxy.Type.SOCKS;
            }
            String hostname = this.proxyConf.substring(typeIndex + 1, this.proxyConf.lastIndexOf(":"));
            String portConf = this.proxyConf.substring(this.proxyConf.lastIndexOf(":") + 1);
            try {
                int port = Integer.parseInt(portConf);
                this.proxyToUse = new Proxy(proxyType, new InetSocketAddress(hostname, port));
                System.out.println("Callback notification using proxy type \"" + (Object)((Object)proxyType) + "\" hostname \"" + hostname + "\" and port \"" + port + "\"");
            }
            catch (NumberFormatException nfe) {
                System.err.println("Callback notification couldn't parse configured proxy's port " + portConf + ". Not going to use a proxy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyURLOnce() {
        boolean success = false;
        HttpURLConnection conn = null;
        try {
            System.out.println("Callback notification trying " + this.urlToNotify);
            conn = (HttpURLConnection)this.urlToNotify.openConnection(this.proxyToUse);
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.setAllowUserInteraction(false);
            if (conn.getResponseCode() != 200) {
                System.err.println("Callback notification to " + this.urlToNotify + " failed with code: " + conn.getResponseCode() + " and message \"" + conn.getResponseMessage() + "\"");
            } else {
                success = true;
                System.out.println("Callback notification to " + this.urlToNotify + " succeeded");
            }
        }
        catch (IOException ioe) {
            System.err.println("Callback notification to " + this.urlToNotify + " failed");
            ioe.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return success;
    }

    public void notifyURL(LauncherAM.OozieActionResult actionResult) throws InterruptedException {
        if (this.userUrl == null) {
            System.out.println("Callback notification URL not set, skipping.");
            return;
        }
        if (this.userUrl.contains(OOZIE_LAUNCHER_CALLBACK_JOBSTATUS_TOKEN)) {
            this.userUrl = this.userUrl.replace(OOZIE_LAUNCHER_CALLBACK_JOBSTATUS_TOKEN, actionResult.toString());
        }
        try {
            this.urlToNotify = new URL(this.userUrl);
        }
        catch (MalformedURLException mue) {
            System.err.println("Callback notification couldn't parse " + this.userUrl);
            mue.printStackTrace();
            return;
        }
        boolean success = false;
        while (this.numTries-- > 0 && !success) {
            System.out.println("Callback notification attempts left " + this.numTries);
            success = this.notifyURLOnce();
            if (success) continue;
            Thread.sleep(this.waitInterval);
        }
        if (!success) {
            System.err.println("Callback notification failed to notify : " + this.urlToNotify);
        } else {
            System.out.println("Callback notification succeeded");
        }
    }
}

