/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherException;

public class LauncherAMUtils {
    static final String CONF_OOZIE_ACTION_MAIN_CLASS = "oozie.launcher.action.main.class";
    static final String ACTION_PREFIX = "oozie.action.";
    public static final String CONF_OOZIE_ACTION_MAX_OUTPUT_DATA = "oozie.action.max.output.data";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_COUNT = "oozie.action.main.arg.count";
    static final String CONF_OOZIE_ACTION_MAIN_ARG_PREFIX = "oozie.action.main.arg.";
    static final String CONF_OOZIE_EXTERNAL_STATS_MAX_SIZE = "oozie.external.stats.max.size";
    static final String OOZIE_ACTION_CONFIG_CLASS = "oozie.action.config.class";
    static final String CONF_OOZIE_ACTION_FS_GLOB_MAX = "oozie.action.fs.glob.max";
    static final String CONF_OOZIE_NULL_ARGS_ALLOWED = "oozie.action.null.args.allowed";
    static final String COUNTER_GROUP = "oozie.launcher";
    static final String COUNTER_LAUNCHER_ERROR = "oozie.launcher.error";
    static final String OOZIE_JOB_ID = "oozie.job.id";
    static final String OOZIE_ACTION_ID = "oozie.action.id";
    static final String OOZIE_ACTION_RECOVERY_ID = "oozie.action.recovery.id";
    static final String OOZIE_ACTION_DIR_PATH = "oozie.action.dir.path";
    static final String ACTION_CONF_XML = "action.xml";
    static final String ACTION_PREPARE_XML = "oozie.action.prepare.xml";
    static final String ACTION_DATA_SEQUENCE_FILE = "action-data.seq";
    static final String ACTION_DATA_EXTERNAL_CHILD_IDS = "externalChildIDs";
    static final String ACTION_DATA_OUTPUT_PROPS = "output.properties";
    static final String ACTION_DATA_STATS = "stats.properties";
    static final String ACTION_DATA_NEW_ID = "newId";
    static final String ACTION_DATA_ERROR_PROPS = "error.properties";
    public static final String HADOOP2_WORKAROUND_DISTRIBUTED_CACHE = "oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache";
    public static final String PROPAGATION_CONF_XML = "propagation-conf.xml";
    public static final String ROOT_LOGGER_LEVEL = "rootlogger.log.level";

    public static String getLocalFileContentStr(File file, String type, int maxLen) throws LauncherException, IOException {
        int read;
        StringBuffer sb = new StringBuffer();
        FileReader reader = new FileReader(file);
        char[] buffer = new char[2048];
        int count = 0;
        while ((read = reader.read(buffer)) > -1) {
            if (maxLen > -1 && (count += read) > maxLen) {
                throw new LauncherException(type + " data exceeds its limit [" + maxLen + "]");
            }
            sb.append(buffer, 0, read);
        }
        reader.close();
        return sb.toString();
    }

    public static String[] getMainArguments(Configuration conf) {
        String[] retArray;
        String[] args = new String[conf.getInt(CONF_OOZIE_ACTION_MAIN_ARG_COUNT, 0)];
        if (conf.getBoolean(CONF_OOZIE_NULL_ARGS_ALLOWED, true)) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
            }
            retArray = args;
        } else {
            int pos = 0;
            for (int i = 0; i < args.length; ++i) {
                String arg = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
                if (Strings.isNullOrEmpty((String)arg)) continue;
                args[pos++] = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
            }
            retArray = new String[pos];
            System.arraycopy(args, 0, retArray, 0, pos);
        }
        return retArray;
    }
}

