/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.oozie.action.hadoop.PasswordMasker;

public abstract class LauncherMain {
    public static final String ACTION_PREFIX = "oozie.action.";
    public static final String EXTERNAL_CHILD_IDS = "oozie.action.externalChildIDs";
    public static final String EXTERNAL_ACTION_STATS = "oozie.action.stats.properties";
    public static final String EXTERNAL_STATS_WRITE = "oozie.action.external.stats.write";
    public static final String OUTPUT_PROPERTIES = "oozie.action.output.properties";
    public static final String HADOOP_JOBS = "hadoopJobs";
    public static final String MAPREDUCE_JOB_TAGS = "mapreduce.job.tags";
    public static final String CHILD_MAPREDUCE_JOB_TAGS = "oozie.child.mapreduce.job.tags";
    public static final String OOZIE_JOB_LAUNCH_TIME = "oozie.job.launch.time";
    public static final String TEZ_APPLICATION_TAGS = "tez.application.tags";
    public static final String SPARK_YARN_TAGS = "spark.yarn.tags";
    public static final String PROPAGATION_CONF_XML = "propagation-conf.xml";
    protected static String[] HADOOP_SITE_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml"};
    private static final String HADOOP_LOG4J_LOCATION = "log4j.properties";
    private static final String DEFAULT_LOG4J_LOCATION = "default-log4j.properties";
    protected Properties log4jProperties = new Properties();

    protected static void run(Class<? extends LauncherMain> klass, String[] args) throws Exception {
        LauncherMain main = klass.newInstance();
        main.setupLog4jProperties();
        main.propagateToHadoopConf();
        main.run(args);
    }

    @VisibleForTesting
    protected void setupLog4jProperties() {
        if (this.tryLoadLog4jPropertiesFromResource(HADOOP_LOG4J_LOCATION)) {
            return;
        }
        this.tryLoadLog4jPropertiesFromResource(DEFAULT_LOG4J_LOCATION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryLoadLog4jPropertiesFromResource(String log4jLocation) {
        System.out.println(String.format("INFO: loading log4j config file %s.", log4jLocation));
        URL log4jUrl = Thread.currentThread().getContextClassLoader().getResource(log4jLocation);
        if (log4jUrl != null) {
            try (InputStream log4jStream = log4jUrl.openStream();){
                this.log4jProperties.load(log4jStream);
                System.out.println(String.format("INFO: log4j config file %s loaded successfully.", log4jLocation));
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                System.out.println(String.format("WARN: log4j config file %s is not readable. Exception message is: %s", log4jLocation, e.getMessage()));
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println(String.format("WARN: log4j config file %s is not present.", log4jLocation));
        }
        System.out.println(String.format("INFO: log4j config file %s could not be loaded.", log4jLocation));
        return false;
    }

    protected static String getHadoopJobIds(String logFile, Pattern[] patterns) {
        LinkedHashSet<String> jobIds = new LinkedHashSet<String>();
        if (!new File(logFile).exists()) {
            System.err.println("Log file: " + logFile + "  not present. Therefore no Hadoop job IDs found.");
        } else {
            try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
                String line = br.readLine();
                while (line != null) {
                    LauncherMain.extractJobIDs(line, patterns, jobIds);
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                System.out.println("WARN: Error getting Hadoop Job IDs. logFile: " + logFile);
                e.printStackTrace(System.out);
            }
        }
        return jobIds.isEmpty() ? null : StringUtils.join(jobIds, (String)",");
    }

    @VisibleForTesting
    protected static void extractJobIDs(String line, Pattern[] patterns, Set<String> jobIds) {
        Preconditions.checkNotNull((Object)line);
        for (Pattern pattern : patterns) {
            String jobId;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find() || StringUtils.isEmpty((String)(jobId = matcher.group(1))) || jobId.equalsIgnoreCase("NULL")) continue;
            jobId = jobId.replaceAll("application", "job");
            jobIds.add(jobId);
        }
    }

    protected static void writeExternalChildIDs(String logFile, Pattern[] patterns, String name) {
        String jobIds = LauncherMain.getHadoopJobIds(logFile, patterns);
        if (jobIds != null) {
            File externalChildIdsFile = new File(System.getProperty(EXTERNAL_CHILD_IDS));
            try (FileOutputStream externalChildIdsStream = new FileOutputStream(externalChildIdsFile);){
                ((OutputStream)externalChildIdsStream).write(jobIds.getBytes());
                System.out.println("Hadoop Job IDs executed by " + name + ": " + jobIds);
                System.out.println();
            }
            catch (IOException e) {
                System.out.println("WARN: Error while writing to external child ids file: " + System.getProperty(EXTERNAL_CHILD_IDS));
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println("No child hadoop job is executed.");
        }
    }

    public static Set<ApplicationId> getChildYarnJobs(Configuration actionConf) {
        return LauncherMain.getChildYarnJobs(actionConf, ApplicationsRequestScope.OWN);
    }

    public static Set<ApplicationId> getChildYarnJobs(Configuration actionConf, ApplicationsRequestScope scope, long startTime) {
        HashSet<ApplicationId> childYarnJobs = new HashSet<ApplicationId>();
        String tag = actionConf.get(CHILD_MAPREDUCE_JOB_TAGS);
        if (tag == null) {
            System.out.print("Could not find YARN tags property oozie.child.mapreduce.job.tags");
            return childYarnJobs;
        }
        System.out.println("tag id : " + tag);
        GetApplicationsRequest gar = GetApplicationsRequest.newInstance();
        gar.setScope(scope);
        gar.setApplicationTags(Collections.singleton(tag));
        long endTime = System.currentTimeMillis();
        if (startTime > endTime) {
            System.out.println("WARNING: Clock skew between the Oozie server host and this host detected.  Please fix this.  Attempting to work around...");
            long diff = 2L * (startTime - endTime);
            startTime -= diff;
            endTime += diff;
        }
        gar.setStartRange(startTime, endTime);
        try {
            ApplicationClientProtocol proxy = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)actionConf, ApplicationClientProtocol.class);
            GetApplicationsResponse apps = proxy.getApplications(gar);
            List appsList = apps.getApplicationList();
            for (ApplicationReport appReport : appsList) {
                childYarnJobs.add(appReport.getApplicationId());
            }
        }
        catch (IOException | YarnException ioe) {
            throw new RuntimeException("Exception occurred while finding child jobs", ioe);
        }
        if (childYarnJobs.isEmpty()) {
            System.out.println("No child applications found");
        } else {
            System.out.println("Found child YARN applications: " + StringUtils.join(childYarnJobs, (String)","));
        }
        return childYarnJobs;
    }

    public static Set<ApplicationId> getChildYarnJobs(Configuration actionConf, ApplicationsRequestScope scope) {
        System.out.println("Fetching child yarn jobs");
        long startTime = actionConf.getLong(OOZIE_JOB_LAUNCH_TIME, 0L);
        if (startTime == 0L) {
            try {
                startTime = Long.parseLong(System.getProperty(OOZIE_JOB_LAUNCH_TIME));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Could not find Oozie job launch time", nfe);
            }
        }
        return LauncherMain.getChildYarnJobs(actionConf, scope, startTime);
    }

    public static void killChildYarnJobs(Configuration actionConf) {
        try {
            Set<ApplicationId> childYarnJobs = LauncherMain.getChildYarnJobs(actionConf);
            if (!childYarnJobs.isEmpty()) {
                System.out.println();
                System.out.println("Found [" + childYarnJobs.size() + "] YARN application(s) from this launcher");
                System.out.println("Killing existing applications and starting over:");
                YarnClient yarnClient = YarnClient.createYarnClient();
                yarnClient.init(actionConf);
                yarnClient.start();
                for (ApplicationId app : childYarnJobs) {
                    System.out.print("Killing [" + app + "] ... ");
                    yarnClient.killApplication(app);
                    System.out.println("Done");
                }
                System.out.println();
            }
        }
        catch (IOException | YarnException ye) {
            throw new RuntimeException("Exception occurred while killing child job(s)", ye);
        }
    }

    protected abstract void run(String[] var1) throws Exception;

    protected static void logMasking(String header, Iterable<Map.Entry<String, String>> conf) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(header + "\n");
        writer.write("--------------------\n");
        PasswordMasker masker = new PasswordMasker();
        for (Map.Entry<String, String> entry : conf) {
            writer.write(" " + entry.getKey() + " : " + masker.mask(entry) + "\n");
        }
        writer.write("--------------------\n");
        writer.close();
        System.out.println(writer.toString());
        System.out.flush();
    }

    protected static String getFilePathFromEnv(String env) {
        String path = System.getenv(env);
        if (path != null && Shell.WINDOWS) {
            if (path.charAt(0) == '\"') {
                path = path.substring(1);
            }
            if (path.charAt(path.length() - 1) == '\"') {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public static Configuration loadActionConf() throws IOException {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        return actionConf;
    }

    protected static void setYarnTag(Configuration actionConf) {
        if (actionConf.get(CHILD_MAPREDUCE_JOB_TAGS) != null) {
            if (actionConf.get(MAPREDUCE_JOB_TAGS) != null) {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get(MAPREDUCE_JOB_TAGS) + "," + actionConf.get(CHILD_MAPREDUCE_JOB_TAGS));
            } else {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get(CHILD_MAPREDUCE_JOB_TAGS));
            }
        }
    }

    protected static void setApplicationTags(Configuration configName, String tagConfigName) {
        if (configName.get(MAPREDUCE_JOB_TAGS) != null) {
            System.out.println("Setting [" + tagConfigName + "] tag: " + configName.get(MAPREDUCE_JOB_TAGS));
            configName.set(tagConfigName, configName.get(MAPREDUCE_JOB_TAGS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileMultiplex(File src, File ... dst) throws IOException {
        FileInputStream is = null;
        OutputStream[] osa = new OutputStream[dst.length];
        try {
            int read;
            is = new FileInputStream(src);
            for (int i = 0; i < osa.length; ++i) {
                osa[i] = new FileOutputStream(dst[i]);
            }
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)is).read(buffer)) > -1) {
                for (OutputStream os : osa) {
                    os.write(buffer, 0, read);
                }
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            for (OutputStream os : osa) {
                if (os == null) continue;
                os.close();
            }
        }
    }

    protected void writeHadoopConfig(String actionXml, File basrDir) throws IOException {
        File actionXmlFile = new File(actionXml);
        System.out.println("Copying " + actionXml + " to " + basrDir + "/" + Arrays.toString(HADOOP_SITE_FILES));
        basrDir.mkdirs();
        File[] dstFiles = new File[HADOOP_SITE_FILES.length];
        for (int i = 0; i < dstFiles.length; ++i) {
            dstFiles[i] = new File(basrDir, HADOOP_SITE_FILES[i]);
        }
        LauncherMain.copyFileMultiplex(actionXmlFile, dstFiles);
    }

    void printArgs(String banner, String[] args) {
        System.out.println(banner);
        boolean maskNextArg = false;
        for (String arg : args) {
            if (maskNextArg) {
                System.out.println("             ********");
                maskNextArg = false;
                continue;
            }
            System.out.println("             " + arg);
            if (!arg.toLowerCase().contains("password")) continue;
            maskNextArg = true;
        }
    }

    public void propagateToHadoopConf() throws IOException {
        Configuration actionConf;
        Configuration propagationConf = new Configuration(false);
        if (System.getProperty("oozie.action.id") != null) {
            propagationConf.set("oozie.action.id", System.getProperty("oozie.action.id"));
        }
        if (System.getProperty("oozie.job.id") != null) {
            propagationConf.set("oozie.job.id", System.getProperty("oozie.job.id"));
        }
        if (System.getProperty("oozie.launcher.job.id") != null) {
            propagationConf.set("oozie.launcher.job.id", System.getProperty("oozie.launcher.job.id"));
        }
        if ((actionConf = LauncherMain.loadActionConf()).get(CHILD_MAPREDUCE_JOB_TAGS) != null) {
            propagationConf.set(MAPREDUCE_JOB_TAGS, actionConf.get(CHILD_MAPREDUCE_JOB_TAGS));
        }
        try (FileWriter writer = new FileWriter(PROPAGATION_CONF_XML);){
            propagationConf.writeXml((Writer)writer);
        }
        Configuration.dumpConfiguration((Configuration)propagationConf, (Writer)new OutputStreamWriter(System.out));
        Configuration.addDefaultResource((String)PROPAGATION_CONF_XML);
    }

    protected static URL createFileWithContentIfNotExists(String filename, Configuration content) throws IOException {
        File output = new File(filename);
        try (FileOutputStream os = LauncherMain.createStreamIfFileNotExists(output);){
            if (os != null) {
                content.writeXml((OutputStream)os);
            }
        }
        return output.toURI().toURL();
    }

    protected static URL createFileWithContentIfNotExists(String filename, Properties content) throws IOException {
        File output = new File(filename);
        try (FileOutputStream os = LauncherMain.createStreamIfFileNotExists(output);){
            if (os != null) {
                content.store(os, "");
            }
        }
        return output.toURI().toURL();
    }

    static FileOutputStream createStreamIfFileNotExists(File output) throws IOException {
        if (output.exists()) {
            System.out.println(output + " exists, skipping. The action will use the " + output.getName() + " defined in the workflow.");
            return null;
        }
        System.out.println("Creating " + output.getAbsolutePath());
        return new FileOutputStream(output);
    }
}

