/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.action.hadoop.FSLauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherURIHandler;

public class LauncherURIHandlerFactory {
    public static final String CONF_LAUNCHER_URIHANDLER_SCHEME_PREFIX = "oozie.launcher.action.urihandler.scheme.";
    private Configuration conf;

    public LauncherURIHandlerFactory(Configuration conf) {
        this.conf = conf;
    }

    public LauncherURIHandler getURIHandler(URI uri) throws LauncherException {
        LauncherURIHandler handler;
        if (uri.getScheme() == null) {
            handler = new FSLauncherURIHandler();
        } else {
            Class<?> clazz;
            String className = this.conf.get(CONF_LAUNCHER_URIHANDLER_SCHEME_PREFIX + uri.getScheme());
            if (className == null) {
                className = this.conf.get("oozie.launcher.action.urihandler.scheme.*");
            }
            if (className == null) {
                throw new LauncherException("Scheme " + uri.getScheme() + " not supported in uri " + uri.toString());
            }
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new LauncherException("Error instantiating LauncherURIHandler", e);
            }
            handler = (LauncherURIHandler)ReflectionUtils.newInstance(clazz, null);
        }
        return handler;
    }
}

