/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class LocalFsOperations {
    private static final int WALK_DEPTH = 2;

    public Configuration readLauncherConf() {
        File confFile = new File("launcher.xml");
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(confFile.getAbsolutePath()));
        return conf;
    }

    public void printContentsOfDir(File folder) throws IOException {
        System.out.println();
        System.out.println("Files in current dir:" + folder.getAbsolutePath());
        System.out.println("======================");
        final java.nio.file.Path root = folder.toPath();
        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 2, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isRegularFile()) {
                    System.out.println("  File: " + root.relativize(file));
                } else if (attrs.isDirectory()) {
                    System.out.println("  Dir: " + root.relativize(file) + "/");
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public String getLocalFileContentAsString(File file, String type, int maxLen) throws IOException {
        if (file.exists()) {
            if (maxLen > -1 && file.length() > (long)maxLen) {
                throw new IOException(type + " data exceeds its limit [" + maxLen + "]");
            }
            return com.google.common.io.Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException("File not found: " + file.toPath().toAbsolutePath());
    }

    public boolean fileExists(File file) {
        return file.exists();
    }
}

