/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.OozieActionConfigurator;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;
import org.apache.oozie.action.hadoop.PasswordMasker;

public class MapReduceMain
extends LauncherMain {
    public static final String OOZIE_MAPREDUCE_UBER_JAR = "oozie.mapreduce.uber.jar";

    public static void main(String[] args) throws Exception {
        MapReduceMain.run(MapReduceMain.class, args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        System.out.println();
        System.out.println("Oozie Map-Reduce action configuration");
        System.out.println("=======================");
        Configuration actionConf = new Configuration(false);
        actionConf.addResource(new Path("file:///", System.getProperty("oozie.action.conf.xml")));
        MapReduceMain.setYarnTag(actionConf);
        JobConf jobConf = new JobConf();
        this.addActionConf(jobConf, actionConf);
        LauncherMain.killChildYarnJobs((Configuration)jobConf);
        MapReduceMain.runConfigClass(jobConf);
        PasswordMasker passwordMasker = new PasswordMasker();
        JobConf maskedJobConf = new JobConf(false);
        for (Map.Entry entry : jobConf) {
            maskedJobConf.set((String)entry.getKey(), passwordMasker.maskPasswordsIfNecessary((String)entry.getValue()));
        }
        MapReduceMain.logMasking("Map-Reduce job configuration:", (Iterable<Map.Entry<String, String>>)maskedJobConf);
        File idFile = new File(System.getProperty("oozie.action.newId"));
        System.out.println("Submitting Oozie action Map-Reduce job");
        System.out.println();
        RunningJob runningJob = this.submitJob(jobConf);
        String jobId = runningJob.getID().toString();
        this.writeJobIdFile(idFile, jobId);
        System.out.println("=======================");
        System.out.println();
    }

    protected void writeJobIdFile(File idFile, String jobId) throws IOException {
        FileOutputStream os = new FileOutputStream(idFile);
        ((OutputStream)os).write(jobId.getBytes());
        ((OutputStream)os).close();
    }

    protected void addActionConf(JobConf jobConf, Configuration actionConf) {
        for (Map.Entry entry : actionConf) {
            jobConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected RunningJob submitJob(JobConf jobConf) throws Exception {
        String uberJar = jobConf.get(OOZIE_MAPREDUCE_UBER_JAR);
        if (uberJar != null && uberJar.trim().length() > 0) {
            jobConf.setJar(uberJar);
        }
        if (MapReduceMain.getFilePathFromEnv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            jobConf.set("mapreduce.job.credentials.binary", MapReduceMain.getFilePathFromEnv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        JobClient jobClient = null;
        RunningJob runJob = null;
        boolean exception = false;
        try {
            jobClient = this.createJobClient(jobConf);
            runJob = jobClient.submitJob(jobConf);
        }
        catch (Exception ex) {
            exception = true;
            throw ex;
        }
        finally {
            try {
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    System.out.println("JobClient Error: " + ex);
                }
                throw ex;
            }
        }
        return runJob;
    }

    protected JobClient createJobClient(JobConf jobConf) throws IOException {
        return new JobClient(jobConf);
    }

    private static void runConfigClass(JobConf actionConf) throws OozieActionConfiguratorException {
        String configClass = actionConf.get("oozie.action.config.class");
        if (configClass != null) {
            try {
                Class<?> klass = Class.forName(configClass);
                Class<OozieActionConfigurator> actionConfiguratorKlass = klass.asSubclass(OozieActionConfigurator.class);
                OozieActionConfigurator actionConfigurator = actionConfiguratorKlass.newInstance();
                actionConfigurator.configure(actionConf);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new OozieActionConfiguratorException("An Exception occurred while instantiating the action config class", e);
            }
        }
    }
}

