/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class PasswordMasker {
    private static final String PASSWORD_MASK = "*****";
    private static final String PASSWORD_KEY = "pass";
    private static final String PASSWORD_CONTAINING_REGEX = "(.*)([\\w[.\\w]*]*(?i)pass[\\w]*=)([\\w]+)(.*)";
    private static final Pattern PASSWORD_CONTAINING_PATTERN = Pattern.compile("(.*)([\\w[.\\w]*]*(?i)pass[\\w]*=)([\\w]+)(.*)");
    private static final String PASSWORD_EXTRACTING_REGEX = "([\\w[.\\w]*]*(?i)pass[\\w]*=)([\\w]+)";
    private static final Pattern PASSWORD_EXTRACTING_PATTERN = Pattern.compile("([\\w[.\\w]*]*(?i)pass[\\w]*=)([\\w]+)");

    public Map<String, String> mask(Map<String, String> unmasked) {
        return Maps.transformEntries(unmasked, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(@Nonnull String key, @Nonnull String value) {
                return PasswordMasker.this.mask(key, value);
            }
        });
    }

    public String mask(Map.Entry<String, String> unmasked) {
        return this.mask(unmasked.getKey(), unmasked.getValue());
    }

    private String mask(String key, String value) {
        if (key == null || value == null || value.isEmpty()) {
            return value;
        }
        if (this.isPasswordKey(key)) {
            return PASSWORD_MASK;
        }
        return this.maskPasswordsIfNecessary(value);
    }

    public String maskPasswordsIfNecessary(String unmasked) {
        if (this.containsPasswordFragment(unmasked)) {
            return this.maskPasswordFragments(unmasked);
        }
        return unmasked;
    }

    private boolean isPasswordKey(String key) {
        return key.toLowerCase().contains(PASSWORD_KEY);
    }

    private boolean containsPasswordFragment(String maybePasswordFragments) {
        if (maybePasswordFragments == null || maybePasswordFragments.length() == 0) {
            return false;
        }
        return PASSWORD_CONTAINING_PATTERN.matcher(maybePasswordFragments).matches();
    }

    private String maskPasswordFragments(String maybePasswordFragments) {
        StringBuilder maskedBuilder = new StringBuilder();
        Matcher passwordFragmentsMatcher = PASSWORD_EXTRACTING_PATTERN.matcher(maybePasswordFragments);
        int start = 0;
        while (passwordFragmentsMatcher.find()) {
            int end = passwordFragmentsMatcher.start();
            maskedBuilder.append(maybePasswordFragments.substring(start, end));
            maskedBuilder.append(passwordFragmentsMatcher.group(1));
            maskedBuilder.append(PASSWORD_MASK);
            start = passwordFragmentsMatcher.end();
        }
        maskedBuilder.append(maybePasswordFragments.substring(start));
        return maskedBuilder.toString();
    }
}

