/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandlerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrepareActionsHandler {
    public void prepareAction(String prepareXML, Configuration conf) throws IOException, SAXException, ParserConfigurationException, LauncherException {
        Document doc = PrepareActionsHandler.getDocumentFromXML(prepareXML);
        doc.getDocumentElement().normalize();
        NodeList nl = doc.getDocumentElement().getChildNodes();
        LauncherURIHandlerFactory factory = new LauncherURIHandlerFactory(conf);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String operation = n.getNodeName();
            if (n.getAttributes() == null || n.getAttributes().getNamedItem("path") == null) continue;
            String pathStr = n.getAttributes().getNamedItem("path").getNodeValue().trim();
            URI uri = new Path(pathStr).toUri();
            LauncherURIHandler handler = factory.getURIHandler(uri);
            this.execute(operation, uri, handler, conf);
        }
    }

    private void execute(String operation, URI uri, LauncherURIHandler handler, Configuration conf) throws LauncherException {
        switch (operation) {
            case "delete": {
                handler.delete(uri, conf);
                break;
            }
            case "mkdir": {
                handler.create(uri, conf);
                break;
            }
            default: {
                System.out.println("Warning: unknown prepare operation " + operation + " -- skipping");
            }
        }
    }

    static Document getDocumentFromXML(String prepareXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setXIncludeAware(true);
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(prepareXML.getBytes("UTF-8"));
        return docBuilder.parse(is);
    }
}

