/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.Charsets;

public class ShellContentWriter {
    private final long maxLen;
    private final OutputStream outputStream;
    private final OutputStream errorStream;
    private final String filename;

    public ShellContentWriter(int maxLenKb, OutputStream outputStream, OutputStream errorStream, String filename) {
        this.outputStream = outputStream;
        this.errorStream = errorStream;
        this.filename = filename;
        this.maxLen = maxLenKb > 0 ? (long)maxLenKb * 1024L : 0L;
    }

    public void print() {
        Path path = Paths.get(this.filename, new String[0]);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                long len = attributes.size();
                if (len < this.maxLen) {
                    byte[] buffer = new byte[(int)len];
                    if (!this.readFile(path, buffer)) {
                        return;
                    }
                    this.writeLine(this.outputStream, "Content of script " + this.filename + " (size = " + len + "b):");
                    this.writeLine(this.outputStream, "------------------------------------");
                    this.writeLine(this.outputStream, buffer);
                    this.writeLine(this.outputStream, "------------------------------------");
                } else {
                    String message = "Not printing script file as configured, content suppressed.";
                    if (this.maxLen > 0L) {
                        message = message + " File size=" + len + "b; max printable size=" + this.maxLen + "b";
                    }
                    this.writeLine(this.errorStream, message);
                }
            } else {
                this.writeLine(this.errorStream, "Path " + this.filename + " doesn't appear to exist");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean readFile(Path path, byte[] buffer) throws IOException {
        int index = 0;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path.toFile()));){
            int c;
            while ((c = ((InputStream)stream).read()) >= 0 && index < buffer.length) {
                if (c < 10) {
                    this.writeLine(this.errorStream, "File " + this.filename + " appears to be a binary file, content suppressed.");
                    boolean bl = false;
                    return bl;
                }
                buffer[index++] = (byte)c;
            }
        }
        return true;
    }

    private void writeLine(OutputStream stream, String s) throws IOException {
        this.writeLine(stream, s.getBytes(Charsets.UTF_8));
    }

    private void writeLine(OutputStream stream, byte[] arr) throws IOException {
        stream.write(arr);
        stream.write(10);
    }
}

