/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.Map;
import org.apache.hadoop.mapred.Counters;
import org.apache.oozie.action.hadoop.ActionStats;
import org.apache.oozie.action.hadoop.ActionType;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.json.simple.JSONObject;

public class OoziePigStats
extends ActionStats {
    PigStats pigStats = null;

    public OoziePigStats(PigStats pigStats) {
        this.currentActionType = ActionType.PIG;
        this.pigStats = pigStats;
    }

    public String toJSON() {
        JSONObject pigStatsGroup = new JSONObject();
        pigStatsGroup.put((Object)"ACTION_TYPE", (Object)this.getCurrentActionType().toString());
        pigStatsGroup.put((Object)"BYTES_WRITTEN", (Object)Long.toString(this.pigStats.getBytesWritten()));
        pigStatsGroup.put((Object)"DURATION", (Object)Long.toString(this.pigStats.getDuration()));
        pigStatsGroup.put((Object)"ERROR_CODE", (Object)Long.toString(this.pigStats.getErrorCode()));
        pigStatsGroup.put((Object)"ERROR_MESSAGE", (Object)this.pigStats.getErrorMessage());
        pigStatsGroup.put((Object)"FEATURES", (Object)this.pigStats.getFeatures());
        pigStatsGroup.put((Object)"HADOOP_VERSION", (Object)this.pigStats.getHadoopVersion());
        pigStatsGroup.put((Object)"NUMBER_JOBS", (Object)Long.toString(this.pigStats.getNumberJobs()));
        pigStatsGroup.put((Object)"PIG_VERSION", (Object)this.pigStats.getPigVersion());
        pigStatsGroup.put((Object)"PROACTIVE_SPILL_COUNT_OBJECTS", (Object)Long.toString(this.pigStats.getProactiveSpillCountObjects()));
        pigStatsGroup.put((Object)"PROACTIVE_SPILL_COUNT_RECORDS", (Object)Long.toString(this.pigStats.getProactiveSpillCountRecords()));
        pigStatsGroup.put((Object)"RECORD_WRITTEN", (Object)Long.toString(this.pigStats.getRecordWritten()));
        pigStatsGroup.put((Object)"RETURN_CODE", (Object)Long.toString(this.pigStats.getReturnCode()));
        pigStatsGroup.put((Object)"SCRIPT_ID", (Object)this.pigStats.getScriptId());
        pigStatsGroup.put((Object)"SMM_SPILL_COUNT", (Object)Long.toString(this.pigStats.getSMMSpillCount()));
        PigStats.JobGraph jobGraph = this.pigStats.getJobGraph();
        StringBuffer sb = new StringBuffer();
        String separator = ",";
        for (JobStats jobStats : jobGraph) {
            String hadoopId = jobStats.getJobId();
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(hadoopId);
            pigStatsGroup.put((Object)hadoopId, (Object)OoziePigStats.toJSONFromJobStats(jobStats));
        }
        pigStatsGroup.put((Object)"JOB_GRAPH", (Object)sb.toString());
        return pigStatsGroup.toJSONString();
    }

    private static JSONObject toJSONFromJobStats(JobStats jobStats) {
        JSONObject jobStatsGroup = new JSONObject();
        jobStatsGroup.put((Object)"HDFS_BYTES_WRITTEN", (Object)Long.toString(jobStats.getHdfsBytesWritten()));
        jobStatsGroup.put((Object)"MAP_INPUT_RECORDS", (Object)Long.toString(jobStats.getMapInputRecords()));
        jobStatsGroup.put((Object)"MAP_OUTPUT_RECORDS", (Object)Long.toString(jobStats.getMapOutputRecords()));
        jobStatsGroup.put((Object)"REDUCE_INPUT_RECORDS", (Object)Long.toString(jobStats.getReduceInputRecords()));
        jobStatsGroup.put((Object)"REDUCE_OUTPUT_RECORDS", (Object)Long.toString(jobStats.getReduceOutputRecords()));
        jobStatsGroup.put((Object)"HADOOP_COUNTERS", (Object)OoziePigStats.toJSONFromCounters(jobStats.getHadoopCounters()));
        jobStatsGroup.put((Object)"Alias", (Object)jobStats.getAlias());
        jobStatsGroup.put((Object)"AVG_MAP_TIME", (Object)Long.toString(jobStats.getAvgMapTime()));
        jobStatsGroup.put((Object)"AVG_REDUCE_TIME", (Object)Long.toString(jobStats.getAvgREduceTime()));
        jobStatsGroup.put((Object)"BYTES_WRITTEN", (Object)Long.toString(jobStats.getBytesWritten()));
        jobStatsGroup.put((Object)"ERROR_MESSAGE", (Object)jobStats.getErrorMessage());
        jobStatsGroup.put((Object)"FEATURE", (Object)jobStats.getFeature());
        jobStatsGroup.put((Object)"JOB_ID", (Object)jobStats.getJobId());
        jobStatsGroup.put((Object)"MAX_MAP_TIME", (Object)Long.toString(jobStats.getMaxMapTime()));
        jobStatsGroup.put((Object)"MIN_MAP_TIME", (Object)Long.toString(jobStats.getMinMapTime()));
        jobStatsGroup.put((Object)"MAX_REDUCE_TIME", (Object)Long.toString(jobStats.getMaxReduceTime()));
        jobStatsGroup.put((Object)"MIN_REDUCE_TIME", (Object)Long.toString(jobStats.getMinReduceTime()));
        jobStatsGroup.put((Object)"NUMBER_MAPS", (Object)Long.toString(jobStats.getNumberMaps()));
        jobStatsGroup.put((Object)"NUMBER_REDUCES", (Object)Long.toString(jobStats.getNumberReduces()));
        jobStatsGroup.put((Object)"PROACTIVE_SPILL_COUNT_OBJECTS", (Object)Long.toString(jobStats.getProactiveSpillCountObjects()));
        jobStatsGroup.put((Object)"PROACTIVE_SPILL_COUNT_RECS", (Object)Long.toString(jobStats.getProactiveSpillCountRecs()));
        jobStatsGroup.put((Object)"RECORD_WRITTEN", (Object)Long.toString(jobStats.getRecordWrittern()));
        jobStatsGroup.put((Object)"SMMS_SPILL_COUNT", (Object)Long.toString(jobStats.getSMMSpillCount()));
        jobStatsGroup.put((Object)"MULTI_STORE_COUNTERS", (Object)OoziePigStats.toJSONFromMultiStoreCounters(jobStats.getMultiStoreCounters()));
        return jobStatsGroup;
    }

    private static JSONObject toJSONFromMultiStoreCounters(Map<String, Long> map) {
        JSONObject group = new JSONObject();
        for (Map.Entry<String, Long> cName : map.entrySet()) {
            group.put((Object)cName.getKey(), (Object)cName.getValue());
        }
        return group;
    }

    private static JSONObject toJSONFromCounters(Counters counters) {
        if (counters == null) {
            return null;
        }
        JSONObject groups = new JSONObject();
        for (String gName : counters.getGroupNames()) {
            JSONObject group = new JSONObject();
            for (Counters.Counter counter : counters.getGroup(gName)) {
                String cName = counter.getName();
                Long cValue = counter.getValue();
                group.put((Object)cName, (Object)Long.toString(cValue));
            }
            groups.put((Object)gName, (Object)group);
        }
        return groups;
    }
}

