/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

public final class ByteUtilities {
    private static final char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ByteUtilities() {
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            byte hi = (byte)Character.digit(s.charAt(i), 16);
            byte lo = (byte)Character.digit(s.charAt(i + 1), 16);
            bytes[pos++] = (byte)(hi * 16 + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        for (byte aByte : bytes) {
            sb.append(ByteUtilities.convertDigit(aByte >> 4));
            sb.append(ByteUtilities.convertDigit(aByte & 0xF));
        }
        return sb.toString();
    }

    private static char convertDigit(int value) {
        return _hex[value & 0xF];
    }
}

