/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Pair;

public class TestCoordinatorEngineSimple
extends XTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testParseJobFilter() throws CoordinatorEngineException {
        CoordinatorEngine ce = new CoordinatorEngine();
        Map map = ce.parseJobFilter("staTus=succeeded; status=waiTing");
        TestCoordinatorEngineSimple.assertNotNull((Object)map);
        TestCoordinatorEngineSimple.assertEquals((int)1, (int)map.size());
        Pair key = (Pair)map.keySet().iterator().next();
        TestCoordinatorEngineSimple.assertNotNull((Object)key);
        TestCoordinatorEngineSimple.assertEquals((String)"status", (String)((String)key.getFirst()));
        TestCoordinatorEngineSimple.assertEquals((Object)CoordinatorEngine.FILTER_COMPARATORS.EQUALS, (Object)key.getSecond());
        List list = (List)map.get(key);
        TestCoordinatorEngineSimple.assertNotNull((Object)list);
        TestCoordinatorEngineSimple.assertEquals((int)2, (int)list.size());
        TestCoordinatorEngineSimple.assertEquals((String)CoordinatorAction.Status.SUCCEEDED.name(), (String)((String)list.get(0)));
        TestCoordinatorEngineSimple.assertEquals((String)CoordinatorAction.Status.WAITING.name(), (String)((String)list.get(1)));
        map = ce.parseJobFilter("nominaltime>=2013-05-01T10:00Z");
        TestCoordinatorEngineSimple.assertNotNull((Object)map);
        TestCoordinatorEngineSimple.assertEquals((int)1, (int)map.size());
        key = (Pair)map.keySet().iterator().next();
        TestCoordinatorEngineSimple.assertNotNull((Object)key);
        TestCoordinatorEngineSimple.assertEquals((String)"nominaltime", (String)((String)key.getFirst()));
        TestCoordinatorEngineSimple.assertEquals((Object)CoordinatorEngine.FILTER_COMPARATORS.GREATER_EQUAL, (Object)key.getSecond());
        list = (List)map.get(key);
        TestCoordinatorEngineSimple.assertNotNull((Object)list);
        TestCoordinatorEngineSimple.assertEquals((int)1, (int)list.size());
        TestCoordinatorEngineSimple.assertEquals((String)"2013-05-01T10:00Z", (String)DateUtils.formatDateOozieTZ((Date)new Date(((Timestamp)list.get(0)).getTime())));
        try {
            ce.parseJobFilter("winniethepooh");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobFilter("stat=some");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobFilter("status=some");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobFilter("status>=some");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobFilter("nominaltime=2013-13-01T00:00Z");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobFilter("nominaltime*2013-13-01T00:00Z");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0421, (Object)bee.getErrorCode());
        }
    }

    public void testParseFilterNegative() throws CoordinatorEngineException {
        CoordinatorEngine ce = new CoordinatorEngine();
        Map map = ce.parseJobsFilter(null);
        TestCoordinatorEngineSimple.assertNotNull((Object)map);
        TestCoordinatorEngineSimple.assertEquals((int)0, (int)map.size());
        map = ce.parseJobsFilter("");
        TestCoordinatorEngineSimple.assertNotNull((Object)map);
        TestCoordinatorEngineSimple.assertEquals((int)0, (int)map.size());
        try {
            ce.parseJobsFilter("winniethepooh");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("kk=vv=zz");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException cee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)cee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("foo=moo");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("status=foo");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("FreQuency=foo");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("UniT=foo");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            ce.parseJobsFilter("unit=minutes");
            TestCoordinatorEngineSimple.fail((String)"CoordinatorEngineException expected.");
        }
        catch (CoordinatorEngineException bee) {
            TestCoordinatorEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
    }

    public void testParseFilterPositive() throws CoordinatorEngineException {
        CoordinatorEngine ce = new CoordinatorEngine();
        Map map = ce.parseJobsFilter("frequency=5;unit=hours;user=foo;status=FAILED");
        TestCoordinatorEngineSimple.assertEquals((int)4, (int)map.size());
        TestCoordinatorEngineSimple.assertEquals((String)"300", (String)((String)((List)map.get("frequency")).get(0)));
        TestCoordinatorEngineSimple.assertEquals((String)"MINUTE", (String)((String)((List)map.get("unit")).get(0)));
        TestCoordinatorEngineSimple.assertEquals((String)"foo", (String)((String)((List)map.get("user")).get(0)));
        TestCoordinatorEngineSimple.assertEquals((String)"FAILED", (String)((String)((List)map.get("status")).get(0)));
    }
}

