/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.DagXLogInfoService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;

public class TestCoordinatorEngineStreamLog
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private CoordinatorEngine createCoordinatorEngine() {
        return new CoordinatorEngine(TestCoordinatorEngineStreamLog.getTestUser());
    }

    public void testCoordLogStreaming() throws Exception {
        this.services.setService(DummyXLogStreamingService.class);
        new DagXLogInfoService().init(this.services);
        CoordinatorEngine ce = this.createCoordinatorEngine();
        String jobId = this.createJobs(6);
        CoordinatorJobBean cjb = ce.getCoordJob(jobId);
        Date createdDate = cjb.getCreatedTime();
        Date endDate = cjb.getEndTime();
        TestCoordinatorEngineStreamLog.assertTrue((boolean)endDate.after(createdDate));
        List list = cjb.getActions();
        Collections.sort(list, new Comparator<CoordinatorAction>(){

            @Override
            public int compare(CoordinatorAction a, CoordinatorAction b) {
                return a.getId().compareTo(b.getId());
            }
        });
        ce.streamLog(jobId, (Writer)new StringWriter(), new HashMap());
        DummyXLogStreamingService service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        XLogFilter filter = service.filter;
        TestCoordinatorEngineStreamLog.assertEquals((String)((String)filter.getFilterParams().get("JOB")), (String)jobId);
        TestCoordinatorEngineStreamLog.assertEquals((Object)cjb.getCreatedTime(), (Object)service.startTime);
        TestCoordinatorEngineStreamLog.assertEquals((Object)cjb.getLastModifiedTime(), (Object)service.endTime);
        ce.streamLog(jobId, null, null, (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        filter = service.filter;
        TestCoordinatorEngineStreamLog.assertEquals((String)((String)filter.getFilterParams().get("JOB")), (String)jobId);
        ce.streamLog(jobId, "1, 3-4, 6", "action", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        filter = service.filter;
        TestCoordinatorEngineStreamLog.assertEquals((String)jobId, (String)((String)filter.getFilterParams().get("JOB")));
        TestCoordinatorEngineStreamLog.assertEquals((String)("(" + jobId + "@1|" + jobId + "@3|" + jobId + "@4|" + jobId + "@6)"), (String)((String)filter.getFilterParams().get("ACTION")));
        long middle = (createdDate.getTime() + endDate.getTime()) / 2L;
        Date middleDate = new Date(middle);
        ce.streamLog(jobId, DateUtils.formatDateOozieTZ((Date)createdDate) + "::" + DateUtils.formatDateOozieTZ((Date)middleDate) + "," + DateUtils.formatDateOozieTZ((Date)middleDate) + "::" + DateUtils.formatDateOozieTZ((Date)endDate), "date", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        filter = service.filter;
        TestCoordinatorEngineStreamLog.assertEquals((String)jobId, (String)((String)filter.getFilterParams().get("JOB")));
        String action = (String)filter.getFilterParams().get("ACTION");
        TestCoordinatorEngineStreamLog.assertEquals((String)("(" + jobId + "@1|" + jobId + "@2|" + jobId + "@3|" + jobId + "@4|" + jobId + "@5|" + jobId + "@6)"), (String)action);
        ce.streamLog(jobId, "2-4", "action", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(1)).getCreatedTime(), (Object)service.startTime);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(3)).getLastModifiedTime(), (Object)service.endTime);
        ce.streamLog(jobId, "5", "action", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(4)).getCreatedTime(), (Object)service.startTime);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(4)).getLastModifiedTime(), (Object)service.endTime);
        ce.streamLog(jobId, "1,2-4,5", "action", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(0)).getCreatedTime(), (Object)service.startTime);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(4)).getLastModifiedTime(), (Object)service.endTime);
        ce.streamLog(jobId, "5,3-4,1", "action", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(0)).getCreatedTime(), (Object)service.startTime);
        TestCoordinatorEngineStreamLog.assertEquals((Object)((CoordinatorAction)list.get(4)).getLastModifiedTime(), (Object)service.endTime);
        ce.streamLog(jobId, DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(1)).getCreatedTime()) + "::" + DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(4)).getLastModifiedTime()) + ",", "date", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((String)((CoordinatorAction)list.get(1)).getCreatedTime().toString(), (String)service.startTime.toString());
        TestCoordinatorEngineStreamLog.assertEquals((String)((CoordinatorAction)list.get(4)).getLastModifiedTime().toString(), (String)service.endTime.toString());
        ce.streamLog(jobId, DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(1)).getCreatedTime()) + "::" + DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(2)).getLastModifiedTime()) + "," + DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(3)).getCreatedTime()) + "::" + DateUtils.formatDateOozieTZ((Date)((CoordinatorAction)list.get(5)).getLastModifiedTime()), "date", (Writer)new StringWriter(), new HashMap());
        service = (DummyXLogStreamingService)this.services.get(XLogStreamingService.class);
        TestCoordinatorEngineStreamLog.assertEquals((String)((CoordinatorAction)list.get(1)).getCreatedTime().toString(), (String)service.startTime.toString());
        TestCoordinatorEngineStreamLog.assertEquals((String)((CoordinatorAction)list.get(5)).getLastModifiedTime().toString(), (String)service.endTime.toString());
        Services.get().getConf().setInt("oozie.coord.actions.log.max.count", 1);
        ce = this.createCoordinatorEngine();
        try {
            ce.streamLog(jobId, "1-3", "action", (Writer)new StringWriter(), new HashMap());
        }
        catch (XException e) {
            TestCoordinatorEngineStreamLog.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E0302);
            TestCoordinatorEngineStreamLog.assertTrue((e.getMessage().indexOf("Retrieving log of too many coordinator actions") != -1 ? 1 : 0) != 0);
        }
        try {
            ce.streamLog(jobId, DateUtils.formatDateOozieTZ((Date)createdDate) + "::" + DateUtils.formatDateOozieTZ((Date)endDate), "date", (Writer)new StringWriter(), new HashMap());
        }
        catch (XException e) {
            TestCoordinatorEngineStreamLog.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E0302);
            TestCoordinatorEngineStreamLog.assertTrue((e.getMessage().indexOf("Retrieving log of too many coordinator actions") != -1 ? 1 : 0) != 0);
        }
    }

    private String createJobs(int numActions) throws Exception {
        long time = System.currentTimeMillis();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, true);
        job.setCreatedTime(new Date(time));
        time += 60000L;
        for (int i = 1; i <= numActions; ++i) {
            CoordinatorActionBean action = this.createCoordAction(job.getId(), i, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, new Date(time));
            action.setCreatedTime(new Date(time));
            action.setLastModifiedTime(new Date(time += 60000L));
            time += 60000L;
            this.addRecordToCoordActionTable(action, null);
        }
        job.setEndTime(new Date(time));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        return job.getId();
    }

    static class DummyXLogStreamingService
    extends XLogStreamingService {
        XLogFilter filter;
        Date startTime;
        Date endTime;

        DummyXLogStreamingService() {
        }

        public void streamLog(XLogStreamer logStreamer, Date startTime, Date endTime, Writer writer) throws IOException {
            this.filter = logStreamer.getXLogFilter();
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

