/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;

public class TestActionFailover
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        Class<ActionStartXCommand> c = ActionStartXCommand.class;
        super.setUp();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        LocalOozie.stop();
        super.tearDown();
    }

    public void testFsFailover() throws Exception {
        Path wf = new Path(this.getFsTestCaseDir(), "workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"failover-fs-wf.xml", (int)-1);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.getFileSystem().create(wf));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", wf.toString());
        conf.setProperty("user.name", TestActionFailover.getTestUser());
        conf.setProperty("group.name", TestActionFailover.getTestGroup());
        Path source = new Path(this.getFsTestCaseDir(), "fsfailover-source");
        this.getFileSystem().mkdirs(source);
        final Path target = new Path(this.getFsTestCaseDir().toString(), "fsfailover-target");
        conf.setProperty("source", source.toString());
        conf.setProperty("target", target.toUri().getPath());
        final String jobId1 = wfClient.submit(conf);
        this.setSystemProperty("oozie.fault.injection", "true");
        this.setSystemProperty("oozie.fault.injection.action.failover", "true");
        try {
            wfClient.start(jobId1);
            TestActionFailover.fail((String)"Should have skipped commit for failover testing");
        }
        catch (OozieClientException oce) {
            TestActionFailover.assertTrue((boolean)oce.getMessage().contains("Skipping Commit for Failover Testing"));
        }
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return TestActionFailover.this.getFileSystem().exists(target);
            }
        });
        TestActionFailover.assertFalse((boolean)this.getFileSystem().exists(target));
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return FaultInjection.isActive((String)"org.apache.oozie.command.SkipCommitFaultInjection");
            }
        });
        TestActionFailover.assertFalse((boolean)FaultInjection.isActive((String)"org.apache.oozie.command.SkipCommitFaultInjection"));
        TestActionFailover.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)wfClient.getJobInfo(jobId1).getStatus());
        WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        List actions = store.getActionsForWorkflow(jobId1, false);
        TestActionFailover.assertEquals((int)1, (int)actions.size());
        WorkflowActionBean action = (WorkflowActionBean)actions.get(0);
        TestActionFailover.assertEquals((Object)WorkflowAction.Status.PREP, (Object)action.getStatus());
        TestActionFailover.assertEquals((String)":START:", (String)action.getType());
        this.setSystemProperty("oozie.fault.injection", "false");
        this.setSystemProperty("oozie.fault.injection.action.failover", "false");
        ActionStartXCommand actionStartCommand = new ActionStartXCommand(action.getId(), action.getType());
        actionStartCommand.call();
        this.sleep(500);
        store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        actions = store.getActionsForWorkflow(jobId1, false);
        action = (WorkflowActionBean)actions.get(0);
        TestActionFailover.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestActionFailover.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        final String jobId2 = wfClient.submit(conf);
        wfClient.start(jobId2);
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId2).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestActionFailover.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId2).getStatus());
    }
}

