/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.decision;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.decision.DecisionActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.ELEvaluator;

public class TestDecisionActionExecutor
extends XFsTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDecision() throws Exception {
        new Services().init();
        try {
            DecisionActionExecutor decision = new DecisionActionExecutor();
            TestDecisionActionExecutor.assertEquals((String)"switch", (String)decision.getType());
            WorkflowActionBean action = new WorkflowActionBean();
            action.setConf("<switch xmlns='uri:oozie:workflow:0.1'><case to='a'>true</case><case to='b'>true</case><case to='c'>false</case><default to='d'/></switch>");
            decision.start((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
            decision.end((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
            TestDecisionActionExecutor.assertEquals((String)"a", (String)action.getExternalStatus());
            action.setConf("<switch xmlns='uri:oozie:workflow:0.1'><case to='a'>false</case><case to='b'>true</case><case to='c'>false</case><default to='d'/></switch>");
            decision.start((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
            decision.end((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
            TestDecisionActionExecutor.assertEquals((String)"b", (String)action.getExternalStatus());
            action.setConf("<switch xmlns='uri:oozie:workflow:0.1'><case to='a'>false</case><case to='b'>false</case><case to='c'>false</case><default to='d'/></switch>");
            decision.start((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
            decision.end((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
            TestDecisionActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
            TestDecisionActionExecutor.assertEquals((String)"d", (String)action.getExternalStatus());
            try {
                action.setConf("<wrong><case to='a'>false</case><case to='b'>false</case><case to='c'>false</case><default to='d'/></switch>");
                decision.start((ActionExecutor.Context)new Context(action), (WorkflowAction)action);
                TestDecisionActionExecutor.fail();
            }
            catch (ActionExecutorException ex) {
                TestDecisionActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.FAILED, (Object)ex.getErrorType());
                TestDecisionActionExecutor.assertEquals((String)"XML_ERROR", (String)ex.getErrorCode());
            }
            catch (Exception ex) {
                TestDecisionActionExecutor.fail();
            }
        }
        finally {
            Services.get().destroy();
        }
    }

    private class Context
    implements ActionExecutor.Context {
        private WorkflowActionBean action;
        boolean executed;
        boolean ended;

        public Context(WorkflowActionBean action) {
            this.action = action;
        }

        public String getCallbackUrl(String externalStatusVar) {
            return ((CallbackService)Services.get().get(CallbackService.class)).createCallBackUrl(this.action.getId(), externalStatusVar);
        }

        public WorkflowAction getAction() {
            return this.action;
        }

        public Configuration getProtoActionConf() {
            throw new UnsupportedOperationException();
        }

        public WorkflowJob getWorkflow() {
            throw new UnsupportedOperationException();
        }

        public ELEvaluator getELEvaluator() {
            throw new UnsupportedOperationException();
        }

        public void setVar(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public String getVar(String name) {
            throw new UnsupportedOperationException();
        }

        public void setStartData(String externalId, String trackerUri, String consoleUrl) {
            this.action.setStartData(externalId, trackerUri, consoleUrl);
        }

        public void setExecutionData(String externalStatus, Properties actionData) {
            this.action.setExecutionData(externalStatus, actionData);
            this.executed = true;
        }

        public void setExecutionStats(String jsonStats) {
            this.action.setExecutionStats(jsonStats);
        }

        public void setExternalChildIDs(String externalChildIDs) {
            this.action.setExternalChildIDs(externalChildIDs);
        }

        public void setEndData(WorkflowAction.Status status, String signalValue) {
            this.action.setEndData(status, signalValue);
            this.ended = true;
        }

        public boolean isRetry() {
            throw new UnsupportedOperationException();
        }

        public boolean isStarted() {
            throw new UnsupportedOperationException();
        }

        public boolean isExecuted() {
            throw new UnsupportedOperationException();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public void setExternalStatus(String externalStatus) {
            this.action.setExternalStatus(externalStatus);
        }

        public String getRecoveryId() {
            return this.action.getId();
        }

        public Path getActionDir() throws URISyntaxException, IOException {
            String name = this.getWorkflow().getId() + "/" + this.action.getName() + "--" + this.action.getType();
            FileSystem fs = this.getAppFileSystem();
            String actionDirPath = Services.get().getSystemId() + "/" + name;
            Path fqActionDir = new Path(fs.getHomeDirectory(), actionDirPath);
            return fqActionDir;
        }

        public FileSystem getAppFileSystem() throws IOException, URISyntaxException {
            return TestDecisionActionExecutor.this.getFileSystem();
        }

        public void setErrorInfo(String str, String exMsg) {
            this.action.setErrorInfo(str, exMsg);
        }
    }
}

