/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.email;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.email.EmailActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TestEmailActionExecutor
extends ActionExecutorTestCase {
    GreenMail server;
    private static final Pattern CHECK_SUBJECT_PATTERN = Pattern.compile("Subject:[^:]*sub");
    private static final Pattern CHECK_TO_PATTERN = Pattern.compile("To:[^:]*abc@oozie.com[^:]*def@oozie.com");
    private static final Pattern CHECK_CC_PATTERN = Pattern.compile("Cc:[^:]*ghi@oozie.com[^:]*jkl@oozie.com");
    private static final Pattern CHECK_BCC_PATTERN = Pattern.compile("To:[^:]*nmo@oozie.com[^:]*pqr@oozie.com");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = new GreenMail();
        this.server.start();
    }

    private ActionExecutorTestCase.Context createNormalContext(String actionXml) throws Exception {
        EmailActionExecutor ae = new EmailActionExecutor();
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.email.smtp.port", this.server.getSmtp().getPort());
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setBoolean("oozie.email.smtp.auth", false);
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().set("oozie.email.smtp.username", "");
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().set("oozie.email.smtp.password", "");
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestEmailActionExecutor.getTestUser());
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "email-action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(wf, action);
    }

    private ActionExecutorTestCase.Context createAuthContext(String actionXml) throws Exception {
        ActionExecutorTestCase.Context ctx = this.createNormalContext(actionXml);
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setBoolean("oozie.email.smtp.auth", true);
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().set("oozie.email.smtp.username", "oozie@localhost");
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().set("oozie.email.smtp.password", "oozie");
        return ctx;
    }

    private Element prepareEmailElement(Boolean ccs, boolean bccs) throws JDOMException {
        StringBuilder elem = new StringBuilder();
        elem.append("<email xmlns=\"uri:oozie:email-action:0.1\">");
        elem.append("<to>    abc@oozie.com, def@oozie.com    </to>");
        if (ccs.booleanValue()) {
            elem.append("<cc>ghi@oozie.com,jkl@oozie.com</cc>");
        }
        if (bccs) {
            elem.append("<bcc>nmo@oozie.com,pqr@oozie.com</bcc>");
        }
        elem.append("<subject>sub</subject>");
        elem.append("<body>bod</body>");
        elem.append("</email>");
        return XmlUtils.parseXml((String)elem.toString());
    }

    private Element prepareBadElement(String elem) throws JDOMException {
        Element good = this.prepareEmailElement(true, true);
        good.getChild("email").addContent((Content)new Element(elem));
        return good;
    }

    private void checkEmail(MimeMessage msg, boolean ccs, boolean bccs) {
        String header = GreenMailUtil.getHeaders((Part)msg);
        TestEmailActionExecutor.assertNotNull((Object)header);
        TestEmailActionExecutor.assertTrue((boolean)CHECK_SUBJECT_PATTERN.matcher(header).find());
        TestEmailActionExecutor.assertTrue((boolean)CHECK_TO_PATTERN.matcher(header).find());
        boolean containsCC = CHECK_CC_PATTERN.matcher(header).find();
        if (ccs) {
            TestEmailActionExecutor.assertTrue((boolean)containsCC);
        } else {
            TestEmailActionExecutor.assertFalse((boolean)containsCC);
        }
        boolean containsBCC = CHECK_BCC_PATTERN.matcher(header).find();
        if (ccs) {
            TestEmailActionExecutor.assertTrue((boolean)containsBCC);
        } else {
            TestEmailActionExecutor.assertFalse((boolean)containsBCC);
        }
        TestEmailActionExecutor.assertEquals((String)"bod", (String)GreenMailUtil.getBody((Part)msg));
    }

    public void testSetupMethods() {
        EmailActionExecutor email = new EmailActionExecutor();
        TestEmailActionExecutor.assertEquals((String)"email", (String)email.getType());
    }

    public void testDoNormalEmail() throws Exception {
        EmailActionExecutor email = new EmailActionExecutor();
        email.validateAndMail((ActionExecutor.Context)this.createNormalContext("email-action"), this.prepareEmailElement(false, false));
        this.checkEmail(this.server.getReceivedMessages()[0], false, false);
    }

    public void testDoAuthEmail() throws Exception {
        EmailActionExecutor email = new EmailActionExecutor();
        email.validateAndMail((ActionExecutor.Context)this.createAuthContext("email-action"), this.prepareEmailElement(true, true));
        this.checkEmail(this.server.getReceivedMessages()[0], true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerTimeouts() throws Exception {
        final ServerSocket srvSocket = new ServerSocket(0);
        int srvPort = srvSocket.getLocalPort();
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                try {
                    Socket clientSocket = srvSocket.accept();
                    Thread.sleep(1000L);
                    clientSocket.getOutputStream().write(0);
                    clientSocket.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        serverThread.setDaemon(true);
        try {
            serverThread.start();
            EmailActionExecutor email = new EmailActionExecutor();
            ActionExecutorTestCase.Context ctx = this.createNormalContext("email-action");
            ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.email.smtp.port", srvPort);
            ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.email.smtp.socket.timeout.ms", 100);
            try {
                email.validateAndMail((ActionExecutor.Context)ctx, this.prepareEmailElement(false, false));
                TestEmailActionExecutor.fail((String)"Should have failed with a socket timeout error!");
            }
            catch (Exception e) {
                Throwable rootCause = e;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                TestEmailActionExecutor.assertTrue((String)("Expected exception type to be a SocketTimeoutException, but received: " + rootCause), (boolean)(rootCause instanceof SocketTimeoutException));
                TestEmailActionExecutor.assertTrue((String)("Expected error to be that of a socket read timeout, but got: " + rootCause.getMessage()), (boolean)rootCause.getMessage().contains("Read timed out"));
            }
        }
        finally {
            serverThread.interrupt();
            srvSocket.close();
        }
    }

    public void testValidation() throws Exception {
        EmailActionExecutor email = new EmailActionExecutor();
        ActionExecutorTestCase.Context ctx = this.createNormalContext("email-action");
        try {
            email.validateAndMail((ActionExecutor.Context)ctx, this.prepareBadElement("to"));
            TestEmailActionExecutor.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            email.validateAndMail((ActionExecutor.Context)ctx, this.prepareBadElement("cc"));
            TestEmailActionExecutor.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            email.validateAndMail((ActionExecutor.Context)ctx, this.prepareBadElement("bcc"));
            TestEmailActionExecutor.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            email.validateAndMail((ActionExecutor.Context)ctx, this.prepareBadElement("subject"));
            TestEmailActionExecutor.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            email.validateAndMail((ActionExecutor.Context)ctx, this.prepareBadElement("body"));
            TestEmailActionExecutor.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testContentTypeDefault() throws Exception {
        EmailActionExecutor email = new EmailActionExecutor();
        email.validateAndMail((ActionExecutor.Context)this.createAuthContext("email-action"), this.prepareEmailElement(true, true));
        this.checkEmail(this.server.getReceivedMessages()[0], true, true);
        TestEmailActionExecutor.assertTrue((boolean)this.server.getReceivedMessages()[0].getContentType().contains("text/plain"));
    }

    public void testContentType() throws Exception {
        StringBuilder elem = new StringBuilder();
        elem.append("<email xmlns=\"uri:oozie:email-action:0.2\">");
        elem.append("<to>purushah@yahoo-inc.com</to>");
        elem.append("<subject>sub</subject>");
        elem.append("<content_type>text/html</content_type>");
        elem.append("<body>&lt;body&gt; This is a test mail &lt;/body&gt;</body>");
        elem.append("</email>");
        EmailActionExecutor emailContnetType = new EmailActionExecutor();
        emailContnetType.validateAndMail((ActionExecutor.Context)this.createAuthContext("email-action"), XmlUtils.parseXml((String)elem.toString()));
        TestEmailActionExecutor.assertEquals((String)"<body> This is a test mail </body>", (String)GreenMailUtil.getBody((Part)this.server.getReceivedMessages()[0]));
        TestEmailActionExecutor.assertTrue((boolean)this.server.getReceivedMessages()[0].getContentType().contains("text/html"));
    }

    public void testLocalFileAttachmentError() throws Exception {
        File attachFile1 = new File(this.getTestCaseDir() + File.separator + "attachment1.txt");
        String content1 = "this is attachment content in file1";
        File attachFile2 = new File(this.getTestCaseDir() + File.separator + "attachment2.txt");
        String content2 = "this is attachment content in file2";
        BufferedWriter output = new BufferedWriter(new FileWriter(attachFile1));
        output.write(content1);
        output.close();
        output = new BufferedWriter(new FileWriter(attachFile2));
        output.write(content2);
        output.close();
        StringBuilder tag = new StringBuilder();
        tag.append("file://").append(attachFile1.getAbsolutePath()).append(",file://").append(attachFile2.getAbsolutePath());
        try {
            this.assertAttachment(tag.toString(), 0, content1, content2);
            TestEmailActionExecutor.fail();
        }
        catch (ActionExecutorException e) {
            TestEmailActionExecutor.assertEquals((String)"EM008", (String)e.getErrorCode());
        }
    }

    public void testHDFSFileAttachment() throws Exception {
        String file1 = "file1";
        Path path1 = new Path(this.getFsTestCaseDir(), file1);
        String content1 = "this is attachment content in file1";
        String file2 = "file2";
        Path path2 = new Path(this.getFsTestCaseDir(), file2);
        String content2 = "this is attachment content in file2";
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path1, true));
        writer.write(content1);
        ((Writer)writer).close();
        writer = new OutputStreamWriter((OutputStream)fs.create(path2, true));
        writer.write(content2);
        ((Writer)writer).close();
        StringBuilder tag = new StringBuilder();
        tag.append(path1.toString()).append(",").append(path2.toString());
        this.assertAttachment(tag.toString(), 2, content1, content2);
        ConfigurationService.setBoolean((String)"oozie.email.attachment.enabled", (boolean)false);
        this.sendAndReceiveEmail(tag.toString());
        MimeMessage retMeg = this.server.getReceivedMessages()[1];
        String msgBody = GreenMailUtil.getBody((Part)retMeg);
        TestEmailActionExecutor.assertEquals((int)msgBody.indexOf("This is a test mail"), (int)0);
        TestEmailActionExecutor.assertNotSame((Object)msgBody.indexOf("\n Note: This email is missing configured email attachments as sending attachments in email action is disabled in the Oozie server. It could be for security compliance with data protection or other reasons"), (Object)-1);
        TestEmailActionExecutor.assertFalse((boolean)(retMeg.getContent() instanceof Multipart));
        TestEmailActionExecutor.assertTrue((boolean)retMeg.getContentType().contains("text/plain"));
    }

    private void assertAttachment(String attachtag, int attachCount, String content1, String content2) throws Exception {
        this.sendAndReceiveEmail(attachtag);
        MimeMessage retMeg = this.server.getReceivedMessages()[0];
        Multipart retParts = (Multipart)retMeg.getContent();
        int numAttach = 0;
        for (int i = 0; i < retParts.getCount(); ++i) {
            BodyPart bp = retParts.getBodyPart(i);
            String disp = bp.getDisposition();
            String retValue = IOUtils.toString((InputStream)bp.getInputStream());
            if (disp != null && disp.equals("attachment")) {
                TestEmailActionExecutor.assertTrue((retValue.equals(content1) || retValue.equals(content2) ? 1 : 0) != 0);
                ++numAttach;
                continue;
            }
            TestEmailActionExecutor.assertEquals((String)"This is a test mail", (String)retValue);
        }
        TestEmailActionExecutor.assertEquals((int)attachCount, (int)numAttach);
    }

    private void sendAndReceiveEmail(String attachtag) throws Exception {
        StringBuilder elem = new StringBuilder();
        elem.append("<email xmlns=\"uri:oozie:email-action:0.2\">");
        elem.append("<to>oozie@yahoo-inc.com</to>");
        elem.append("<subject>sub</subject>");
        elem.append("<body>This is a test mail</body>");
        elem.append("<attachment>").append(attachtag).append("</attachment>");
        elem.append("</email>");
        EmailActionExecutor emailExecutor = new EmailActionExecutor();
        emailExecutor.validateAndMail((ActionExecutor.Context)this.createAuthContext("email-action"), XmlUtils.parseXml((String)elem.toString()));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.server.stop();
    }
}

