/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.XHCatTestCase;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public abstract class ActionExecutorTestCase
extends XHCatTestCase {
    @Override
    protected void setUp() throws Exception {
        this.beforeSetUp();
        super.setUp();
        this.setSystemProps();
        new Services().init();
    }

    protected void setSystemProps() throws Exception {
    }

    protected void beforeSetUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
        if (Services.get() != null) {
            Services.get().destroy();
        }
        super.tearDown();
    }

    protected Path getAppPath() {
        Path baseDir = this.getFsTestCaseDir();
        return new Path(baseDir, "app");
    }

    protected XConfiguration getBaseProtoConf() {
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", ActionExecutorTestCase.getTestUser());
        return protoConf;
    }

    protected WorkflowJobBean createBaseWorkflow(XConfiguration protoConf, String actionName) throws Exception {
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        String content = "<workflow-app xmlns='uri:oozie:workflow:1.0'  xmlns:sla='uri:oozie:sla:0.1' name='no-op-wf'>";
        content = content + "<start to='end' />";
        content = content + "<end name='end' /></workflow-app>";
        this.writeToFile(content, this.getAppPath(), "workflow.xml");
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("user.name", ActionExecutorTestCase.getTestUser());
        wfConf.set("oozie.wf.application.path", appUri.toString());
        WorkflowJobBean workflow = this.createWorkflow((WorkflowApp)app, (Configuration)wfConf, protoConf);
        WorkflowActionBean action = new WorkflowActionBean();
        action.setName(actionName);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(workflow.getId(), actionName));
        workflow.getActions().add(action);
        return workflow;
    }

    protected WorkflowJobBean createBaseWorkflowWithCredentials(XConfiguration protoConf, String actionName) throws Exception {
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-credentials.xml", (int)-1);
        String wfxml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
        this.writeToFile(wfxml, this.getAppPath(), "workflow.xml");
        LiteWorkflowApp app = new LiteWorkflowApp("test-wf-cred", wfxml, new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "start")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("user.name", ActionExecutorTestCase.getTestUser());
        wfConf.set("oozie.wf.application.path", appUri.toString());
        WorkflowJobBean workflow = this.createWorkflow((WorkflowApp)app, (Configuration)wfConf, protoConf);
        WorkflowActionBean action = new WorkflowActionBean();
        action.setName(actionName);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(workflow.getId(), actionName));
        workflow.getActions().add(action);
        return workflow;
    }

    private WorkflowJobBean createWorkflow(WorkflowApp app, Configuration conf, XConfiguration protoConf) throws Exception {
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance(app, conf);
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(wfInstance.getId());
        workflow.setAppName(app.getName());
        workflow.setAppPath(conf.get("oozie.wf.application.path"));
        workflow.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        workflow.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        workflow.setCreatedTime(new Date());
        workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
        workflow.setStatus(WorkflowJob.Status.PREP);
        workflow.setRun(0);
        workflow.setUser(conf.get("user.name"));
        workflow.setGroup(conf.get("group.name"));
        workflow.setWorkflowInstance(wfInstance);
        return workflow;
    }

    private void writeToFile(String content, Path appPath, String fileName) throws IOException {
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, fileName), true));
        writer.write(content);
        ((Writer)writer).close();
    }

    public class Context
    implements ActionExecutor.Context {
        private WorkflowActionBean action;
        private WorkflowJobBean workflow;
        boolean started;
        boolean executed;
        boolean ended;
        private Map<String, String> vars = new HashMap<String, String>();

        public Context(WorkflowJobBean workflow, WorkflowActionBean action) {
            this.workflow = workflow;
            this.action = action;
        }

        public String getCallbackUrl(String externalStatusVar) {
            return ((CallbackService)Services.get().get(CallbackService.class)).createCallBackUrl(this.action.getId(), externalStatusVar);
        }

        public Configuration getProtoActionConf() {
            String s = this.workflow.getProtoActionConf();
            try {
                return new XConfiguration((Reader)new StringReader(s));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public WorkflowJob getWorkflow() {
            return this.workflow;
        }

        public WorkflowAction getAction() {
            return this.action;
        }

        public ELEvaluator getELEvaluator() {
            ELEvaluator evaluator = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
            DagELFunctions.configureEvaluator((ELEvaluator)evaluator, (WorkflowJobBean)this.workflow, (WorkflowActionBean)this.action);
            try {
                XConfiguration xconf = new XConfiguration((Reader)new StringReader(this.action.getConf()));
                for (Map.Entry entry : xconf) {
                    evaluator.setVariable((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return evaluator;
        }

        public void setVar(String name, String value) {
            if (value != null) {
                this.vars.put(name, value);
            } else {
                this.vars.remove(name);
            }
        }

        public String getVar(String name) {
            return this.vars.get(name);
        }

        public void setStartData(String externalId, String trackerUri, String consoleUrl) {
            this.action.setStartData(externalId, trackerUri, consoleUrl);
            this.started = true;
        }

        public void setExecutionData(String externalStatus, Properties actionData) {
            this.action.setExecutionData(externalStatus, actionData);
            this.executed = true;
        }

        public String getExecutionStats() {
            return this.action.getExecutionStats();
        }

        public void setExecutionStats(String jsonStats) {
            this.action.setExecutionStats(jsonStats);
        }

        public String getExternalChildIDs() {
            return this.action.getExternalChildIDs();
        }

        public void setExternalChildIDs(String externalChildIDs) {
            this.action.setExternalChildIDs(externalChildIDs);
        }

        public void setEndData(WorkflowAction.Status status, String signalValue) {
            this.action.setEndData(status, signalValue);
            this.ended = true;
        }

        public boolean isRetry() {
            throw new UnsupportedOperationException();
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public boolean isEnded() {
            return this.ended;
        }

        public void setExternalStatus(String externalStatus) {
            this.action.setExternalStatus(externalStatus);
        }

        public String getRecoveryId() {
            return this.action.getId();
        }

        public Path getActionDir() throws URISyntaxException, IOException {
            String name = this.getWorkflow().getId() + "/" + this.action.getName() + "--" + this.action.getType();
            FileSystem fs = this.getAppFileSystem();
            String actionDirPath = Services.get().getSystemId() + "/" + name;
            Path fqActionDir = new Path(fs.getHomeDirectory(), actionDirPath);
            return fqActionDir;
        }

        public FileSystem getAppFileSystem() throws IOException, URISyntaxException {
            return ActionExecutorTestCase.this.getFileSystem();
        }

        public void setErrorInfo(String str, String exMsg) {
            this.action.setErrorInfo(str, exMsg);
        }
    }
}

