/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;

public class MapperReducerCredentialsForTest
implements Mapper,
Reducer {
    public static final String COUNTER_GROUP = "cg";
    public static final String COUNTER_OUTPUT_DATA = "cod";
    public static final String TEST_CRED = "testcred";
    String credential = null;

    public static void main(String[] args) {
        System.out.println("hello!");
    }

    public void configure(JobConf jobConf) {
        this.credential = jobConf.get(TEST_CRED);
    }

    public void close() throws IOException {
    }

    public void map(Object key, Object value, OutputCollector collector, Reporter reporter) throws IOException {
        collector.collect(key, value);
        if (this.credential != null) {
            reporter.incrCounter(COUNTER_GROUP, COUNTER_OUTPUT_DATA, 1L);
        }
    }

    public void reduce(Object key, Iterator values, OutputCollector collector, Reporter reporter) throws IOException {
        while (values.hasNext()) {
            collector.collect(key, values.next());
        }
    }

    public static boolean hasCredentials(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean output = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup(COUNTER_GROUP)) != null) {
            output = group.getCounter(COUNTER_OUTPUT_DATA) > 0L;
        }
        return output;
    }
}

